/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.TLA;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import obp2.language.TLA.runtime.TLAConfiguration;
import obp2.runtime.core.TreeItem;
import obp2.runtime.core.defaults.DefaultTreeProjector;
import plug.utils.Pair;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.value.BoolValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.ModelValue;
import tlc2.value.RecordValue;
import tlc2.value.SetEnumValue;
import tlc2.value.StringValue;
import tlc2.value.TupleValue;
import tlc2.value.UndefValue;
import tlc2.value.Value;
import util.UniqueString;

public class TLARuntimeView
extends DefaultTreeProjector<TLAConfiguration, Pair<Action, StateVec>, Void> {
    public TreeItem projectConfiguration(TLAConfiguration value) {
        ArrayList<TreeItem> children = new ArrayList<TreeItem>();
        for (Map.Entry item : value.getState().getVals().entrySet()) {
            children.add(this.getConfigurationItem((UniqueString)item.getKey(), (Value)item.getValue()));
        }
        return new TreeItem("TLA+", children);
    }

    public TreeItem projectFireable(Pair<Action, StateVec> action) {
        return new TreeItem(((Action)action.a).toString() + "\n" + ((Action)action.a).getName().toString());
    }

    String getSimpleName(UniqueString name, Value value, String separator) {
        return (name == null ? "" : name + separator) + value;
    }

    TreeItem getConfigurationItem(UniqueString name, Value value) {
        if (value instanceof FcnRcdValue) {
            return this.getConfigurationItem(name, (FcnRcdValue)value);
        }
        if (value instanceof SetEnumValue) {
            return this.getConfigurationItem(name, (SetEnumValue)value);
        }
        if (value instanceof RecordValue) {
            return this.getConfigurationItem(name, (RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return this.getConfigurationItem(name, (TupleValue)value);
        }
        if (value instanceof IntValue || value instanceof BoolValue || value instanceof StringValue || value instanceof UndefValue || value instanceof ModelValue) {
            return new TreeItem("entry", this.getSimpleName(name, value, " = "), null, null);
        }
        return new TreeItem("entry", this.getSimpleName(name, value, " = "), null, null);
    }

    TreeItem getConfigurationItem(UniqueString name, TupleValue value) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (int i = 0; i < value.elems.length; ++i) {
            items.add(this.getConfigurationItem(null, value.elems[i]));
        }
        return new TreeItem("tuple", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    TreeItem getConfigurationItem(UniqueString name, RecordValue value) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (int i = 0; i < value.names.length; ++i) {
            items.add(this.getConfigurationItem(value.names[i], value.values[i]));
        }
        return new TreeItem("setenum", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    TreeItem getConfigurationItem(UniqueString name, SetEnumValue value) {
        if (!value.isNormalized()) {
            value.normalize();
        }
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (int i = 0; i < value.elems.size(); ++i) {
            items.add(this.getConfigurationItem(null, value.elems.elementAt(i)));
        }
        return new TreeItem("setenum", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    TreeItem getConfigurationItem(UniqueString name, FcnRcdValue value) {
        if (value.values.length == 0) {
            return new TreeItem("entry", name + " = << >>", null, null);
        }
        Method isRcd = null;
        Method isTuple = null;
        for (Method method : value.getClass().getDeclaredMethods()) {
            if (method.getName().equals("isRcd")) {
                method.setAccessible(true);
                isRcd = method;
            }
            if (!method.getName().equals("isTuple")) continue;
            method.setAccessible(true);
            isTuple = method;
        }
        try {
            if (isRcd != null && isTuple != null) {
                int i;
                ArrayList<TreeItem> items = new ArrayList<TreeItem>();
                if (((Boolean)isRcd.invoke((Object)value, new Object[0])).booleanValue()) {
                    for (i = 0; i < value.values.length; ++i) {
                        items.add(new TreeItem("recordItem", ((StringValue)value.domain[0]).val + " |-> " + value.values[i], null, Collections.singletonList(this.getConfigurationItem(((StringValue)value.domain[0]).val, value.values[i]))));
                    }
                    return new TreeItem("record", this.getSimpleName(name, (Value)value, " = "), null, items);
                }
                if (((Boolean)isTuple.invoke((Object)value, new Object[0])).booleanValue()) {
                    for (i = 0; i < value.values.length; ++i) {
                        items.add(new TreeItem("tupleItem", value.values[i].toString(), null, Collections.singletonList(this.getConfigurationItem(null, value.values[i]))));
                    }
                    return new TreeItem("tuple", this.getSimpleName(name, (Value)value, " = "), null, items);
                }
                for (i = 0; i < value.values.length; ++i) {
                    items.add(new TreeItem("array", value.domain[0] + " :> " + value.values[i], null, Collections.singletonList(this.getConfigurationItem(null, value.values[i]))));
                }
                return new TreeItem("array", this.getSimpleName(name, (Value)value, " = "), null, items);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.getConfigurationItem(name, (Value)value);
    }
}

