/*
 * Decompiled with CFR 0.152.
 */
package obp2.statespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.IGraphAccess;
import obp2.core.IStateSpaceManager;
import obp2.statespace.IConfigurationStorage;
import obp2.statespace.ITransitionStorage;
import obp2.statespace.configurations.CountingConfigurationStorage;
import obp2.statespace.configurations.FullConfigurationStorage;
import obp2.statespace.configurations.MockConfigurationStorage;
import obp2.statespace.graph.CountingTransitionStorage;
import obp2.statespace.graph.FullTransitionStorage;
import obp2.statespace.graph.MockTransitionStorage;
import obp2.statespace.graph.ParentTransitionStorage;

public class SimpleStateSpaceManager<C extends IConfiguration, A, O>
implements IStateSpaceManager<C, A, O>,
IGraphAccess<C, A, O> {
    Set<C> initialConfigurations = new HashSet<C>();
    IConfigurationStorage<C> configurationStorage;
    public ITransitionStorage<C, A, O> transitionStorage;

    public SimpleStateSpaceManager() {
        this(false);
    }

    public SimpleStateSpaceManager(boolean fullTransition) {
        this.fullConfigurationStorage();
        if (fullTransition) {
            this.fullTransitionStorage();
        } else {
            this.noTransitionStorage();
        }
    }

    public IStateSpaceManager<C, A, O> noConfigurationStorage() {
        this.configurationStorage = new MockConfigurationStorage();
        return this;
    }

    public IStateSpaceManager<C, A, O> countingConfigurationStorage() {
        this.configurationStorage = new CountingConfigurationStorage();
        return this;
    }

    public IStateSpaceManager<C, A, O> fullConfigurationStorage() {
        this.configurationStorage = new FullConfigurationStorage();
        ((FullConfigurationStorage)this.configurationStorage).setStorageBackend(new HashMap());
        return this;
    }

    public IStateSpaceManager<C, A, O> noTransitionStorage() {
        this.transitionStorage = new MockTransitionStorage();
        return this;
    }

    public IStateSpaceManager<C, A, O> countingTransitionStorage() {
        this.transitionStorage = new CountingTransitionStorage();
        return this;
    }

    public IStateSpaceManager<C, A, O> parentTransitionStorage() {
        this.transitionStorage = new ParentTransitionStorage();
        return this;
    }

    public IStateSpaceManager<C, A, O> fullTransitionStorage() {
        this.transitionStorage = new FullTransitionStorage();
        return this;
    }

    public Set<C> initialConfigurations() {
        return this.initialConfigurations;
    }

    public IFiredTransition<C, A, O> putTransition(IFiredTransition<C, A, O> transition) {
        assert (transition.getTargets() != null && !transition.getTargets().isEmpty());
        return this.transitionStorage.put(transition);
    }

    public synchronized C get(C state) {
        return (C)((IConfiguration)this.configurationStorage.get(state));
    }

    public synchronized C put(C state) {
        return (C)((IConfiguration)this.configurationStorage.put(state));
    }

    public synchronized C putInitial(C state) {
        this.initialConfigurations.add(state);
        return (C)((IConfiguration)this.configurationStorage.put(state));
    }

    public int size() {
        return this.configurationStorage.size();
    }

    public int transitionCount() {
        return this.transitionStorage.size();
    }

    public Collection<C> getInitialVertices() {
        return this.initialConfigurations;
    }

    public Collection<C> getSources() {
        return this.initialConfigurations;
    }

    public Collection<C> getSinks() {
        ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
        for (IConfiguration reached : this.getVertices()) {
            if (!this.getOutgoingEdges((C)reached).isEmpty()) continue;
            result.add(reached);
        }
        return result;
    }

    public Collection<C> getVertices() {
        return this.configurationStorage.getConfigurations();
    }

    public C getParent(C vertex) {
        return this.transitionStorage.getParent(vertex);
    }

    public Collection<C> fanout(C vertex) {
        HashSet targets = new HashSet();
        for (IFiredTransition<C, A, O> fired : this.transitionStorage.getFiredFrom(vertex)) {
            targets.addAll(fired.getTargets());
        }
        return targets;
    }

    public Collection<IFiredTransition<C, A, O>> getOutgoingEdges(C vertex) {
        return this.transitionStorage.getFiredFrom(vertex);
    }

    public Collection<IFiredTransition<C, A, O>> getIncomingEdges(C vertex) {
        return this.transitionStorage.getFiredTo(vertex);
    }

    public IGraphAccess<C, A, O> getGraphView() {
        return this;
    }

    public int getVertexCount() {
        return this.size();
    }

    public int getEdgeCount() {
        return this.transitionStorage.getEdgeCount();
    }
}

