/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

public final class ObjLongTable {
    private int count;
    private int length;
    private int thresh;
    private Object[] keys;
    private long[] elems;

    public ObjLongTable(int size) {
        this.keys = new Object[size];
        this.elems = new long[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
    }

    private final void grow() {
        Object[] oldKeys = this.keys;
        long[] oldElems = this.elems;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.keys = new Object[this.length];
        this.elems = new long[this.length];
        for (int i = 0; i < oldKeys.length; ++i) {
            Object key = oldKeys[i];
            if (key == null) continue;
            this.put(key, oldElems[i]);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int put(Object k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            Object key;
            if ((key = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key.equals(k)) {
                this.elems[loc] = elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int add(Object k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            Object key;
            if ((key = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key.equals(k)) {
                int n = loc;
                this.elems[n] = this.elems[n] + elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final long get(Object k) {
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        Object key;
        while ((key = this.keys[loc]) != null) {
            if (key.equals(k)) {
                return this.elems[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return 0L;
    }

    public final String[] sortStringKeys() {
        String[] res = new String[this.count];
        int idx = -1;
        for (int i = 0; i < this.length; ++i) {
            String key = (String)this.keys[i];
            if (key == null) continue;
            for (int j = idx; j >= 0 && res[j].compareTo(key) > 0; --j) {
                res[j + 1] = res[j];
            }
            res[j + 1] = key;
            ++idx;
        }
        return res;
    }

    public final Enumerator keys() {
        return new Enumerator();
    }

    public final class Enumerator {
        int index = 0;

        public final Object nextElement() {
            while (this.index < ObjLongTable.this.keys.length) {
                if (ObjLongTable.this.keys[this.index] != null) {
                    return ObjLongTable.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }
    }
}

