/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import obp2.language.TLA.runtime.TLAConfiguration;
import obp2.language.TLA.runtime.TLATransitionRelation;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.utils.Pair;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.util.Context;
import tlc2.value.BoolValue;
import tlc2.value.Value;
import util.UniqueString;

public class TLAAtomicPropositionsEvaluator
extends DefaultLanguageService<TLAConfiguration, Pair<Action, StateVec>, Void>
implements IAtomicPropositionsEvaluator<TLAConfiguration, Pair<Action, StateVec>, Void> {
    private final TLATransitionRelation transitionRelation;
    List<Predicate<TLAConfiguration>> testers;
    protected final List<String> atomicPropositions = new ArrayList<String>();

    public TLAAtomicPropositionsEvaluator(TLATransitionRelation transitionRelation) {
        this.transitionRelation = transitionRelation;
    }

    public int[] registerAtomicPropositions(String[] atomicPropositions) throws Exception {
        int[] indexes = new int[atomicPropositions.length];
        if (atomicPropositions.length < 1) {
            return new int[0];
        }
        this.testers = new ArrayList<Predicate<TLAConfiguration>>(atomicPropositions.length);
        for (int i = 0; i < atomicPropositions.length; ++i) {
            String proposition = atomicPropositions[i];
            int index = this.atomicPropositions.indexOf(proposition);
            if (index < 0) {
                indexes[i] = this.atomicPropositions.size();
                UniqueString name = UniqueString.uniqueStringOf((String)atomicPropositions[i].trim());
                Object node = this.transitionRelation.tool.defns.get(name);
                ExprNode exp = node instanceof OpDefNode ? ((OpDefNode)node).getBody() : null;
                Predicate<TLAConfiguration> pred = arg_0 -> this.lambda$registerAtomicPropositions$0((SemanticNode)exp, name, arg_0);
                this.testers.add(i, pred);
                continue;
            }
            indexes[i] = index;
        }
        return indexes;
    }

    public boolean[] getAtomicPropositionValuations(TLAConfiguration configuration) {
        if (this.testers == null || this.testers.size() < 1) {
            return new boolean[0];
        }
        boolean[] result = new boolean[this.testers.size()];
        for (int i = 0; i < this.testers.size(); ++i) {
            result[i] = this.testers.get(i).test(configuration);
        }
        return result;
    }

    private /* synthetic */ boolean lambda$registerAtomicPropositions$0(SemanticNode exp, UniqueString name, TLAConfiguration c) {
        Value result = exp == null ? c.state.lookup(name) : this.transitionRelation.tool.eval(exp, Context.Empty, c.state);
        if (result instanceof BoolValue) {
            return ((BoolValue)result).val;
        }
        throw new RuntimeException("boolean result expected");
    }
}

