/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.explicit.diagnosis;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import obp2.language.explicit.runtime.ExplicitConfiguration;
import obp2.language.explicit.runtime.ExplicitTransitionRelation;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.defaults.DefaultLanguageService;

public class ExplicitAtomicPropositionEvaluator
extends DefaultLanguageService<ExplicitConfiguration, Integer, Void>
implements IAtomicPropositionsEvaluator<ExplicitConfiguration, Integer, Void> {
    private final ExplicitTransitionRelation transitionRelation;
    List<EqualityCondition> testers;
    protected final List<String> atomicPropositions = new ArrayList<String>();

    public ExplicitAtomicPropositionEvaluator(ExplicitTransitionRelation transitionRelation) {
        this.transitionRelation = transitionRelation;
    }

    public int[] registerAtomicPropositions(String[] atomicPropositions) throws Exception {
        int[] indexes = new int[atomicPropositions.length];
        this.testers = new ArrayList<EqualityCondition>(atomicPropositions.length);
        for (int i = 0; i < atomicPropositions.length; ++i) {
            String proposition = atomicPropositions[i];
            int index = this.atomicPropositions.indexOf(proposition);
            if (index < 0) {
                indexes[i] = this.atomicPropositions.size();
                EqualityCondition tester = this.parse(atomicPropositions[i]);
                this.testers.add(i, tester);
                continue;
            }
            indexes[i] = index;
        }
        return indexes;
    }

    public boolean[] getAtomicPropositionValuations(ExplicitConfiguration configuration) {
        boolean[] valuation = new boolean[this.testers.size()];
        for (int i = 0; i < this.testers.size(); ++i) {
            valuation[i] = configuration.values[this.transitionRelation.program.variables.get(this.testers.get((int)i).variable)] == this.testers.get((int)i).value;
        }
        return valuation;
    }

    public EqualityCondition parse(String code) {
        EqualityCondition condition = new EqualityCondition();
        StringTokenizer tokenizer = new StringTokenizer(code);
        condition.variable = tokenizer.nextToken();
        tokenizer.nextToken();
        condition.value = Integer.parseInt(tokenizer.nextToken());
        return condition;
    }

    class EqualityCondition {
        String variable;
        int value;

        EqualityCondition() {
        }
    }
}

