/*
 * Decompiled with CFR 0.152.
 */
package obp2.statespace.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.statespace.ITransitionStorage;

public class FullTransitionStorage<C extends IConfiguration, A, O>
implements ITransitionStorage<C, A, O> {
    Map<C, List<IFiredTransition<C, A, O>>> adjacencyList = new HashMap<C, List<IFiredTransition<C, A, O>>>();
    int size = 0;
    int edgeCount = 0;

    @Override
    public synchronized IFiredTransition put(IFiredTransition<C, A, O> transition) {
        Optional<IFiredTransition> alreadyPresent;
        ++this.size;
        this.edgeCount += transition.getTargets().size();
        List<IFiredTransition<C, A, O>> fanout = this.adjacencyList.get(transition.getSource());
        if (fanout == null) {
            fanout = new ArrayList<IFiredTransition<C, A, O>>();
            this.adjacencyList.put(transition.getSource(), fanout);
        }
        if (!(alreadyPresent = fanout.stream().filter(t -> Objects.equals(t.getAction(), transition.getAction()) && transition.getTargets().containsAll(t.getTargets())).findAny()).isPresent()) {
            fanout.add(transition);
            return transition;
        }
        return alreadyPresent.get();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public C getParent(C configuration) {
        for (Map.Entry<C, List<IFiredTransition<C, A, O>>> entry : this.adjacencyList.entrySet()) {
            for (IFiredTransition<C, A, O> transition : entry.getValue()) {
                for (IConfiguration target : transition.getTargets()) {
                    if (target != configuration) continue;
                    return (C)((IConfiguration)transition.getSource());
                }
            }
        }
        return null;
    }

    @Override
    public synchronized Collection<IFiredTransition<C, A, O>> getFiredFrom(C configuration) {
        Collection result = this.adjacencyList.get(configuration);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public synchronized Collection<IFiredTransition<C, A, O>> getFiredTo(C configuration) {
        ArrayList<IFiredTransition<C, A, O>> result = new ArrayList<IFiredTransition<C, A, O>>();
        for (Map.Entry<C, List<IFiredTransition<C, A, O>>> entry : this.adjacencyList.entrySet()) {
            block1: for (IFiredTransition<C, A, O> transition : entry.getValue()) {
                for (IConfiguration target : transition.getTargets()) {
                    if (!target.equals(configuration)) continue;
                    result.add(transition);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }
}

