/*
 * Decompiled with CFR 0.152.
 */
package obp2.core.fx;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.scene.image.Image;

public class ImageCache {
    private final ImageCache parent;
    private final Map<String, Image> loadedImages = new HashMap<String, Image>();
    private Function<String, Image> supplier = id -> {
        InputStream stream = this.getClass().getResourceAsStream((String)id);
        if (stream == null) {
            return null;
        }
        return new Image(stream);
    };

    public ImageCache() {
        this(null);
    }

    public ImageCache(ImageCache parent) {
        this.parent = parent;
    }

    public Function<String, Image> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Function<String, Image> supplier) {
        this.supplier = supplier;
    }

    protected boolean isLoaded(String id) {
        return this.loadedImages.containsKey(id) || this.parent != null && this.parent.isLoaded(id);
    }

    public Image loadImage(String id) {
        if (this.parent != null && this.parent.isLoaded(id)) {
            return this.parent.loadImage(id);
        }
        Image result = this.loadedImages.get(id);
        if (!this.loadedImages.containsKey(id)) {
            result = this.supplier.apply(id);
            this.loadedImages.put(id, result);
        }
        return result;
    }
}

