/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.management;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.management.NotCompliantMBeanException;
import tlc2.TLCGlobals;
import tlc2.tool.TLCState;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.tool.distributed.management.TLCStatisticsMXBean;
import tlc2.tool.management.TLCStandardMBean;

public class TLCServerMXWrapper
extends TLCStandardMBean
implements TLCStatisticsMXBean {
    private final TLCServer tlcServer;

    public TLCServerMXWrapper(TLCServer aTLCServer) throws NotCompliantMBeanException {
        super((Class)TLCStatisticsMXBean.class);
        this.tlcServer = aTLCServer;
        this.registerMBean("tlc2.tool:type=ModelChecker");
    }

    @Override
    public long getStatesGenerated() {
        if (this.tlcServer.isRunning()) {
            return this.tlcServer.getStatesGenerated();
        }
        return -1L;
    }

    @Override
    public long getDistinctStatesGenerated() {
        IFPSetManager fpSetManager;
        if (this.tlcServer.isRunning() && (fpSetManager = this.tlcServer.getFPSetManager()) != null) {
            return fpSetManager.size();
        }
        return -1L;
    }

    @Override
    public long getStateQueueSize() {
        return this.tlcServer.getNewStates();
    }

    @Override
    public long getStatesGeneratedPerMinute() {
        return this.tlcServer.getStatesGeneratedPerMinute();
    }

    @Override
    public long getDistinctStatesGeneratedPerMinute() {
        return this.tlcServer.getDistinctStatesGeneratedPerMinute();
    }

    @Override
    public int getProgress() {
        if (this.tlcServer.isRunning()) {
            try {
                return this.tlcServer.trace.getLevelForReporting();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public int getWorkerCount() {
        return this.tlcServer.getWorkerCount();
    }

    @Override
    public void checkpoint() {
        TLCGlobals.forceChkpt();
    }

    @Override
    public long getAverageBlockCnt() {
        return this.tlcServer.getAverageBlockCnt();
    }

    @Override
    public double getRuntimeRatio() {
        return 0.0;
    }

    @Override
    public void liveCheck() {
    }

    @Override
    public String getCurrentState() {
        TLCState state = this.tlcServer.stateQueue.sPeek();
        if (state != null) {
            return state.toString();
        }
        return "N/A";
    }

    @Override
    public String getSpecName() {
        if (this.tlcServer.isRunning()) {
            try {
                return this.tlcServer.getSpecFileName();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return "N/A";
    }

    @Override
    public String getModelName() {
        if (this.tlcServer.isRunning()) {
            try {
                return this.tlcServer.getConfigFileName();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return "N/A";
    }
}

