/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.math.BigInteger;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ExprNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;

public class NumeralNode
extends ExprNode {
    private int value;
    private BigInteger bigValue = null;
    private String image;

    public NumeralNode(String s, TreeNode stn) throws AbortException {
        super(16, stn);
        this.image = s;
        String num = s.toLowerCase();
        int radix = 10;
        if (num.charAt(0) == '\\') {
            if (num.charAt(1) == 'b') {
                radix = 2;
            } else if (num.charAt(1) == 'o') {
                radix = 8;
            } else if (num.charAt(1) == 'h') {
                radix = 16;
            } else {
                throw new AbortException();
            }
            num = num.substring(2);
        }
        try {
            this.value = Integer.parseInt(num, radix);
        }
        catch (NumberFormatException e) {
            this.bigValue = new BigInteger(s, radix);
        }
    }

    public final int val() {
        return this.value;
    }

    public final BigInteger bigVal() {
        return this.bigValue;
    }

    @Override
    public final String toString() {
        return this.image;
    }

    @Override
    public final boolean levelCheck(int iter) {
        this.levelChecked = iter;
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "\n*NumeralNode: " + super.toString(depth) + " Value: " + this.value + (this.bigValue != null ? "; big value: " + this.bigValue.toString() : "") + "; image: " + this.image;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        String v = this.bigValue != null ? this.bigValue.toString() : Integer.toString(this.value);
        Element e = doc.createElement("IntValue");
        Text n = doc.createTextNode(v);
        e.appendChild(n);
        return this.appendElement(doc, "NumeralNode", e);
    }
}

