/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import java.util.Stack;
import tla2sany.parser.StackElement;
import tla2sany.st.SyntaxTreeConstants;

public class BracketStack
implements SyntaxTreeConstants {
    private Stack stack = new Stack();
    private int[] classes = new int[327];
    private int classIndex = 0;

    public void newClass() {
        ++this.classIndex;
    }

    public void registerInCurrentClass(int k) {
        if (this.classIndex == 0) {
            // empty if block
        }
        this.classes[k] = ++this.classIndex;
    }

    BracketStack() {
        this.stack.push(new StackElement(0, -1));
    }

    void newReference(int o, int kind) {
        this.stack.push(new StackElement(o, this.classes[kind]));
    }

    void popReference() {
        this.stack.pop();
    }

    boolean onReference(int o, int kind) {
        StackElement se = (StackElement)this.stack.peek();
        return this.classes[kind] == se.Kind && se.Offset == o;
    }

    boolean belowReference(int o) {
        StackElement se = (StackElement)this.stack.peek();
        return se.Offset > o;
    }

    boolean aboveReference(int o) {
        StackElement se = (StackElement)this.stack.peek();
        return se.Offset - 1 < o;
    }
}

