/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.reachability;

import java.util.LinkedList;
import java.util.Queue;
import obp2.algorithms.Color;
import obp2.algorithms.reachability.AbstractExplorer;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.runtime.core.ITransitionRelation;

public class BoundedBFSExplorer<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    protected final int targetDepth;
    protected int currentDepth;
    protected final Queue<C>[] toSee = new Queue[2];
    protected int currentQueueID = 0;

    public BoundedBFSExplorer(ITransitionRelation runtime, IStateSpaceManager<C, A, Object> stateSpaceManager, int targetDepth) {
        super(runtime, stateSpaceManager);
        this.targetDepth = targetDepth;
    }

    @Override
    public void initializeExploration() {
        this.currentDepth = 0;
        this.toSee[0] = new LinkedList<C>();
        this.toSee[1] = new LinkedList<C>();
        super.initializeExploration();
    }

    @Override
    public boolean atEnd() {
        if (this.toSee[this.currentQueueID].isEmpty()) {
            this.currentQueueID = 1 - this.currentQueueID;
            if (this.toSee[this.currentQueueID].isEmpty()) {
                return true;
            }
            ++this.currentDepth;
        }
        return this.currentDepth >= this.targetDepth;
    }

    @Override
    public C nextConfiguration() {
        return (C)((IConfiguration)this.toSee[this.currentQueueID].remove());
    }

    @Override
    public void schedule(C conf) {
        this.setColor(conf, Color.RED);
        this.toSee[1 - this.currentQueueID].add(conf);
    }
}

