/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.buchi.scc;

import java.util.Stack;
import java.util.function.Supplier;
import obp2.algorithms.buchi.DefaultExecutionController;
import obp2.core.IBuchiConfiguration;
import obp2.core.IConfiguration;
import obp2.core.execution.IExecutionController;
import obp2.events.ExecutionEndedEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ITransitionRelation;

public class BA_Couvreur_Recursive<C extends IBuchiConfiguration & IConfiguration, A>
extends DefaultExecutionController<C, A> {
    int count = 0;
    Stack<C> roots = new Stack();

    public BA_Couvreur_Recursive(ITransitionRelation<C, A, ?> runtime) {
        super(runtime);
    }

    @Override
    public Supplier getMetadataSupplier() {
        return () -> new Metadata();
    }

    public void execute() {
        for (IBuchiConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
            this.couvreur_dfs(initial);
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    void couvreur_dfs(C source) {
        ++this.count;
        this.data(source).dfsnum = this.count;
        this.roots.push(source);
        this.data(source).current = true;
        for (IBuchiConfiguration t : this.getProductAutomaton().getPostIterable(source)) {
            IBuchiConfiguration u;
            if (this.monitor.atEnd()) break;
            if (this.data(t).dfsnum == 0) {
                this.couvreur_dfs(t);
                continue;
            }
            if (!this.data(t).current) continue;
            do {
                if (!(u = (IBuchiConfiguration)this.roots.pop()).isAccepting()) continue;
                System.out.println("target = [" + u + "]");
                this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, false, "property", null));
            } while (this.data(u).dfsnum > this.data(t).dfsnum);
            this.roots.push(u);
        }
        if (this.roots.peek() == source) {
            this.roots.pop();
            this.remove(source);
        }
    }

    void remove(C s) {
        if (!this.data(s).current) {
            return;
        }
        this.data(s).current = false;
        for (IBuchiConfiguration t : this.getProductAutomaton().getPostIterable(s)) {
            this.remove(t);
        }
    }

    Metadata data(C state) {
        return (Metadata)((IConfiguration)state).getMetadata();
    }

    class Metadata {
        public int dfsnum = 0;
        public boolean current = false;

        Metadata() {
        }
    }
}

