/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.BiConsumer;
import javafx.beans.NamedArg;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;

public class StyledTextArea<PS, S>
extends GenericStyledArea<PS, String, S> {
    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, String, S> document, @NamedArg(value="segmentOps") TextOps<String, S> segmentOps, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        super(initialParagraphStyle, applyParagraphStyle, initialTextStyle, document, segmentOps, preserveStyle, seg -> StyledTextArea.createStyledTextNode(seg, applyStyle));
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, String, S> document, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, document, SegmentOps.styledTextOps(), preserveStyle);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, String, S> document) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, document, true);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, new SimpleEditableStyledDocument<PS, S>(initialParagraphStyle, initialTextStyle), preserveStyle);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, true);
    }

    public static <S> Node createStyledTextNode(StyledSegment<String, S> seg, BiConsumer<? super TextExt, S> applyStyle) {
        return StyledTextArea.createStyledTextNode(seg.getSegment(), seg.getStyle(), applyStyle);
    }

    public static <S> Node createStyledTextNode(String text, S style, BiConsumer<? super TextExt, S> applyStyle) {
        TextExt t = new TextExt(text);
        t.setTextOrigin(VPos.TOP);
        t.getStyleClass().add((Object)"text");
        applyStyle.accept(t, style);
        return t;
    }
}

