/*
 * Decompiled with CFR 0.152.
 */
package plug.language.explicit.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.runtime.core.IConcurrentTransitionRelation;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.language.explicit.model.ExplicitProgram;
import plug.language.explicit.runtime.ExplicitConfiguration;

public class ExplicitTransitionRelation
extends DefaultLanguageService<ExplicitConfiguration, Integer, Void>
implements ITransitionRelation<ExplicitConfiguration, Integer, Void>,
IConcurrentTransitionRelation<ExplicitTransitionRelation, ExplicitConfiguration, Integer, Void> {
    public String name;
    public ExplicitProgram program;

    public ExplicitTransitionRelation(String name, ExplicitProgram program) {
        this.name = name;
        this.program = program;
    }

    public ExplicitTransitionRelation createCopy() {
        return new ExplicitTransitionRelation(this.name, this.program);
    }

    public Set<ExplicitConfiguration> initialConfigurations() {
        HashSet<ExplicitConfiguration> initialSet = new HashSet<ExplicitConfiguration>();
        for (int i : this.program.initial) {
            ExplicitConfiguration config = new ExplicitConfiguration();
            config.id = i;
            config.values = this.program.states[i];
            initialSet.add(config);
        }
        return initialSet;
    }

    public Collection<Integer> fireableTransitionsFrom(ExplicitConfiguration source) {
        int[] fanout = this.program.getFireableTransitions(source.id);
        return Arrays.stream(fanout).boxed().collect(Collectors.toList());
    }

    public IFiredTransition<ExplicitConfiguration, Integer, Void> fireOneTransition(ExplicitConfiguration source, Integer transition) {
        ExplicitConfiguration target = new ExplicitConfiguration();
        target.id = transition;
        target.values = this.program.states[transition];
        return new FiredTransition((Object)source, (Object)target, (Object)transition);
    }
}

