/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class MapHelper<K, V> {
    public static <K, V> MapHelper<K, V> put(MapHelper<K, V> mapHelper, K key, V value) {
        if (mapHelper == null) {
            return new SingleEntryHelper<K, V>(key, value);
        }
        return mapHelper.put(key, value);
    }

    public static <K, V> V get(MapHelper<K, V> mapHelper, K key) {
        if (mapHelper == null) {
            return null;
        }
        return mapHelper.get(key);
    }

    public static <K, V> MapHelper<K, V> remove(MapHelper<K, V> mapHelper, K key) {
        if (mapHelper == null) {
            return mapHelper;
        }
        return mapHelper.remove(key);
    }

    public static <K, V> K chooseKey(MapHelper<K, V> mapHelper) {
        if (mapHelper == null) {
            throw new NoSuchElementException("empty map");
        }
        return mapHelper.chooseKey();
    }

    public static <K, V> void replaceAll(MapHelper<K, V> mapHelper, BiFunction<? super K, ? super V, ? extends V> f) {
        if (mapHelper != null) {
            mapHelper.replaceAll(f);
        }
    }

    public static <K, V> void forEach(MapHelper<K, V> mapHelper, BiConsumer<K, V> f) {
        if (mapHelper != null) {
            mapHelper.forEach(f);
        }
    }

    public static <K, V> boolean isEmpty(MapHelper<K, V> mapHelper) {
        return mapHelper == null;
    }

    public static <K, V> int size(MapHelper<K, V> mapHelper) {
        if (mapHelper == null) {
            return 0;
        }
        return mapHelper.size();
    }

    public static <K> boolean containsKey(MapHelper<K, ?> mapHelper, K key) {
        if (mapHelper == null) {
            return false;
        }
        return mapHelper.containsKey(key);
    }

    private MapHelper() {
    }

    protected abstract MapHelper<K, V> put(K var1, V var2);

    protected abstract V get(K var1);

    protected abstract MapHelper<K, V> remove(K var1);

    protected abstract K chooseKey();

    protected abstract void replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    protected abstract boolean containsKey(K var1);

    protected abstract void forEach(BiConsumer<K, V> var1);

    protected abstract int size();

    private static class MultiEntryHelper<K, V>
    extends MapHelper<K, V> {
        private final Map<K, V> entries = new HashMap();

        public MultiEntryHelper(K k1, V v1, K k2, V v2) {
            this.entries.put(k1, v1);
            this.entries.put(k2, v2);
        }

        @Override
        protected MapHelper<K, V> put(K key, V value) {
            this.entries.put(key, value);
            return this;
        }

        @Override
        protected V get(K key) {
            return this.entries.get(key);
        }

        @Override
        protected MapHelper<K, V> remove(K key) {
            this.entries.remove(key);
            switch (this.entries.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    Map.Entry entry = this.entries.entrySet().toArray(new Map.Entry[1])[0];
                    return new SingleEntryHelper(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        protected K chooseKey() {
            return this.entries.keySet().iterator().next();
        }

        @Override
        protected void replaceAll(BiFunction<? super K, ? super V, ? extends V> f) {
            this.entries.replaceAll(f);
        }

        @Override
        protected void forEach(BiConsumer<K, V> f) {
            for (Object entry : this.entries.entrySet().toArray()) {
                Map.Entry e = (Map.Entry)entry;
                f.accept(e.getKey(), e.getValue());
            }
        }

        @Override
        protected int size() {
            return this.entries.size();
        }

        @Override
        protected boolean containsKey(K key) {
            return this.entries.containsKey(key);
        }
    }

    private static class SingleEntryHelper<K, V>
    extends MapHelper<K, V> {
        private final K key;
        private V value;

        public SingleEntryHelper(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected MapHelper<K, V> put(K key, V value) {
            if (Objects.equals(key, this.key)) {
                return new SingleEntryHelper<K, V>(key, value);
            }
            return new MultiEntryHelper<K, V>(this.key, this.value, key, value);
        }

        @Override
        protected V get(K key) {
            return Objects.equals(key, this.key) ? (V)this.value : null;
        }

        @Override
        protected MapHelper<K, V> remove(K key) {
            if (Objects.equals(key, this.key)) {
                return null;
            }
            return this;
        }

        @Override
        protected K chooseKey() {
            return this.key;
        }

        @Override
        protected void replaceAll(BiFunction<? super K, ? super V, ? extends V> f) {
            this.value = f.apply(this.key, this.value);
        }

        @Override
        protected void forEach(BiConsumer<K, V> f) {
            f.accept(this.key, this.value);
        }

        @Override
        protected int size() {
            return 1;
        }

        @Override
        protected boolean containsKey(K key) {
            return Objects.equals(key, this.key);
        }
    }
}

