/*
 * Decompiled with CFR 0.152.
 */
package plug.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class CartesianProduct<T> {
    public void cartesianProduct(List[] set1, List[] set2, Consumer<T[][]> userCallback, T[][] resultHolder) {
        int maxSet1 = 0;
        for (List l : set1) {
            if (l.size() <= maxSet1) continue;
            maxSet1 = l.size();
        }
        int maxSet2 = 0;
        for (List l : set2) {
            if (l.size() <= maxSet2) continue;
            maxSet2 = l.size();
        }
        int[] internalTuple2 = new int[set2.length];
        if (set1.length == 0) {
            Consumer<T[]> callback2 = tuple2 -> userCallback.accept(resultHolder);
            this.cartesianProduct(set2, maxSet2, internalTuple2, callback2, resultHolder[1]);
            return;
        }
        int maxSet2final = maxSet2;
        Consumer<T[]> callback1 = tuple1 -> {
            if (set2.length == 0) {
                userCallback.accept(resultHolder);
                return;
            }
            Consumer<T[]> callback2 = tuple2 -> userCallback.accept(resultHolder);
            this.cartesianProduct(set2, maxSet2final, internalTuple2, callback2, resultHolder[1]);
        };
        this.cartesianProduct(set1, maxSet1, new int[set1.length], callback1, resultHolder[0]);
    }

    public void cartesianProduct(List[] arrayOfLists, int max, int[] internalTuple, Consumer<T[]> userCallback, T[] resultHolder) {
        int setCardinality = arrayOfLists.length;
        Function<int[], Integer> pruning = tuple -> {
            int stopAt = setCardinality;
            for (int idx = 0; idx < ((int[])tuple).length; ++idx) {
                List theList = arrayOfLists[idx];
                int n = stopAt = theList.size() - 1 < tuple[idx] ? idx : stopAt;
                if (stopAt != setCardinality) continue;
                resultHolder[idx] = theList.get(tuple[idx]);
            }
            if (stopAt == setCardinality) {
                userCallback.accept(resultHolder);
            }
            return stopAt;
        };
        this.foreach(max, setCardinality, internalTuple, pruning);
    }

    public void cartesianProduct(List[] arrayOfLists, Consumer<T[]> userCallback, T[] resultHolder) {
        int setCardinality = arrayOfLists.length;
        int max = 0;
        for (List l : arrayOfLists) {
            if (l.size() <= max) continue;
            max = l.size();
        }
        Function<int[], Integer> pruning = tuple -> {
            int stopAt = setCardinality;
            for (int idx = 0; idx < ((int[])tuple).length; ++idx) {
                List theList = arrayOfLists[idx];
                int n = stopAt = theList.size() - 1 < tuple[idx] ? idx : stopAt;
                if (stopAt != setCardinality) continue;
                resultHolder[idx] = theList.get(tuple[idx]);
            }
            if (stopAt == setCardinality) {
                userCallback.accept(resultHolder);
            }
            return stopAt;
        };
        this.foreach(max, setCardinality, new int[setCardinality], pruning);
    }

    public void cartesianProduct(T[][] set1, T[][] set2, Consumer<T[][]> userCallback, T[][] resultHolder) {
        if (set1.length == 0) {
            Consumer<T[]> callback2 = tuple2 -> userCallback.accept(resultHolder);
            this.cartesianProduct(set2, callback2, resultHolder[1]);
            return;
        }
        Consumer<T[]> callback1 = tuple1 -> {
            if (set2.length == 0) {
                userCallback.accept(resultHolder);
                return;
            }
            Consumer<T[]> callback2 = tuple2 -> userCallback.accept(resultHolder);
            this.cartesianProduct(set2, callback2, resultHolder[1]);
        };
        this.cartesianProduct(set1, callback1, resultHolder[0]);
    }

    public void cartesianProduct(T[][] arrayOfArrays, Consumer<T[]> userCallback, T[] resultHolder) {
        int setCardinality = arrayOfArrays.length;
        int max = 0;
        for (T[] l : arrayOfArrays) {
            if (l.length <= max) continue;
            max = l.length;
        }
        Function<int[], Integer> pruning = tuple -> {
            int stopAt = setCardinality;
            for (int idx = 0; idx < ((int[])tuple).length; ++idx) {
                Object[] theList = arrayOfArrays[idx];
                int n = stopAt = theList.length - 1 < tuple[idx] ? idx : stopAt;
                if (stopAt != setCardinality) continue;
                resultHolder[idx] = theList[tuple[idx]];
            }
            if (stopAt == setCardinality) {
                userCallback.accept(resultHolder);
            }
            return stopAt;
        };
        this.foreach(max, setCardinality, new int[setCardinality], pruning);
    }

    public void foreach(int setCardinality, int inArity, int[] tuple, Function<int[], Integer> pruningCallback) {
        long resultCardinality = (int)Math.pow(setCardinality, inArity);
        long[] precomputedScale = this.scalesForArity(inArity, setCardinality, resultCardinality);
        long idx = 0L;
        while (idx < resultCardinality) {
            for (int tupleIdx = 0; tupleIdx < inArity; ++tupleIdx) {
                int position;
                tuple[tupleIdx] = position = (int)Math.floor(idx / precomputedScale[tupleIdx] % (long)setCardinality);
            }
            int skipIndex = pruningCallback.apply(tuple);
            assert (skipIndex <= inArity);
            if (skipIndex == inArity) {
                ++idx;
                continue;
            }
            idx += precomputedScale[skipIndex];
        }
    }

    public static Integer printAllTuplesCallback(int[] tuple) {
        System.out.print("(");
        for (int i = 0; i < tuple.length; ++i) {
            if (i == tuple.length - 1) {
                System.out.print(tuple[i]);
                continue;
            }
            System.out.print(tuple[i] + ", ");
        }
        System.out.println(")");
        return tuple.length;
    }

    public static <T> List<List<T>> recursiveCartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> resultLists = new ArrayList<List<T>>();
        if (lists.size() == 0) {
            resultLists.add(new ArrayList());
            return resultLists;
        }
        List<T> firstList = lists.get(0);
        List<List<T>> remainingLists = CartesianProduct.recursiveCartesianProduct(lists.subList(1, lists.size()));
        for (T condition : firstList) {
            for (List<T> remainingList : remainingLists) {
                ArrayList<T> resultList = new ArrayList<T>();
                resultList.add(condition);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }

    public void cartesianProduct(List<List<T>> listOfLists, Consumer<T[]> userCallback, Function<Integer, T[]> supplier) {
        int arity = listOfLists.size();
        T[] result = supplier.apply(arity);
        int max = 0;
        for (List<T> l : listOfLists) {
            if (l.size() <= max) continue;
            max = l.size();
        }
        int[] theArray = new int[max];
        for (int i = 0; i < max; ++i) {
            theArray[i] = i;
        }
        CartesianProductPruning privateCallback = new CartesianProductPruning();
        privateCallback.listOfLists = listOfLists;
        privateCallback.result = result;
        privateCallback.userCallback = userCallback;
        this.foreach(theArray, arity, privateCallback);
    }

    public short foreach(int[] inArray, int inArity, Function<int[], Integer> pruningCallback) {
        int setCardinality = inArray.length;
        long resultCardinality = (int)Math.pow(setCardinality, inArity);
        long[] precomputedScale = this.scalesForArity(inArity, setCardinality, resultCardinality);
        int[] tuple = new int[inArity];
        long idx = 0L;
        while (idx < resultCardinality) {
            for (int tupleIdx = 0; tupleIdx < inArity; ++tupleIdx) {
                int position = (int)Math.floor(idx / precomputedScale[tupleIdx] % (long)setCardinality);
                tuple[tupleIdx] = inArray[position];
            }
            int skipIndex = pruningCallback.apply(tuple);
            assert (skipIndex <= inArity);
            if (skipIndex == inArity) {
                ++idx;
                continue;
            }
            idx += precomputedScale[skipIndex];
        }
        return 1;
    }

    long[] scalesForArity(int inArity, int setCardinality, long resultCardinality) {
        long[] scale = new long[inArity];
        long current = scale[0] = resultCardinality / (long)setCardinality;
        for (int i = 1; i < inArity; ++i) {
            current = scale[i] = current / (long)setCardinality;
        }
        return scale;
    }

    private class CartesianProductPruning
    implements Function<int[], Integer> {
        List<List<T>> listOfLists;
        T[] result;
        Consumer<T[]> userCallback;

        private CartesianProductPruning() {
        }

        @Override
        public Integer apply(int[] tuple) {
            int arity;
            int stopAt = arity = this.listOfLists.size();
            for (int idx = 0; idx < tuple.length; ++idx) {
                List theList = this.listOfLists.get(idx);
                int n = stopAt = theList.size() - 1 < tuple[idx] ? idx : stopAt;
                if (stopAt != arity) continue;
                this.result[idx] = theList.get(tuple[idx]);
            }
            if (stopAt == arity) {
                this.userCallback.accept(this.result);
            }
            return stopAt;
        }
    }
}

