/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.SetEnumValue;
import tlc2.value.TupleValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetOfTuplesValue
extends EnumerableValue
implements Enumerable {
    public Value[] sets;
    protected SetEnumValue tupleSet;

    public SetOfTuplesValue(Value[] sets) {
        this.sets = sets;
        this.tupleSet = null;
    }

    public SetOfTuplesValue(Value val) {
        this.sets = new Value[1];
        this.sets[0] = val;
        this.tupleSet = null;
    }

    public SetOfTuplesValue(Value v1, Value v2) {
        this.sets = new Value[2];
        this.sets[0] = v1;
        this.sets[1] = v2;
        this.tupleSet = null;
    }

    @Override
    public final byte getKind() {
        return 15;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.tupleSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof SetOfTuplesValue) {
                SetOfTuplesValue tvs = (SetOfTuplesValue)obj;
                boolean isEmpty1 = this.isEmpty();
                if (isEmpty1) {
                    return tvs.isEmpty();
                }
                if (tvs.isEmpty()) {
                    return isEmpty1;
                }
                if (this.sets.length != tvs.sets.length) {
                    return false;
                }
                for (int i = 0; i < this.sets.length; ++i) {
                    if (this.sets[i].equals(tvs.sets[i])) continue;
                    return false;
                }
                return true;
            }
            this.convertAndCache();
            return this.tupleSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            TupleValue tv = TupleValue.convert(elem);
            if (tv == null) {
                FcnRcdValue fcn = FcnRcdValue.convert(elem);
                if (fcn == null) {
                    if (elem instanceof ModelValue) {
                        return ((ModelValue)elem).modelValueMember(this);
                    }
                    Assert.fail("Attempted to check if non-tuple\n" + SetOfTuplesValue.ppr(elem.toString()) + "\nis in the set of tuples:\n" + SetOfTuplesValue.ppr(this.toString()));
                }
                if (fcn.intv != null) {
                    return false;
                }
                for (int i = 0; i < fcn.domain.length; ++i) {
                    if (fcn.domain[i] instanceof IntValue) continue;
                    Assert.fail("Attempted to check if non-tuple\n" + SetOfTuplesValue.ppr(elem.toString()) + "\nis in the set of tuples:\n" + SetOfTuplesValue.ppr(this.toString()));
                }
                return false;
            }
            if (tv.elems.length == this.sets.length) {
                for (int i = 0; i < this.sets.length; ++i) {
                    if (this.sets[i].member(tv.elems[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            for (int i = 0; i < this.sets.length; ++i) {
                if (this.sets[i].isFinite()) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the set of tuples:\n" + SetOfTuplesValue.ppr(this.toString()));
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the set of tuples:\n" + SetOfTuplesValue.ppr(this.toString()));
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            long sz = 1L;
            for (int i = 0; i < this.sets.length; ++i) {
                if ((sz *= (long)this.sets[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                Assert.fail("Overflow when computing the number of elements in " + SetOfTuplesValue.ppr(this.toString()));
            }
            return (int)sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.tupleSet == null || this.tupleSet == DummyEnum) {
                for (int i = 0; i < this.sets.length; ++i) {
                    if (this.sets[i].isNormalized()) continue;
                    return false;
                }
                return true;
            }
            return this.tupleSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.tupleSet == null || this.tupleSet == DummyEnum) {
                for (int i = 0; i < this.sets.length; ++i) {
                    this.sets[i].normalize();
                }
            } else {
                this.tupleSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            for (int i = 0; i < this.sets.length; ++i) {
                defined = defined && this.sets[i].isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.tupleSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.convertAndCache();
            return this.tupleSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.tupleSet == null) {
            this.tupleSet = SetEnumValue.convert(this);
        } else if (this.tupleSet == DummyEnum) {
            SetEnumValue val = null;
            SetOfTuplesValue setOfTuplesValue = this;
            synchronized (setOfTuplesValue) {
                if (this.tupleSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setOfTuplesValue = this;
            synchronized (setOfTuplesValue) {
                if (this.tupleSet == DummyEnum) {
                    this.tupleSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            boolean unlazy = expand;
            try {
                if (unlazy) {
                    long sz = 1L;
                    for (int i = 0; i < this.sets.length; ++i) {
                        if ((sz *= (long)this.sets[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                        unlazy = false;
                        break;
                    }
                    unlazy = sz < (long)TLCGlobals.enumBound;
                }
            }
            catch (Throwable e) {
                unlazy = false;
            }
            if (unlazy) {
                SetEnumValue val = SetEnumValue.convert(this);
                return ((Value)val).toString(sb, offset);
            }
            if (this.sets.length > 0) {
                sb.append("(");
                this.sets[0].toString(sb, offset);
            }
            for (int i = 1; i < this.sets.length; ++i) {
                sb.append(" \\X ");
                this.sets[i].toString(sb, offset);
            }
            if (this.sets.length > 0) {
                sb.append(")");
            }
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.tupleSet == null || this.tupleSet == DummyEnum) {
                return new Enumerator();
            }
            return this.tupleSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone;

        public Enumerator() {
            this.enums = new ValueEnumeration[SetOfTuplesValue.this.sets.length];
            this.currentElems = new Value[SetOfTuplesValue.this.sets.length];
            this.isDone = false;
            for (int i = 0; i < SetOfTuplesValue.this.sets.length; ++i) {
                if (SetOfTuplesValue.this.sets[i] instanceof Enumerable) {
                    this.enums[i] = ((Enumerable)((Object)SetOfTuplesValue.this.sets[i])).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] != null) continue;
                    this.enums = null;
                    this.isDone = true;
                    break;
                }
                Assert.fail("Attempted to enumerate a set of the form s1 \\X s2 ... \\X sn,\nbut can't enumerate s" + i + ":\n" + Value.ppr(SetOfTuplesValue.this.sets[i].toString()));
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                for (int i = 0; i < this.enums.length; ++i) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            int i;
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            for (i = 0; i < elems.length; ++i) {
                elems[i] = this.currentElems[i];
            }
            for (i = elems.length - 1; i >= 0; --i) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
            }
            return new TupleValue(elems);
        }
    }
}

