/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.output.MP;

public class NodePtrTable {
    private int count = 0;
    private int length;
    private int thresh;
    private long[] keys;
    private long[] elems;

    public NodePtrTable(int size) {
        this.length = size;
        this.thresh = (int)((double)size * 0.75);
        this.keys = new long[size];
        this.elems = new long[size];
        for (int i = 0; i < size; ++i) {
            this.elems[i] = -1L;
        }
    }

    public final void put(long k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            if (this.elems[loc] == -1L) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return;
            }
            if (this.keys[loc] == k) {
                this.elems[loc] = elem;
                return;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int getLoc(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (this.elems[loc] != -1L) {
            if (this.keys[loc] == k) {
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
        return -1;
    }

    public final long get(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (this.elems[loc] != -1L) {
            if (this.keys[loc] == k) {
                return this.elems[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return -1L;
    }

    public final long getByLoc(int loc) {
        return this.elems[loc];
    }

    public final long getKeyByLoc(int loc) {
        return this.keys[loc];
    }

    public final void putByLoc(long k, long elem, int loc) {
        this.keys[loc] = k;
        this.elems[loc] = elem;
    }

    public void resetElems() {
        int i = 0;
        while (i < this.keys.length) {
            int n = i++;
            this.elems[n] = this.elems[n] & Long.MAX_VALUE;
        }
    }

    private final void grow() {
        try {
            int i;
            int newLength = 2 * this.length + 1;
            long[] oldKeys = this.keys;
            long[] oldElems = this.elems;
            this.keys = new long[newLength];
            this.elems = new long[newLength];
            for (i = 0; i < newLength; ++i) {
                this.elems[i] = -1L;
            }
            this.count = 0;
            block3: for (i = 0; i < oldElems.length; ++i) {
                long elem = oldElems[i];
                if (elem == -1L) continue;
                int loc = ((int)oldKeys[i] & Integer.MAX_VALUE) % newLength;
                while (true) {
                    if (this.elems[loc] == -1L) {
                        this.keys[loc] = oldKeys[i];
                        this.elems[loc] = elem;
                        ++this.count;
                        continue block3;
                    }
                    if (this.keys[loc] == oldKeys[i]) {
                        this.elems[loc] = elem;
                        continue block3;
                    }
                    loc = (loc + 1) % newLength;
                }
            }
            this.length = newLength;
            this.thresh = (int)((double)newLength * 0.75);
        }
        catch (Throwable t) {
            System.gc();
            MP.printError(1001, t);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int getSize() {
        return this.length;
    }
}

