/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import tlc2.tool.EvalException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.IntValue;
import tlc2.value.StringValue;
import tlc2.value.SubsetValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;

public class Randomization
implements ValueConstants {
    public static final long serialVersionUID = 20180618L;

    public static Value RandomSubset(Value v1, Value v2) {
        if (!(v1 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"first", "RandomSubset", "nonnegative integer", Value.ppr(v1.toString())});
        }
        if (!(v2 instanceof Enumerable)) {
            throw new EvalException(2169, new String[]{"second", "RandomSubset", "a finite set", Value.ppr(v2.toString())});
        }
        return ((Enumerable)((Object)v2)).getRandomSubset(((IntValue)v1).val);
    }

    public static Value RandomSetOfSubsets(Value v1, Value v2, Value v3) {
        if (!(v1 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"first", "RandomSetOfSubsets", "nonnegative integer", Value.ppr(v1.toString())});
        }
        int numberOfPicks = ((IntValue)v1).val;
        if (numberOfPicks < 0) {
            throw new EvalException(2169, new String[]{"first", "RandomSetOfSubsets", "nonnegative integer", Value.ppr(v1.toString())});
        }
        if (!(v2 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"second", "RandomSetOfSubsets", "nonnegative integer", Value.ppr(v2.toString())});
        }
        int n = ((IntValue)v2).val;
        if (n < 0) {
            throw new EvalException(2169, new String[]{"second", "RandomSetOfSubsets", "nonnegative integer", Value.ppr(v2.toString())});
        }
        if (!(v3 instanceof Enumerable)) {
            throw new EvalException(2169, new String[]{"third", "RandomSetOfSubsets", "finite set", Value.ppr(v3.toString())});
        }
        EnumerableValue ev = (EnumerableValue)v3;
        if (31 - Integer.numberOfLeadingZeros(numberOfPicks) + 1 > ev.size() && numberOfPicks > 1 << ev.size()) {
            throw new EvalException(2169, new String[]{"first", "RandomSetOfSubsets", "nonnegative integer that is smaller than the subset's size of 2^" + ev.size(), Integer.toString(numberOfPicks)});
        }
        if (ev.size() < n) {
            throw new EvalException(2169, new String[]{"second", "RandomSetOfSubsets", "nonnegative integer in range 0..Cardinality(S)", Value.ppr(v2.toString())});
        }
        double probability = 1.0 * (double)n / (double)ev.size();
        if (probability < 0.0 || 1.0 < probability) {
            throw new EvalException(2169, new String[]{"second", "RandomSetOfSubsets", "nonnegative integer in range 0..Cardinality(S)", Value.ppr(v2.toString())});
        }
        return new SubsetValue(ev).getRandomSetOfSubsets(numberOfPicks, probability);
    }

    public static Value RandomSubsetSet(Value v1, Value v2, Value v3) {
        double probability;
        if (!(v1 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"first", "RandomSubsetSetProbability", "nonnegative integer", Value.ppr(v1.toString())});
        }
        int numberOfPicks = ((IntValue)v1).val;
        if (numberOfPicks < 0) {
            throw new EvalException(2169, new String[]{"first", "RandomSubsetSetProbability", "nonnegative integer", Value.ppr(v1.toString())});
        }
        if (!(v2 instanceof StringValue)) {
            throw new EvalException(2169, new String[]{"second", "RandomSubsetSetProbability", "string literal representing a probability", Value.ppr(v2.toString())});
        }
        try {
            probability = Double.valueOf(((StringValue)v2).getVal().toString());
        }
        catch (NumberFormatException nfe) {
            throw new EvalException(2169, new String[]{"second", "RandomSubsetSetProbability", "string literal does not represent a parsable probability", Value.ppr(v2.toString())});
        }
        if (probability < 0.0 || 1.0 < probability) {
            throw new EvalException(2169, new String[]{"second", "RandomSubsetSetProbability", "string literal does not represent a parsable probability", Value.ppr(v2.toString())});
        }
        if (!(v3 instanceof Enumerable)) {
            throw new EvalException(2169, new String[]{"third", "RandomSubsetSetProbability", "finite set", Value.ppr(v3.toString())});
        }
        EnumerableValue ev = (EnumerableValue)v3;
        if (31 - Integer.numberOfLeadingZeros(numberOfPicks) + 1 > ev.size() && numberOfPicks > 1 << ev.size()) {
            throw new EvalException(2169, new String[]{"first", "RandomSubsetSetProbability", "nonnegative integer that is smaller than the subset's size of 2^" + ev.size(), Integer.toString(numberOfPicks)});
        }
        return new SubsetValue(ev).getRandomSetOfSubsets(numberOfPicks, probability);
    }
}

