/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.Changed;
import pcal.MappingObject;
import pcal.PCalLocation;
import pcal.ParseAlgorithm;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.PcalSymTab;
import pcal.Region;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.TLAtoPCalMapping;
import pcal.exception.PcalTLAGenException;
import pcal.exception.TLAExprException;

public class PcalTLAGen {
    public static final boolean boxUnderCASE = true;
    public static int wrapColumn;
    public static int ssWrapColumn;
    private Vector tlacode = new Vector();
    private String tlacodeNextLine = "";
    private Vector mappingVector;
    private Vector mappingVectorNextLine = new Vector();
    private TLAExpr self = null;
    private boolean selfIsSelf = false;
    private final Vector<String> vars = new Vector();
    private Vector pcV = new Vector();
    private Vector psV = new Vector();
    private PcalSymTab st = null;
    private boolean mp = false;
    private Vector nextStep = new Vector();
    private Vector nextStepSelf = new Vector();
    private int kludgeToFixPCHandlingBug;
    private String currentProcName;

    public Vector<String> generate(AST ast, PcalSymTab symtab, Vector report) throws PcalTLAGenException {
        TLAtoPCalMapping map = PcalParams.tlaPcalMapping;
        this.mappingVector = new Vector(50);
        for (int i = 0; i < report.size(); ++i) {
            this.addOneLineOfTLA((String)report.elementAt(i));
        }
        this.st = symtab;
        this.GenSym(ast, "");
        PCalLocation ZeroLocation = new PCalLocation(0, 0);
        ((Vector)this.mappingVector.elementAt(0)).add(0, new MappingObject.LeftParen(ZeroLocation));
        Vector lastLine = (Vector)this.mappingVector.elementAt(this.mappingVector.size() - 1);
        lastLine.add(lastLine.size(), new MappingObject.RightParen(ZeroLocation));
        int parenDepth = 0;
        for (int i = 0; i < this.mappingVector.size(); ++i) {
            Vector line = (Vector)this.mappingVector.elementAt(i);
            for (int j = 0; j < line.size(); ++j) {
                MappingObject obj = (MappingObject)line.elementAt(j);
                if (obj.getType() == 0) {
                    ++parenDepth;
                    continue;
                }
                if (obj.getType() != 1 || --parenDepth >= 0) continue;
                throw new NullPointerException("paren depth < 0");
            }
        }
        if (parenDepth != 0) {
            throw new NullPointerException("Unmatched Left Paren");
        }
        Vector<Vector<MappingObject>> nonredundantMappingVector = TLAtoPCalMapping.RemoveRedundantParens(this.mappingVector);
        map.makeMapping(nonredundantMappingVector);
        return this.tlacode;
    }

    private static boolean InVector(String var, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            if (!var.equals((String)v.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean IsProcedureVar(String var) {
        return PcalTLAGen.InVector(var, this.pcV);
    }

    private boolean IsProcessSetVar(String var) {
        return PcalTLAGen.InVector(var, this.psV);
    }

    private static String NSpaces(int n) {
        StringBuffer sb = new StringBuffer();
        PcalTLAGen.AddSpaces(sb, n);
        return sb.toString();
    }

    private static void AddSpaces(StringBuffer sb, int num) {
        for (int i = 0; i < num; ++i) {
            sb.append(" ");
        }
    }

    private static boolean EmptyExpr(TLAExpr expr) {
        if (expr == null) {
            return true;
        }
        return expr.tokens == null || expr.tokens.size() == 0;
    }

    private void GenSym(AST ast, String context) throws PcalTLAGenException {
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            this.GenUniprocess((AST.Uniprocess)ast, context);
        } else if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            this.GenMultiprocess((AST.Multiprocess)ast, context);
        } else if (ast.getClass().equals(AST.ProcedureObj.getClass())) {
            this.GenProcedure((AST.Procedure)ast, context);
        } else if (ast.getClass().equals(AST.ProcessObj.getClass())) {
            this.GenProcess((AST.Process)ast, context);
        } else if (ast.getClass().equals(AST.LabeledStmtObj.getClass())) {
            this.GenLabeledStmt((AST.LabeledStmt)ast, context);
        }
    }

    private void GenUniprocess(AST.Uniprocess ast, String context) throws PcalTLAGenException {
        int i;
        this.mp = false;
        this.currentProcName = "Next";
        this.GenVarsAndDefs(ast.decls, ast.prcds, null, ast.defs);
        this.GenInit(ast.decls, ast.prcds, null);
        for (i = 0; i < ast.prcds.size(); ++i) {
            this.GenProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
        }
        for (i = 0; i < ast.body.size(); ++i) {
            AST.LabeledStmt ls = (AST.LabeledStmt)ast.body.elementAt(i);
            this.nextStep.addElement(ls.label);
            this.GenLabeledStmt(ls, "");
        }
        this.GenNext();
        this.GenSpec();
        this.GenTermination();
    }

    private void GenMultiprocess(AST.Multiprocess ast, String context) throws PcalTLAGenException {
        int i;
        this.mp = true;
        this.GenVarsAndDefs(ast.decls, ast.prcds, ast.procs, ast.defs);
        this.GenProcSet();
        this.GenInit(ast.decls, ast.prcds, ast.procs);
        for (i = 0; i < ast.prcds.size(); ++i) {
            this.GenProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
        }
        for (i = 0; i < ast.procs.size(); ++i) {
            this.GenProcess((AST.Process)ast.procs.elementAt(i), "");
        }
        this.GenNext();
        this.GenSpec();
        this.GenTermination();
    }

    private void GenProcedure(AST.Procedure ast, String context) throws PcalTLAGenException {
        if (this.mp) {
            this.self = PcalTLAGen.selfAsExpr();
            this.selfIsSelf = true;
            this.nextStepSelf.addElement(ast.name + "(self)");
        } else {
            this.nextStep.addElement(ast.name);
        }
        for (int i = 0; i < ast.body.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)ast.body.elementAt(i);
            this.GenLabeledStmt(stmt, "procedure");
        }
        this.addLeftParen(ast.getOrigin());
        String argument = this.mp ? "(self)" : "";
        StringBuffer buf = new StringBuffer(ast.name + argument + " == ");
        this.addOneTokenToTLA(buf.toString());
        String indentSpaces = PcalTLAGen.NSpaces(buf.length() + 2);
        for (int i = 0; i < ast.body.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)ast.body.elementAt(i);
            String disjunct = stmt.label + argument;
            if (i != 0 && this.tlacodeNextLine.length() + 7 + disjunct.length() > wrapColumn) {
                this.endCurrentLineOfTLA();
            }
            if (i != 0) {
                this.addOneTokenToTLA((this.tlacodeNextLine.length() == 0 ? indentSpaces : "") + " \\/ ");
            }
            this.addLeftParen(stmt.getOrigin());
            this.addOneTokenToTLA(disjunct);
            this.addRightParen(stmt.getOrigin());
        }
        this.addRightParen(ast.getOrigin());
        this.addOneLineOfTLA("");
    }

    private void GenProcess(AST.Process ast, String context) throws PcalTLAGenException {
        this.currentProcName = ast.name;
        boolean isSet = true;
        if (ast.isEq) {
            this.self = ast.id;
            this.selfIsSelf = false;
            isSet = false;
        } else {
            this.self = PcalTLAGen.selfAsExpr();
            this.selfIsSelf = true;
        }
        if (isSet) {
            this.nextStepSelf.addElement(ast.name + "(self)");
        } else {
            this.nextStep.addElement(ast.name);
        }
        for (int i = 0; i < ast.body.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)ast.body.elementAt(i);
            this.GenLabeledStmt(stmt, "process");
        }
        if (!ParseAlgorithm.omitPC) {
            this.addLeftParen(ast.getOrigin());
            String argument = isSet ? "(self)" : "";
            StringBuffer buf = new StringBuffer(ast.name + argument + " == ");
            this.addOneTokenToTLA(buf.toString());
            String indentSpaces = PcalTLAGen.NSpaces(buf.length() + 2);
            for (int i = 0; i < ast.body.size(); ++i) {
                AST.LabeledStmt stmt = (AST.LabeledStmt)ast.body.elementAt(i);
                String disjunct = stmt.label + argument;
                if (i != 0 && this.tlacodeNextLine.length() + 7 + disjunct.length() > wrapColumn) {
                    this.endCurrentLineOfTLA();
                }
                if (i != 0) {
                    this.addOneTokenToTLA((this.tlacodeNextLine.length() == 0 ? indentSpaces : "") + " \\/ ");
                }
                this.addLeftParen(stmt.getOrigin());
                this.addOneTokenToTLA(disjunct);
                this.addRightParen(stmt.getOrigin());
            }
            this.addRightParen(ast.getOrigin());
            this.addOneLineOfTLA("");
        }
    }

    private void GenLabeledStmt(AST.LabeledStmt ast, String context) throws PcalTLAGenException {
        int i;
        int col;
        String actionName = ast.label;
        if (ParseAlgorithm.omitPC) {
            actionName = this.currentProcName;
        }
        StringBuffer sb = new StringBuffer(actionName);
        Changed c = new Changed(this.vars);
        if (this.mp && (context.equals("procedure") || this.selfIsSelf)) {
            sb.append("(self)");
        }
        sb.append(" == ");
        this.kludgeToFixPCHandlingBug = col = sb.length();
        sb.append("/\\ ");
        this.kludgeToFixPCHandlingBug += 3;
        int defStartLine = this.tlacode.size();
        int colAfterAnd = sb.length();
        PCalLocation macroBeginLeft = null;
        PCalLocation macroEndRight = null;
        boolean nonNullNotFound = true;
        for (i = 0; i < ast.stmts.size(); ++i) {
            AST stmt = (AST)ast.stmts.elementAt(i);
            if (stmt.getOrigin() == null) continue;
            if (nonNullNotFound) {
                nonNullNotFound = false;
                macroBeginLeft = stmt.macroOriginBegin;
            }
            macroEndRight = stmt.macroOriginEnd;
        }
        this.addLeftParenV(ast, macroBeginLeft);
        for (i = 0; i < ast.stmts.size(); ++i) {
            this.GenStmt((AST)ast.stmts.elementAt(i), c, context, sb.toString(), sb.length());
            sb = new StringBuffer(PcalTLAGen.NSpaces(col));
            sb.append("/\\ ");
        }
        Vector unc = c.Unchanged(wrapColumn - col - "/\\ UNCHANGED << ".length());
        if (c.NumUnchanged() > 1) {
            sb = new StringBuffer(PcalTLAGen.NSpaces(col));
            sb.append("/\\ UNCHANGED << ");
            int here = sb.length();
            sb.append((String)unc.elementAt(0));
            for (int i2 = 1; i2 < unc.size(); ++i2) {
                this.addOneLineOfTLA(sb.toString());
                sb = new StringBuffer(PcalTLAGen.NSpaces(here));
                sb.append((String)unc.elementAt(i2));
            }
            sb.append(" >>");
            this.addOneTokenToTLA(sb.toString());
        } else if (c.NumUnchanged() == 1) {
            if (c.Unchanged().length() > 5) {
                this.addOneTokenToTLA(PcalTLAGen.NSpaces(col) + "/\\ UNCHANGED " + c.Unchanged());
            } else {
                this.addOneTokenToTLA(PcalTLAGen.NSpaces(col) + "/\\ " + c.Unchanged() + "' = " + c.Unchanged());
            }
        } else if (ast.stmts.size() == 1) {
            for (int i3 = defStartLine; i3 < this.tlacode.size(); ++i3) {
                String line = (String)this.tlacode.elementAt(i3);
                if (i3 == defStartLine) {
                    this.tlacode.setElementAt(line.substring(0, colAfterAnd - 3) + line.substring(colAfterAnd, line.length()), i3);
                    this.shiftMappingVectorTokensLeft(i3, colAfterAnd, 3);
                    continue;
                }
                if (line.length() <= 3) continue;
                this.tlacode.setElementAt(line.substring(3, line.length()), i3);
                this.shiftMappingVectorTokensLeft(i3, colAfterAnd, 3);
            }
        }
        this.addRightParenV(ast, macroEndRight);
        this.addOneLineOfTLA("");
    }

    private void shiftMappingVectorTokensLeft(int lineNum, int startCol, int shift) {
        boolean lastWasBeginTLAToken = false;
        int lastBeginTLATokCol = -777;
        Vector line = (Vector)this.mappingVector.elementAt(lineNum);
        for (int i = 0; i < line.size(); ++i) {
            int col;
            MappingObject tobj;
            MappingObject obj = (MappingObject)line.elementAt(i);
            if (obj.getType() == 2) {
                tobj = (MappingObject.BeginTLAToken)obj;
                col = ((MappingObject.BeginTLAToken)tobj).getColumn();
                if (col >= startCol) {
                    ((MappingObject.BeginTLAToken)tobj).setColumn(col - shift);
                }
                lastWasBeginTLAToken = true;
                lastBeginTLATokCol = ((MappingObject.BeginTLAToken)tobj).getColumn();
                continue;
            }
            if (obj.getType() == 3) {
                tobj = (MappingObject.EndTLAToken)obj;
                col = ((MappingObject.EndTLAToken)tobj).getColumn();
                if (col >= startCol) {
                    ((MappingObject.EndTLAToken)tobj).setColumn(col - shift);
                }
                if (!lastWasBeginTLAToken || ((MappingObject.EndTLAToken)tobj).getColumn() > lastBeginTLATokCol) continue;
                PcalDebug.ReportBug("PcalTLAGen.shiftMappingVectorTokensLeft created a null TLA Token");
                continue;
            }
            if (obj.getType() != 4) continue;
            tobj = (MappingObject.SourceToken)obj;
            col = ((MappingObject.SourceToken)tobj).getBeginColumn();
            if (col >= startCol) {
                ((MappingObject.SourceToken)tobj).setBeginColumn(col - shift);
            }
            if ((col = ((MappingObject.SourceToken)tobj).getEndColumn()) >= startCol) {
                ((MappingObject.SourceToken)tobj).setEndColumn(col - shift);
            }
            lastWasBeginTLAToken = false;
        }
    }

    private void GenStmt(AST ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        if (ast.getClass().equals(AST.AssignObj.getClass())) {
            this.GenAssign((AST.Assign)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.IfObj.getClass())) {
            this.GenIf((AST.If)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.EitherObj.getClass())) {
            this.GenEither((AST.Either)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.WithObj.getClass())) {
            this.GenWith((AST.With)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.WhenObj.getClass())) {
            this.GenWhen((AST.When)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.PrintSObj.getClass())) {
            this.GenPrintS((AST.PrintS)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.AssertObj.getClass())) {
            this.GenAssert((AST.Assert)ast, c, context, prefix, col);
        } else if (ast.getClass().equals(AST.SkipObj.getClass())) {
            this.GenSkip((AST.Skip)ast, c, context, prefix, col);
        } else {
            PcalDebug.ReportBug("Unexpected AST type " + ast.toString());
        }
    }

    private void GenAssign(AST.Assign ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        Changed cThis = new Changed(c);
        StringBuffer sb = new StringBuffer();
        ast.ass = PcalTLAGen.SortSass(ast.ass);
        this.addOneTokenToTLA(prefix);
        this.addLeftParen(ast.getOrigin());
        int i = 0;
        int numAssigns = 0;
        boolean hasMultipleVars = false;
        while (i < ast.ass.size()) {
            AST.SingleAssign sass;
            AST.SingleAssign sF = (AST.SingleAssign)ast.ass.elementAt(i);
            if (!this.vars.contains(sF.lhs.var)) {
                throw new PcalTLAGenException("Assignment to undeclared variable " + sF.lhs.var, sF);
            }
            int iFirst = i;
            int iLast = i;
            boolean hasAssignmentWithNoSubscript = false;
            boolean lastAssignmentHasNoSubscript = PcalTLAGen.EmptyExpr(sF.lhs.sub);
            AST.SingleAssign sL = (AST.SingleAssign)ast.ass.elementAt(i);
            while (iLast < ast.ass.size() && sF.lhs.var.equals(sL.lhs.var)) {
                if (lastAssignmentHasNoSubscript) {
                    hasAssignmentWithNoSubscript = true;
                }
                if (++iLast >= ast.ass.size()) continue;
                sL = (AST.SingleAssign)ast.ass.elementAt(iLast);
                if (!PcalTLAGen.EmptyExpr(sL.lhs.sub)) continue;
                lastAssignmentHasNoSubscript = true;
            }
            if (iLast != ast.ass.size()) {
                hasMultipleVars = true;
            }
            if (cThis.Set(sF.lhs.var) > 1 || --iLast - iFirst > 0 && hasAssignmentWithNoSubscript) {
                throw new PcalTLAGenException("Multiple assignment to " + sF.lhs.var, ast);
            }
            ++numAssigns;
            Vector lines = new Vector();
            if (hasMultipleVars) {
                sb.append("/\\ ");
            }
            if (iFirst == iLast) {
                sass = sF;
                this.addLeftParen(sass.getOrigin());
                TLAExpr sub = this.AddSubscriptsToExpr(sass.lhs.sub, PcalTLAGen.SubExpr(this.Self(context)), c);
                TLAExpr rhs = this.AddSubscriptsToExpr(sass.rhs, PcalTLAGen.SubExpr(this.Self(context)), c);
                if (this.mp && (sass.lhs.var.equals("pc") || this.IsProcedureVar(sass.lhs.var) || this.IsProcessSetVar(sass.lhs.var) || sass.lhs.var.equals("stack"))) {
                    sb.append(sass.lhs.var);
                    sb.append("' = [");
                    int wrapCol = sb.length() + 2;
                    sb.append(sass.lhs.var);
                    sb.append(" EXCEPT ");
                    Vector selfAsSV = this.self.toStringVector();
                    if (sb.length() + prefix.length() > ssWrapColumn && selfAsSV.size() == 0) {
                        this.addOneLineOfTLA(sb.toString());
                        sb = new StringBuffer(PcalTLAGen.NSpaces(wrapCol));
                    }
                    sb.append("![");
                    this.addOneTokenToTLA(sb.toString());
                    this.addLeftParen(this.self.getOrigin());
                    this.addExprToTLA(this.self);
                    this.addRightParen(this.self.getOrigin());
                    this.addOneTokenToTLA("]");
                    Vector sv = sub.toStringVector();
                    if (sv.size() > 0) {
                        this.addLeftParen(sub.getOrigin());
                        this.addExprToTLA(sub);
                        this.addRightParen(sub.getOrigin());
                    }
                    this.addOneTokenToTLA(" = ");
                    this.addLeftParen(rhs.getOrigin());
                    this.addExprToTLA(rhs);
                    this.addRightParen(rhs.getOrigin());
                    this.addOneTokenToTLA("]");
                    sb = new StringBuffer();
                } else if (!PcalTLAGen.EmptyExpr(sass.lhs.sub)) {
                    sb.append(sass.lhs.var);
                    sb.append("' = [");
                    sb.append(sass.lhs.var);
                    sb.append(" EXCEPT !");
                    this.addOneTokenToTLA(sb.toString());
                    this.addLeftParen(sub.getOrigin());
                    this.addExprToTLA(sub);
                    this.addRightParen(sub.getOrigin());
                    this.addOneTokenToTLA(" = ");
                    this.addLeftParen(rhs.getOrigin());
                    this.addExprToTLA(rhs);
                    this.addRightParen(rhs.getOrigin());
                    this.addOneTokenToTLA("]");
                    sb = new StringBuffer();
                } else {
                    sb.append(sass.lhs.var);
                    sb.append("' = ");
                    boolean needsParens = PcalTLAGen.NeedsParentheses(rhs.toStringVector());
                    if (needsParens) {
                        sb.append("(");
                    }
                    this.addOneTokenToTLA(sb.toString());
                    this.addLeftParen(rhs.getOrigin());
                    this.addExprToTLA(rhs);
                    this.addRightParen(rhs.getOrigin());
                    if (needsParens) {
                        this.addOneTokenToTLA(")");
                    }
                    sb = new StringBuffer();
                }
                this.addRightParen(sass.getOrigin());
            } else {
                boolean subscript;
                sass = sF;
                sb.append(sass.lhs.var);
                sb.append("' = [");
                sb.append(sass.lhs.var);
                sb.append(" EXCEPT ");
                int cc = sb.length();
                if (i == 0) {
                    cc += prefix.length();
                }
                boolean bl = subscript = this.mp && (this.IsProcedureVar(sass.lhs.var) || this.IsProcessSetVar(sass.lhs.var));
                while (iFirst <= iLast) {
                    sass = (AST.SingleAssign)ast.ass.elementAt(iFirst);
                    TLAExpr sub = this.AddSubscriptsToExpr(sass.lhs.sub, PcalTLAGen.SubExpr(this.Self(context)), c);
                    TLAExpr rhs = this.AddSubscriptsToExpr(sass.rhs, PcalTLAGen.SubExpr(this.Self(context)), c);
                    this.addLeftParen(sass.getOrigin());
                    sb.append("!");
                    if (subscript) {
                        sb.append("[");
                        this.addOneTokenToTLA(sb.toString());
                        TLAExpr self = this.Self(context);
                        this.addLeftParen(self.getOrigin());
                        this.addExprToTLA(self);
                        this.addOneTokenToTLA("]");
                    } else {
                        this.addOneTokenToTLA(sb.toString());
                    }
                    this.addLeftParen(sub.getOrigin());
                    this.addExprToTLA(sub);
                    this.addRightParen(sub.getOrigin());
                    this.addOneTokenToTLA(" = ");
                    this.addLeftParen(rhs.getOrigin());
                    this.addExprToTLA(rhs);
                    this.addRightParen(rhs.getOrigin());
                    this.addRightParen(sass.getOrigin());
                    this.addOneTokenToTLA(iFirst == iLast ? "]" : ",");
                    sb = new StringBuffer();
                    if (iFirst < iLast) {
                        this.endCurrentLineOfTLA();
                        PcalTLAGen.AddSpaces(sb, cc);
                    }
                    ++iFirst;
                }
            }
            if ((i = iLast + 1) >= ast.ass.size()) continue;
            this.endCurrentLineOfTLA();
            PcalTLAGen.AddSpaces(sb, prefix.length());
        }
        this.addRightParen(ast.getOrigin());
        this.endCurrentLineOfTLA();
        c.Merge(cThis);
    }

    private void GenIf(AST.If ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        int i;
        int cc;
        int i2;
        Changed cThen = new Changed(c);
        Changed cElse = new Changed(c);
        StringBuffer sb = new StringBuffer(prefix);
        TLAExpr test = null;
        test = this.AddSubscriptsToExpr(ast.test, PcalTLAGen.SubExpr(this.Self(context)), c);
        sb.append("IF ");
        int here = sb.length();
        this.addLeftParen(ast.getOrigin());
        this.addOneTokenToTLA(sb.toString());
        this.addExprToTLA(test);
        this.endCurrentLineOfTLA();
        sb = new StringBuffer(PcalTLAGen.NSpaces(here));
        sb.append("THEN ");
        here = sb.length();
        sb.append("/\\ ");
        for (i2 = 0; i2 < ast.Then.size(); ++i2) {
            this.GenStmt((AST)ast.Then.elementAt(i2), cThen, context, sb.toString(), here + 3);
            sb = new StringBuffer(PcalTLAGen.NSpaces(here) + "/\\ ");
        }
        int lineUncThen = this.tlacode.size();
        this.addOneLineOfTLA(sb.toString());
        sb = new StringBuffer(PcalTLAGen.NSpaces(here - "THEN ".length()) + "ELSE ");
        here = sb.length();
        if (ast.Else.size() == 0) {
            sb.append("/\\ TRUE");
            this.addOneLineOfTLA(sb.toString());
            sb = new StringBuffer(PcalTLAGen.NSpaces(here) + "/\\ ");
        } else {
            sb.append("/\\ ");
            for (i2 = 0; i2 < ast.Else.size(); ++i2) {
                this.GenStmt((AST)ast.Else.elementAt(i2), cElse, context, sb.toString(), here + 3);
                sb = new StringBuffer(PcalTLAGen.NSpaces(here) + "/\\ ");
            }
        }
        if (cElse.NumUnchanged(cThen) > 1) {
            Vector uncElse = cElse.Unchanged(cThen, wrapColumn - sb.length() - "UNCHANGED << ".length());
            sb.append("UNCHANGED << ");
            cc = sb.length();
            sb.append((String)uncElse.elementAt(0));
            for (i = 1; i < uncElse.size(); ++i) {
                this.addOneLineOfTLA(sb.toString());
                sb = new StringBuffer(PcalTLAGen.NSpaces(cc));
                sb.append((String)uncElse.elementAt(i));
            }
            sb.append(" >>");
            this.addOneTokenToTLA(sb.toString());
            this.addRightParen(ast.getOrigin());
            this.endCurrentLineOfTLA();
        } else if (cElse.NumUnchanged(cThen) == 1) {
            String uc = cElse.Unchanged(cThen);
            if (uc.length() > 5) {
                sb.append("UNCHANGED " + uc);
            } else {
                sb.append(uc + "' = " + uc);
            }
            this.addOneTokenToTLA(sb.toString());
            this.addRightParen(ast.getOrigin());
            this.endCurrentLineOfTLA();
        } else {
            ((Vector)this.mappingVector.elementAt(this.mappingVector.size() - 1)).add(new MappingObject.RightParen(ast.getOrigin().getEnd()));
        }
        sb = new StringBuffer((String)this.tlacode.elementAt(lineUncThen));
        this.tlacode.removeElementAt(lineUncThen);
        this.mappingVector.removeElementAt(lineUncThen);
        if (cThen.NumUnchanged(cElse) > 1) {
            Vector uncThen = cThen.Unchanged(cElse, wrapColumn - sb.length() - "UNCHANGED << ".length());
            sb.append("UNCHANGED << ");
            cc = sb.length();
            sb.append((String)uncThen.elementAt(0));
            for (i = 1; i < uncThen.size(); ++i) {
                this.tlacode.insertElementAt(sb.toString(), lineUncThen);
                this.mappingVector.insertElementAt(this.stringToTLATokens(sb.toString()), lineUncThen);
                ++lineUncThen;
                sb = new StringBuffer(PcalTLAGen.NSpaces(cc));
                sb.append((String)uncThen.elementAt(i));
            }
            sb.append(" >>");
            this.tlacode.insertElementAt(sb.toString(), lineUncThen);
            Vector vec = this.stringToTLATokens(sb.toString());
            this.mappingVector.insertElementAt(vec, lineUncThen);
        } else if (cThen.NumUnchanged(cElse) == 1) {
            String uc = cThen.Unchanged(cElse);
            if (uc.length() > 5) {
                sb.append("UNCHANGED " + uc);
            } else {
                sb.append(uc + "' = " + uc);
            }
            this.tlacode.insertElementAt(sb.toString(), lineUncThen);
            Vector vec = this.stringToTLATokens(sb.toString());
            this.mappingVector.insertElementAt(vec, lineUncThen);
        }
        c.Merge(cThen);
        c.Merge(cElse);
    }

    private Vector stringToTLATokens(String token) {
        int numberOfLeftTrimmedTokens;
        Vector<MappingObject> result = new Vector<MappingObject>(3);
        String trimmedToken = token.trim();
        int n = numberOfLeftTrimmedTokens = trimmedToken.length() == 0 ? -1 : token.indexOf(trimmedToken.charAt(0));
        if (numberOfLeftTrimmedTokens == -1) {
            numberOfLeftTrimmedTokens = 0;
            trimmedToken = token;
        }
        int objBegin = numberOfLeftTrimmedTokens;
        result.addElement(new MappingObject.BeginTLAToken(objBegin));
        result.addElement(new MappingObject.EndTLAToken(objBegin + trimmedToken.length()));
        return result;
    }

    private void GenEither(AST.Either ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        int i;
        Changed allC = new Changed(c);
        Changed[] cOrs = new Changed[ast.ors.size()];
        int[] ucLocs = new int[ast.ors.size()];
        StringBuffer sb = new StringBuffer(prefix);
        int prefixIndent = sb.length();
        sb.append("\\/ ");
        int here = sb.length();
        this.addLeftParen(ast.getOrigin());
        for (i = 0; i < ast.ors.size(); ++i) {
            if (i != 0) {
                sb = new StringBuffer(PcalTLAGen.NSpaces(prefixIndent) + "\\/ ");
            }
            sb.append("/\\ ");
            Vector orClause = (Vector)ast.ors.elementAt(i);
            Changed cC = new Changed(c);
            for (int j = 0; j < orClause.size(); ++j) {
                this.GenStmt((AST)orClause.elementAt(j), cC, context, sb.toString(), here + 3);
                sb = new StringBuffer(PcalTLAGen.NSpaces(here) + "/\\ ");
            }
            cOrs[i] = cC;
            allC.Merge(cC);
            ucLocs[i] = this.tlacode.size();
            this.addOneLineOfTLA("Replace by UNCHANGED");
        }
        i = ast.ors.size();
        while (i > 0) {
            String line;
            this.tlacode.removeElementAt(ucLocs[--i]);
            this.mappingVector.removeElementAt(ucLocs[i]);
            int numUnchanged = cOrs[i].NumUnchanged(allC);
            String NotChanged = cOrs[i].Unchanged(allC);
            if (numUnchanged > 1) {
                line = PcalTLAGen.NSpaces(here) + "/\\ UNCHANGED <<" + NotChanged + ">>";
                this.tlacode.insertElementAt(line, ucLocs[i]);
                this.mappingVector.insertElementAt(this.stringToTLATokens(line), ucLocs[i]);
                continue;
            }
            if (numUnchanged != 1) continue;
            if (NotChanged.length() > 5) {
                line = PcalTLAGen.NSpaces(here) + "/\\ UNCHANGED " + NotChanged;
                this.tlacode.insertElementAt(line, ucLocs[i]);
                this.mappingVector.insertElementAt(this.stringToTLATokens(line), ucLocs[i]);
                continue;
            }
            line = PcalTLAGen.NSpaces(here) + "/\\ " + NotChanged + "' = " + NotChanged;
            this.tlacode.insertElementAt(line, ucLocs[i]);
            this.mappingVector.insertElementAt(this.stringToTLATokens(line), ucLocs[i]);
        }
        ((Vector)this.mappingVector.elementAt(this.mappingVector.size() - 1)).add(new MappingObject.RightParen(ast.getOrigin().getEnd()));
        c.Merge(allC);
    }

    private void GenWith(AST.With ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        this.addLeftParen(ast.getOrigin());
        StringBuffer sb = new StringBuffer(prefix);
        TLAExpr exp = this.AddSubscriptsToExpr(ast.exp, PcalTLAGen.SubExpr(this.Self(context)), c);
        if (ast.isEq) {
            sb.append("LET ");
            sb.append(ast.var);
            sb.append(" == ");
            this.addOneTokenToTLA(sb.toString());
            this.addLeftParen(exp.getOrigin());
            this.addExprToTLA(exp);
            this.addRightParen(exp.getOrigin());
            this.addOneTokenToTLA(" IN");
            this.endCurrentLineOfTLA();
            sb = new StringBuffer(PcalTLAGen.NSpaces(col + 2));
            if (ast.Do.size() > 1) {
                sb.append("/\\ ");
            }
        } else {
            sb.append("\\E ");
            sb.append(ast.var);
            sb.append(" \\in ");
            this.addOneTokenToTLA(sb.toString());
            this.addLeftParen(exp.getOrigin());
            this.addExprToTLA(exp);
            this.addRightParen(exp.getOrigin());
            this.addOneTokenToTLA(":");
            this.endCurrentLineOfTLA();
            sb = new StringBuffer(PcalTLAGen.NSpaces(col + 2));
            if (ast.Do.size() > 1) {
                sb.append("/\\ ");
            }
        }
        for (int i = 0; i < ast.Do.size(); ++i) {
            this.GenStmt((AST)ast.Do.elementAt(i), c, context, sb.toString(), sb.length());
            sb = new StringBuffer(PcalTLAGen.NSpaces(col + 2) + "/\\ ");
        }
        ((Vector)this.mappingVector.elementAt(this.mappingVector.size() - 1)).add(new MappingObject.RightParen(ast.getOrigin().getEnd()));
    }

    private void GenWhen(AST.When ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        this.addOneTokenToTLA(prefix);
        TLAExpr exp = this.AddSubscriptsToExpr(ast.exp, PcalTLAGen.SubExpr(this.Self(context)), c);
        this.addLeftParen(exp.getOrigin());
        this.addExprToTLA(exp);
        this.addRightParen(exp.getOrigin());
        this.endCurrentLineOfTLA();
    }

    private void GenPrintS(AST.PrintS ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        StringBuffer sb = new StringBuffer(prefix);
        TLAExpr exp = this.AddSubscriptsToExpr(ast.exp, PcalTLAGen.SubExpr(this.Self(context)), c);
        this.addLeftParen(ast.getOrigin());
        this.addOneTokenToTLA(prefix + "PrintT(");
        this.addExprToTLA(exp);
        this.addOneTokenToTLA(")");
        this.addRightParen(ast.getOrigin());
        this.endCurrentLineOfTLA();
    }

    private void GenAssert(AST.Assert ast, Changed c, String context, String prefix, int col) throws PcalTLAGenException {
        this.addLeftParen(ast.getOrigin());
        StringBuffer sb = new StringBuffer(prefix);
        StringBuffer sc = new StringBuffer();
        TLAExpr exp = this.AddSubscriptsToExpr(ast.exp, PcalTLAGen.SubExpr(this.Self(context)), c);
        sb.append("Assert(");
        this.addOneTokenToTLA(sb.toString());
        this.addLeftParen(exp.getOrigin());
        this.addExprToTLA(exp);
        this.addRightParen(exp.getOrigin());
        int here = sb.length();
        sb = new StringBuffer(", ");
        sc.append("\"Failure of assertion at ");
        sc.append(ast.location());
        sc.append(".\")");
        if (this.tlacodeNextLine.length() + sb.length() + sc.length() < wrapColumn) {
            this.addOneTokenToTLA(sb.toString() + sc.toString());
        } else {
            this.addOneTokenToTLA(sb.toString());
            this.endCurrentLineOfTLA();
            this.addOneTokenToTLA(PcalTLAGen.NSpaces(here) + sc.toString());
        }
        this.addRightParen(ast.getOrigin());
        this.endCurrentLineOfTLA();
    }

    private void GenSkip(AST.Skip ast, Changed c, String context, String prefix, int col) {
        this.addOneTokenToTLA(prefix);
        this.addLeftParen(ast.getOrigin());
        this.addOneTokenToTLA("TRUE");
        this.addRightParen(ast.getOrigin());
        this.endCurrentLineOfTLA();
    }

    private void GenVarsAndDefs(Vector globals, Vector procs, Vector processes, TLAExpr defs) throws PcalTLAGenException {
        AST decl;
        int p;
        AST proc;
        int i;
        Vector<String> lVars = new Vector<String>();
        Vector<String> gVars = new Vector<String>();
        Vector<AST> lVarsSource = new Vector<AST>();
        Vector<AST> gVarsSource = new Vector<AST>();
        if (globals != null) {
            for (i = 0; i < globals.size(); ++i) {
                AST.VarDecl decl2 = (AST.VarDecl)globals.elementAt(i);
                gVars.addElement(decl2.var);
                gVarsSource.addElement(decl2);
                this.vars.addElement(decl2.var);
            }
        }
        if (!ParseAlgorithm.omitPC) {
            gVars.addElement("pc");
            AST.VarDecl pcVarDecl = new AST.VarDecl();
            pcVarDecl.var = "pc";
            gVarsSource.addElement(pcVarDecl);
            this.vars.addElement("pc");
        }
        if (procs != null && procs.size() > 0) {
            gVars.addElement("stack");
            AST.VarDecl pcVarDecl = new AST.VarDecl();
            pcVarDecl.var = "stack";
            gVarsSource.addElement(pcVarDecl);
            this.vars.addElement("stack");
        }
        if (procs != null) {
            for (i = 0; i < procs.size(); ++i) {
                proc = (AST.Procedure)procs.elementAt(i);
                if (proc.params != null) {
                    for (p = 0; p < proc.params.size(); ++p) {
                        decl = (AST.PVarDecl)proc.params.elementAt(p);
                        lVars.addElement(((AST.PVarDecl)decl).var);
                        lVarsSource.addElement(((AST.PVarDecl)decl).toVarDecl());
                        this.vars.addElement(((AST.PVarDecl)decl).var);
                        this.pcV.addElement(((AST.PVarDecl)decl).var);
                    }
                }
                if (proc.decls == null) continue;
                for (p = 0; p < proc.decls.size(); ++p) {
                    decl = (AST.PVarDecl)proc.decls.elementAt(p);
                    lVars.addElement(((AST.PVarDecl)decl).var);
                    lVarsSource.addElement(((AST.PVarDecl)decl).toVarDecl());
                    this.vars.addElement(((AST.PVarDecl)decl).var);
                    this.pcV.addElement(((AST.PVarDecl)decl).var);
                }
            }
        }
        if (processes != null) {
            for (i = 0; i < processes.size(); ++i) {
                proc = (AST.Process)processes.elementAt(i);
                if (((AST.Process)proc).decls == null) continue;
                for (p = 0; p < ((AST.Process)proc).decls.size(); ++p) {
                    decl = (AST.VarDecl)((AST.Process)proc).decls.elementAt(p);
                    lVars.addElement(((AST.VarDecl)decl).var);
                    lVarsSource.addElement(decl);
                    this.vars.addElement(((AST.VarDecl)decl).var);
                    if (((AST.Process)proc).isEq) continue;
                    this.psV.addElement(((AST.VarDecl)decl).var);
                }
            }
        }
        if (ParseAlgorithm.hasDefaultInitialization) {
            this.addOneLineOfTLA("CONSTANT defaultInitValue");
        }
        if (PcalTLAGen.EmptyExpr(defs)) {
            gVars.addAll(lVars);
            gVarsSource.addAll(lVarsSource);
            this.GenVarDecl(gVars, gVarsSource);
        } else {
            this.GenVarDecl(gVars, gVarsSource);
            this.addOneLineOfTLA("");
            this.addOneLineOfTLA("(* define statement *)");
            this.addExprToTLA(defs);
            this.addOneLineOfTLA("");
            this.GenVarDecl(lVars, lVarsSource);
            gVars.addAll(lVars);
            gVarsSource.addAll(lVarsSource);
        }
        this.addOneLineOfTLA("");
        if (gVars.size() == 0) {
            throw new PcalTLAGenException("The algorithm has no variables.");
        }
        this.addOneTokenToTLA("vars == << ");
        int indent = this.tlacodeNextLine.length();
        for (int i2 = 0; i2 < gVars.size(); ++i2) {
            if (i2 > 0) {
                this.addOneTokenToTLA(", ");
            }
            String vbl = (String)gVars.elementAt(i2);
            AST.VarDecl vblDecl = (AST.VarDecl)gVarsSource.elementAt(i2);
            Region vblOrigin = vblDecl.getOrigin();
            if (this.tlacodeNextLine.length() + vbl.length() + 1 > wrapColumn) {
                this.endCurrentLineOfTLA();
                this.tlacodeNextLine = PcalTLAGen.NSpaces(indent);
            }
            this.addOneSourceTokenToTLA(vbl, vblOrigin);
        }
        if (this.tlacodeNextLine.length() + " >>".length() + 1 > wrapColumn) {
            this.endCurrentLineOfTLA();
            this.tlacodeNextLine = PcalTLAGen.NSpaces("vars ==".length());
        }
        this.addOneTokenToTLA(" >>");
        this.addOneLineOfTLA("");
    }

    public void GenVarDecl(Vector varVec, Vector varVecSource) {
        if (varVec.size() == 0) {
            return;
        }
        if (varVec.size() > 1) {
            this.addOneTokenToTLA("VARIABLES ");
        } else {
            this.addOneTokenToTLA("VARIABLE ");
        }
        for (int i = 0; i < varVec.size(); ++i) {
            if (i > 0) {
                this.addOneTokenToTLA(", ");
            }
            String vbl = (String)varVec.elementAt(i);
            AST vblsource = (AST)varVecSource.elementAt(i);
            if (this.tlacodeNextLine.length() + vbl.length() + 1 > wrapColumn) {
                this.endCurrentLineOfTLA();
                this.tlacodeNextLine = varVec.size() > 1 ? this.tlacodeNextLine + PcalTLAGen.NSpaces("VARIABLES ".length()) : this.tlacodeNextLine + PcalTLAGen.NSpaces("VARIABLE ".length());
            }
            this.addOneSourceTokenToTLA(vbl, vblsource.getOrigin());
        }
        this.endCurrentLineOfTLA();
    }

    public void GenProcSet() {
        StringBuffer ps = new StringBuffer();
        if (this.st.processes == null || this.st.processes.size() == 0) {
            return;
        }
        this.addOneTokenToTLA("ProcSet == ");
        for (int i = 0; i < this.st.processes.size(); ++i) {
            PcalSymTab.ProcessEntry proc = (PcalSymTab.ProcessEntry)this.st.processes.elementAt(i);
            if (i > 0) {
                this.addOneTokenToTLA(" \\cup ");
            }
            this.addLeftParen(proc.id.getOrigin());
            if (proc.isEq) {
                this.addOneTokenToTLA("{");
            } else {
                this.addOneTokenToTLA("(");
            }
            int col = ps.length();
            this.addExprToTLA(proc.id);
            if (proc.isEq) {
                this.addOneTokenToTLA("}");
            } else {
                this.addOneTokenToTLA(")");
            }
            this.addRightParen(proc.id.getOrigin());
        }
        this.endCurrentLineOfTLA();
        this.addOneLineOfTLA("");
    }

    private void GenInit(Vector globals, Vector procs, Vector processes) throws PcalTLAGenException {
        AST decl;
        int p;
        AST proc;
        int i;
        int col = "Init == ".length();
        StringBuffer is = new StringBuffer();
        is.append("Init == ");
        if (globals != null && globals.size() > 0) {
            is.append("(* Global variables *)");
            this.addOneLineOfTLA(is.toString());
            is = new StringBuffer(PcalTLAGen.NSpaces(col));
            for (i = 0; i < globals.size(); ++i) {
                AST.VarDecl decl2 = (AST.VarDecl)globals.elementAt(i);
                this.addVarDeclToTLA(decl2, is);
                is = new StringBuffer(PcalTLAGen.NSpaces(col));
            }
        }
        if (procs != null && procs.size() > 0) {
            for (i = 0; i < procs.size(); ++i) {
                proc = (AST.Procedure)procs.elementAt(i);
                if (proc.params.size() == 0 && proc.decls.size() == 0) continue;
                is.append("(* Procedure ");
                is.append(proc.name);
                is.append(" *)");
                this.addOneLineOfTLA(is.toString());
                is = new StringBuffer(PcalTLAGen.NSpaces(col));
                for (p = 0; p < proc.params.size(); ++p) {
                    decl = (AST.PVarDecl)proc.params.elementAt(p);
                    if (!this.mp) {
                        this.addVarDeclToTLA(((AST.PVarDecl)decl).toVarDecl(), is);
                    } else {
                        is.append("/\\ ");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(decl.getOrigin());
                        is = new StringBuffer(((AST.PVarDecl)decl).var);
                        decl.getClass();
                        PcalDebug.Assert(true);
                        is.append(" = ");
                        is.append("[ self \\in ProcSet |-> ");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(((AST.PVarDecl)decl).val.getOrigin());
                        this.addExprToTLA(this.AddSubscriptsToExpr(((AST.PVarDecl)decl).val, PcalTLAGen.SubExpr(this.Self("procedure")), new Changed(new Vector())));
                        this.addRightParen(((AST.PVarDecl)decl).val.getOrigin());
                        this.addOneTokenToTLA("]");
                        this.addRightParen(decl.getOrigin());
                        this.endCurrentLineOfTLA();
                    }
                    is = new StringBuffer(PcalTLAGen.NSpaces(col));
                }
                for (p = 0; p < proc.decls.size(); ++p) {
                    decl = (AST.PVarDecl)proc.decls.elementAt(p);
                    if (!this.mp) {
                        this.addVarDeclToTLA(((AST.PVarDecl)decl).toVarDecl(), is);
                    } else {
                        is.append("/\\ ");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(decl.getOrigin());
                        is = new StringBuffer(((AST.PVarDecl)decl).var);
                        decl.getClass();
                        PcalDebug.Assert(true);
                        is.append(" = ");
                        is.append("[ self \\in ProcSet |-> ");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(((AST.PVarDecl)decl).val.getOrigin());
                        this.addExprToTLA(this.AddSubscriptsToExpr(((AST.PVarDecl)decl).val, PcalTLAGen.SubExpr(this.Self("procedure")), new Changed(new Vector())));
                        this.addRightParen(((AST.PVarDecl)decl).val.getOrigin());
                        this.addOneTokenToTLA("]");
                        this.addRightParen(decl.getOrigin());
                        this.endCurrentLineOfTLA();
                    }
                    is = new StringBuffer(PcalTLAGen.NSpaces(col));
                }
            }
        }
        if (processes != null && processes.size() > 0) {
            for (i = 0; i < processes.size(); ++i) {
                proc = (AST.Process)processes.elementAt(i);
                if (((AST.Process)proc).decls.size() == 0) continue;
                is.append("(* Process ");
                is.append(((AST.Process)proc).name);
                is.append(" *)");
                this.addOneLineOfTLA(is.toString());
                is = new StringBuffer(PcalTLAGen.NSpaces(col));
                for (p = 0; p < ((AST.Process)proc).decls.size(); ++p) {
                    decl = (AST.VarDecl)((AST.Process)proc).decls.elementAt(p);
                    is.append("/\\ ");
                    this.addOneTokenToTLA(is.toString());
                    this.addLeftParen(decl.getOrigin());
                    if (((AST.Process)proc).isEq) {
                        is = new StringBuffer(((AST.VarDecl)decl).var);
                        if (((AST.VarDecl)decl).isEq) {
                            is.append(" = ");
                        } else {
                            is.append(" \\in ");
                        }
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(((AST.VarDecl)decl).val.getOrigin());
                        this.addExprToTLA(((AST.VarDecl)decl).val);
                        this.addRightParen(((AST.VarDecl)decl).val.getOrigin());
                    } else if (((AST.VarDecl)decl).isEq) {
                        is = new StringBuffer(((AST.VarDecl)decl).var);
                        is.append(" = [self \\in ");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(((AST.Process)proc).id.getOrigin());
                        this.addExprToTLA(((AST.Process)proc).id);
                        this.addRightParen(((AST.Process)proc).id.getOrigin());
                        this.addOneTokenToTLA(" |-> ");
                        this.addLeftParen(((AST.VarDecl)decl).val.getOrigin());
                        this.addExprToTLA(this.AddSubscriptsToExpr(((AST.VarDecl)decl).val, PcalTLAGen.SubExpr(this.Self("procedure")), new Changed(new Vector())));
                        this.addRightParen(((AST.VarDecl)decl).val.getOrigin());
                        this.addOneTokenToTLA("]");
                    } else {
                        TLAExpr subexpr = ((AST.Process)proc).id.cloneAndNormalize();
                        TLAExpr expr = new TLAExpr();
                        expr.addLine();
                        expr.addToken(new TLAToken("[", 0, 1));
                        expr.addToken(new TLAToken("CHOOSE", 1, 1));
                        expr.addToken(new TLAToken("self", 8, 4));
                        expr.addToken(new TLAToken("\\in ", 13, 1));
                        expr.normalize();
                        expr.setOrigin(subexpr.getOrigin());
                        try {
                            subexpr.prepend(expr, 1);
                            expr = new TLAExpr();
                            expr.addLine();
                            expr.addToken(new TLAToken(":", 0, 1));
                            expr.addToken(new TLAToken("TRUE", 2, 1));
                            expr.addToken(new TLAToken("]", 6, 1));
                            expr.prepend(subexpr, 1);
                        }
                        catch (TLAExprException e) {
                            throw new PcalTLAGenException(e.getMessage());
                        }
                        is = new StringBuffer(((AST.VarDecl)decl).var);
                        is.append(" \\in [");
                        this.addOneTokenToTLA(is.toString());
                        this.addLeftParen(((AST.Process)proc).id.getOrigin());
                        this.addExprToTLA(((AST.Process)proc).id);
                        this.addRightParen(((AST.Process)proc).id.getOrigin());
                        this.addOneTokenToTLA(" -> ");
                        this.addLeftParen(((AST.VarDecl)decl).val.getOrigin());
                        this.addExprToTLA(this.AddSubscriptsToExpr(((AST.VarDecl)decl).val, expr, new Changed(new Vector())));
                        this.addRightParen(((AST.VarDecl)decl).val.getOrigin());
                        this.addOneTokenToTLA("]");
                    }
                    this.addRightParen(decl.getOrigin());
                    this.endCurrentLineOfTLA();
                    is = new StringBuffer(PcalTLAGen.NSpaces(col));
                }
            }
        }
        if (procs != null && procs.size() > 0) {
            if (this.mp) {
                is.append("/\\ stack = [self \\in ProcSet |-> << >>]");
            } else {
                is.append("/\\ stack = << >>");
            }
            this.addOneLineOfTLA(is.toString());
            is = new StringBuffer(PcalTLAGen.NSpaces(col));
        }
        if (!ParseAlgorithm.omitPC) {
            if (this.mp) {
                boolean useCase;
                boolean bl = useCase = this.st.processes.size() != 1;
                if (useCase) {
                    is.append("/\\ pc = [self \\in ProcSet |-> CASE ");
                } else {
                    is.append("/\\ pc = [self \\in ProcSet |-> ");
                }
                int colPC = is.length();
                colPC -= 3;
                for (p = 0; p < this.st.processes.size(); ++p) {
                    PcalSymTab.ProcessEntry pe = (PcalSymTab.ProcessEntry)this.st.processes.elementAt(p);
                    if (useCase) {
                        is.append("self ");
                        if (pe.isEq) {
                            is.append("= ");
                            this.addOneTokenToTLA(is.toString());
                            this.addLeftParen(pe.id.getOrigin());
                            this.addExprToTLA(pe.id);
                            this.addRightParen(pe.id.getOrigin());
                        } else {
                            is.append("\\in ");
                            this.addOneTokenToTLA(is.toString());
                            this.addLeftParen(pe.id.getOrigin());
                            this.addExprToTLA(pe.id);
                            this.addRightParen(pe.id.getOrigin());
                        }
                        is = new StringBuffer(" -> \"");
                        is.append(pe.iPC);
                        if (p == this.st.processes.size() - 1) {
                            is.append("\"]");
                        } else {
                            is.append("\"");
                        }
                    } else {
                        is.append("\"" + pe.iPC + "\"]");
                    }
                    this.addOneTokenToTLA(is.toString());
                    this.endCurrentLineOfTLA();
                    is = new StringBuffer(PcalTLAGen.NSpaces(colPC));
                    if (p >= this.st.processes.size() - 1) continue;
                    is.append("[] ");
                }
            } else {
                is.append("/\\ pc = \"" + this.st.iPC + "\"");
                this.addOneLineOfTLA(is.toString());
            }
        }
        this.addOneLineOfTLA("");
    }

    private void GenNext() {
        int i;
        int col;
        if (ParseAlgorithm.omitPC && !this.mp) {
            return;
        }
        Vector<String> nextS = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int max = wrapColumn - "Next == \\/ ".length();
        for (int i2 = 0; i2 < this.nextStep.size(); ++i2) {
            String a = (String)this.nextStep.elementAt(i2);
            if (a.length() + " \\/ ".length() + sb.length() > max) {
                nextS.addElement(sb.toString());
                sb = new StringBuffer();
            }
            if (sb.length() > 0) {
                sb.append(" \\/ ");
            }
            sb.append(a);
        }
        if (sb.length() > 0) {
            nextS.addElement(sb.toString());
        }
        Vector<String> nextSS = new Vector<String>();
        String nextSSstart = "(\\E self \\in ProcSet: ";
        sb = new StringBuffer();
        max = wrapColumn - "Next == \\/ (\\E self \\in ProcSet: \\/ ".length();
        if (this.mp && this.st.procs.size() > 0) {
            for (int i3 = 0; i3 < this.st.procs.size(); ++i3) {
                PcalSymTab.ProcedureEntry p = (PcalSymTab.ProcedureEntry)this.st.procs.elementAt(i3);
                if (p.name.length() + "(self) \\/ ".length() + sb.length() > max) {
                    nextSS.addElement(sb.toString());
                    sb = new StringBuffer();
                }
                if (sb.length() > 0) {
                    sb.append(" \\/ ");
                }
                sb.append(p.name);
                sb.append("(self)");
            }
            if (sb.length() > 0) {
                nextSS.addElement(sb.toString() + ")");
            }
        }
        Vector nextSSP = new Vector();
        if (this.mp && this.st.processes.size() > 0) {
            for (int i4 = 0; i4 < this.st.processes.size(); ++i4) {
                PcalSymTab.ProcessEntry p = (PcalSymTab.ProcessEntry)this.st.processes.elementAt(i4);
                if (p.isEq) continue;
                Vector<String> vec = new Vector<String>();
                sb = new StringBuffer();
                sb.append("(\\E self \\in ");
                Vector sv = p.id.toStringVector();
                col = sb.length();
                sb.append((String)sv.elementAt(0));
                for (int j = 1; j < sv.size(); ++j) {
                    vec.addElement(sb.toString());
                    sb = new StringBuffer(PcalTLAGen.NSpaces(col));
                    sb.append((String)sv.elementAt(j));
                }
                sb.append(": ");
                sb.append(p.name);
                sb.append("(self))");
                vec.addElement(sb.toString());
                nextSSP.addElement(vec);
            }
        }
        sb = new StringBuffer("Next == ");
        col = sb.length() + 2;
        for (i = 0; i < nextS.size(); ++i) {
            sb.append((String)nextS.elementAt(i));
            this.addOneLineOfTLA(sb.toString());
            sb = new StringBuffer(PcalTLAGen.NSpaces(col) + " \\/ ");
        }
        if (nextSS.size() > 0) {
            sb.append(nextSSstart);
            int col2 = sb.length();
            if (nextSS.size() > 1) {
                sb.append(" \\/ ");
            }
            for (int i5 = 0; i5 < nextSS.size(); ++i5) {
                sb.append((String)nextSS.elementAt(i5));
                this.addOneLineOfTLA(sb.toString());
                sb = new StringBuffer(PcalTLAGen.NSpaces(col2) + " \\/ ");
            }
            sb = new StringBuffer(PcalTLAGen.NSpaces(col) + " \\/ ");
        }
        if (nextSSP.size() > 0) {
            for (i = 0; i < nextSSP.size(); ++i) {
                Vector v = (Vector)nextSSP.elementAt(i);
                for (int j = 0; j < v.size(); ++j) {
                    String line = (String)v.elementAt(j);
                    sb.append(line);
                    this.addOneLineOfTLA(sb.toString());
                    sb = nextS.size() == 0 && nextSS.size() == 0 && i == 0 ? new StringBuffer(PcalTLAGen.NSpaces(col - 2)) : new StringBuffer(PcalTLAGen.NSpaces(col + 4));
                }
                sb = new StringBuffer(PcalTLAGen.NSpaces(col) + " \\/ ");
            }
        }
        if (!PcalParams.NoDoneDisjunct && !ParseAlgorithm.omitStutteringWhenDone) {
            sb.append("(* Disjunct to prevent deadlock on termination *)");
            this.addOneLineOfTLA(sb.toString());
            sb = new StringBuffer(PcalTLAGen.NSpaces(col + 4));
            if (this.mp) {
                sb.append("((\\A self \\in ProcSet: pc[self] = \"Done\") /\\ UNCHANGED vars)");
            } else {
                sb.append("(pc = \"Done\" /\\ UNCHANGED vars)");
            }
            this.addOneLineOfTLA(sb.toString());
        }
        this.addOneLineOfTLA("");
    }

    private void GenSpec() {
        String safetyFormula = "Init /\\ [][Next]_vars";
        if (PcalParams.FairnessOption.equals("nof") || !this.mp && PcalParams.FairnessOption.equals("")) {
            this.addOneLineOfTLA("Spec == " + safetyFormula);
            this.addOneLineOfTLA("");
            return;
        }
        StringBuffer sb = new StringBuffer("Spec == ");
        String wfNextConj = null;
        if (PcalParams.FairnessOption.equals("wfNext") || PcalParams.FairAlgorithm || !this.mp && (PcalParams.FairnessOption.equals("wf") || PcalParams.FairnessOption.equals("sf"))) {
            wfNextConj = " /\\ WF_vars(Next)";
        }
        Vector<ProcessFairness> procFairnessFormulas = new Vector<ProcessFairness>();
        if (this.mp) {
            for (int i = 0; i < this.st.processes.size(); ++i) {
                PcalSymTab.ProcessEntry p = (PcalSymTab.ProcessEntry)this.st.processes.elementAt(i);
                AST.Process pAst = p.ast;
                int fairness = pAst.fairness;
                if (fairness == 0) continue;
                String xf = fairness == 1 ? "WF" : "SF";
                Vector pSelf = p.id.toStringVector();
                boolean makeLetIn = false;
                String qSelf = "self";
                if (p.isEq) {
                    if (pSelf.size() > 1) {
                        makeLetIn = true;
                    } else {
                        qSelf = (String)pSelf.elementAt(0);
                    }
                }
                Vector<String> prefix = new Vector<String>();
                if (makeLetIn || !p.isEq) {
                    String prefixEnd;
                    String prefixBegin;
                    int prefixSize = pSelf.size();
                    if (p.isEq) {
                        prefixBegin = "LET self == ";
                        prefixEnd = "";
                    } else {
                        prefixBegin = "\\A self \\in ";
                        prefixEnd = " : ";
                    }
                    String padding = PcalTLAGen.NSpaces(prefixBegin.length());
                    for (int j = 0; j < prefixSize; ++j) {
                        String line = (String)pSelf.elementAt(j);
                        line = j == 0 ? prefixBegin + line : padding + line;
                        if (j == prefixSize - 1) {
                            line = line + prefixEnd;
                        }
                        prefix.addElement(line);
                    }
                    if (makeLetIn) {
                        prefix.addElement("IN ");
                    }
                }
                StringBuffer wfSB = new StringBuffer(xf + "_vars(");
                if (pAst.minusLabels != null && pAst.minusLabels.size() > 0) {
                    wfSB.append("(pc[");
                    wfSB.append(qSelf);
                    if (pAst.minusLabels.size() == 1) {
                        wfSB.append("] # \"");
                        wfSB.append(pAst.minusLabels.elementAt(0));
                        wfSB.append("\"");
                    } else {
                        wfSB.append("] \\notin {\"");
                        for (int j = 0; j < pAst.minusLabels.size(); ++j) {
                            wfSB.append(pAst.minusLabels.elementAt(j));
                            if (j == pAst.minusLabels.size() - 1) {
                                wfSB.append("\"}");
                                continue;
                            }
                            wfSB.append("\", \"");
                        }
                    }
                    wfSB.append(") /\\ ");
                }
                String pName = p.name;
                if (!p.isEq) {
                    pName = p.name + "(self)";
                }
                wfSB.append(pName);
                wfSB.append(")");
                StringBuffer sfSB = null;
                if (xf.equals("WF") && pAst.plusLabels != null && pAst.plusLabels.size() != 0) {
                    sfSB = new StringBuffer();
                    for (int j = 0; j < pAst.plusLabels.size(); ++j) {
                        if (j != 0) {
                            sfSB.append(" /\\ ");
                        }
                        sfSB.append("SF_vars(");
                        sfSB.append(pAst.plusLabels.elementAt(j));
                        if (!p.isEq) {
                            sfSB.append("(self)");
                        }
                        sfSB.append(")");
                    }
                }
                Vector<FormulaPair> prcdFormulas = new Vector<FormulaPair>();
                Vector procedures = pAst.proceduresCalled;
                for (int k = 0; k < procedures.size(); ++k) {
                    String originalName = (String)procedures.elementAt(k);
                    String name = this.st.UseThis(2, originalName, "");
                    int procedureIndex = this.st.FindProc(name);
                    PcalSymTab.ProcedureEntry pe = (PcalSymTab.ProcedureEntry)this.st.procs.elementAt(procedureIndex);
                    AST.Procedure prcAst = pe.ast;
                    StringBuffer wfPrcSB = new StringBuffer(xf + "_vars(");
                    if (prcAst.minusLabels != null && prcAst.minusLabels.size() > 0) {
                        wfPrcSB.append("(pc[");
                        wfPrcSB.append(qSelf);
                        if (prcAst.minusLabels.size() == 1) {
                            wfPrcSB.append("] # \"");
                            wfPrcSB.append(prcAst.minusLabels.elementAt(0));
                            wfPrcSB.append("\"");
                        } else {
                            wfPrcSB.append("] \\notin {\"");
                            for (int j = 0; j < prcAst.minusLabels.size(); ++j) {
                                wfPrcSB.append(prcAst.minusLabels.elementAt(j));
                                if (j == prcAst.minusLabels.size() - 1) {
                                    wfPrcSB.append("\"}");
                                    continue;
                                }
                                wfPrcSB.append("\", \"");
                            }
                        }
                        wfPrcSB.append(") /\\ ");
                    }
                    String prcName = pe.name + "(" + qSelf + ")";
                    wfPrcSB.append(prcName);
                    wfPrcSB.append(")");
                    StringBuffer sfPrcSB = null;
                    if (xf.equals("WF") && prcAst.plusLabels != null && prcAst.plusLabels.size() != 0) {
                        sfPrcSB = new StringBuffer();
                        for (int j = 0; j < prcAst.plusLabels.size(); ++j) {
                            if (j != 0) {
                                sfPrcSB.append(" /\\ ");
                            }
                            sfPrcSB.append("SF_vars(");
                            sfPrcSB.append(prcAst.plusLabels.elementAt(j));
                            sfPrcSB.append("(" + qSelf + ")");
                            sfPrcSB.append(")");
                        }
                    }
                    prcdFormulas.addElement(new FormulaPair(wfPrcSB.toString(), sfPrcSB == null ? null : sfPrcSB.toString()));
                }
                procFairnessFormulas.addElement(new ProcessFairness(xf, prefix, wfSB.toString(), sfSB == null ? null : sfSB.toString(), prcdFormulas));
            }
        }
        if (wfNextConj == null && procFairnessFormulas.size() == 0) {
            this.addOneLineOfTLA("Spec == " + safetyFormula);
            this.addOneLineOfTLA("");
            return;
        }
        this.addOneLineOfTLA("Spec == /\\ " + safetyFormula);
        int indent = "Spec == /\\ ".length();
        if (wfNextConj != null) {
            this.addOneLineOfTLA("        /\\ WF_vars(Next)");
        }
        for (int i = 0; i < procFairnessFormulas.size(); ++i) {
            String str = "        /\\ " + ((ProcessFairness)procFairnessFormulas.elementAt(i)).format(indent).toString();
            String[] splitStr = str.split("\n");
            for (int j = 0; j < splitStr.length; ++j) {
                this.addOneLineOfTLA(splitStr[j]);
            }
        }
        this.addOneLineOfTLA("");
    }

    private void GenTermination() {
        if (ParseAlgorithm.omitPC || ParseAlgorithm.omitStutteringWhenDone) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Termination == <>(");
        if (this.mp) {
            sb.append("\\A self \\in ProcSet: pc[self]");
        } else {
            sb.append("pc");
        }
        sb.append(" = \"Done\")");
        this.addOneLineOfTLA(sb.toString());
        this.addOneLineOfTLA("");
    }

    private TLAExpr AddSubscriptsToExpr(TLAExpr exprn, TLAExpr sub, Changed c) throws PcalTLAGenException {
        TLAToken tok;
        int j;
        int i;
        int parenDepth = 0;
        for (int i2 = 0; i2 < exprn.tokens.size(); ++i2) {
            Vector line = (Vector)exprn.tokens.elementAt(i2);
            for (int j2 = 0; j2 < line.size(); ++j2) {
                TLAToken tok2 = (TLAToken)line.elementAt(j2);
                if ((parenDepth = parenDepth + tok2.getBeginSubst().size() - tok2.getEndSubst().size()) >= 0) continue;
                throw new NullPointerException("argument: begin/end Subst depth negative");
            }
        }
        if (parenDepth != 0) {
            throw new NullPointerException("argument: Unmatched begin Subst");
        }
        Vector<TLAExpr> exprVec = new Vector<TLAExpr>();
        Vector<String> stringVec = new Vector<String>();
        TLAExpr expr = exprn.cloneAndNormalize();
        for (i = 0; i < expr.tokens.size(); ++i) {
            Vector tv = (Vector)expr.tokens.elementAt(i);
            for (j = 0; j < tv.size(); ++j) {
                boolean subr;
                tok = (TLAToken)tv.elementAt(j);
                boolean prime = tok.type == 4 && c.IsChanged(tok.string);
                boolean bl = subr = sub != null && (tok.type == 5 || this.mp && tok.type == 4 && (this.IsProcedureVar(tok.string) || this.IsProcessSetVar(tok.string)));
                if (!subr && !prime || PcalTLAGen.InVector(tok.string, stringVec)) continue;
                stringVec.addElement(tok.string);
                TLAExpr exp = new TLAExpr();
                exp.addLine();
                TLAToken newTok = tok.Clone();
                newTok.setBeginSubst(new Vector(2));
                newTok.setEndSubst(new Vector(2));
                newTok.source = null;
                newTok.column = 0;
                exp.addToken(newTok);
                if (prime) {
                    TLAToken primeTok = new TLAToken("'", 0, 1, true);
                    exp.addTokenOffset(primeTok, 0);
                }
                if (subr) {
                    TLAExpr subexp = sub.cloneAndNormalize();
                    exp.normalize();
                    try {
                        subexp.prepend(exp, 0);
                    }
                    catch (TLAExprException e) {
                        throw new PcalTLAGenException(e.getMessage());
                    }
                    exp = subexp;
                }
                exprVec.addElement(exp);
            }
        }
        if (exprVec.size() > 0) {
            try {
                expr.substituteForAll(exprVec, stringVec, false);
            }
            catch (TLAExprException e) {
                throw new PcalTLAGenException(e.getMessage());
            }
        }
        parenDepth = 0;
        for (i = 0; i < expr.tokens.size(); ++i) {
            Vector line = (Vector)expr.tokens.elementAt(i);
            for (j = 0; j < line.size(); ++j) {
                tok = (TLAToken)line.elementAt(j);
                if ((parenDepth = parenDepth + tok.getBeginSubst().size() - tok.getEndSubst().size()) >= 0) continue;
                throw new NullPointerException("result: begin/end Subst depth negative");
            }
        }
        if (parenDepth != 0) {
            throw new NullPointerException("result: Unmatched begin/subst");
        }
        return expr;
    }

    private static TLAExpr SubExpr(TLAExpr sub) {
        if (sub != null) {
            TLAExpr expr = sub.cloneAndNormalize();
            for (int i = 0; i < expr.tokens.size(); ++i) {
                Vector tokenVec = (Vector)expr.tokens.elementAt(i);
                for (int j = 0; j < tokenVec.size(); ++j) {
                    TLAToken tok = (TLAToken)tokenVec.elementAt(j);
                    ++tok.column;
                }
                if (i != 0) continue;
                tokenVec.insertElementAt(new TLAToken("[", 0, 1, sub.firstToken().isAppended()), 0);
            }
            expr.addTokenOffset(new TLAToken("]", 0, 1, sub.firstToken().isAppended()), 0);
            return expr;
        }
        return null;
    }

    private TLAExpr Self(String context) {
        TLAExpr s = null;
        if (this.mp) {
            s = context.equals("procedure") ? PcalTLAGen.selfAsExpr() : this.self;
        }
        return s;
    }

    private static TLAExpr selfAsExpr() {
        TLAToken selfToken = new TLAToken("self", 0, 4, true);
        Vector<TLAToken> tokenVec = new Vector<TLAToken>();
        tokenVec.addElement(selfToken);
        Vector<Vector<TLAToken>> tokens = new Vector<Vector<TLAToken>>();
        tokens.addElement(tokenVec);
        TLAExpr expr = new TLAExpr(tokens);
        expr.normalize();
        return expr;
    }

    public static void ObsoleteMakeExprPretty(TLAExpr expr) {
        int nextCol = 1;
        for (int i = 0; i < expr.tokens.size(); ++i) {
            Vector line = (Vector)expr.tokens.elementAt(i);
            for (int j = 0; j < line.size(); ++j) {
                TLAToken tok = (TLAToken)line.elementAt(j);
                boolean spread = tok.string.equals("=");
                tok.column = nextCol + (spread ? 1 : 0);
                nextCol = nextCol + tok.getWidth() + (spread ? 2 : 0);
            }
        }
    }

    private static Vector SortSass(Vector vec) {
        Vector v = (Vector)vec.clone();
        Vector<AST.SingleAssign> r = new Vector<AST.SingleAssign>();
        while (v.size() > 0) {
            AST.SingleAssign candidate = (AST.SingleAssign)v.elementAt(0);
            int indexC = 0;
            for (int i = 1; i < v.size(); ++i) {
                AST.SingleAssign sass = (AST.SingleAssign)v.elementAt(i);
                if (candidate.lhs.var.compareTo(sass.lhs.var) <= 0) continue;
                indexC = i;
                candidate = sass;
            }
            r.addElement(candidate);
            v.remove(indexC);
        }
        return r;
    }

    private static Vector Parenthesize(Vector vec) {
        if (PcalTLAGen.NeedsParentheses(vec)) {
            vec.setElementAt("(" + (String)vec.elementAt(0), 0);
            for (int i = 1; i < vec.size(); ++i) {
                vec.setElementAt(" " + (String)vec.elementAt(i), i);
            }
            int curLineNum = vec.size() - 1;
            vec.setElementAt((String)vec.elementAt(curLineNum) + ")", curLineNum);
        }
        return vec;
    }

    public static boolean NeedsParentheses(Vector vec) {
        if (vec.size() == 0) {
            return false;
        }
        int curCharNum = 0;
        int parenDepth = 0;
        boolean inString = false;
        boolean needParen = false;
        for (int curLineNum = 0; curLineNum < vec.size() && !needParen; ++curLineNum) {
            String curLine = (String)vec.elementAt(0);
            while (curCharNum < curLine.length() && !needParen) {
                char curChar = curLine.charAt(curCharNum);
                if (inString) {
                    switch (curChar) {
                        case '\"': {
                            inString = false;
                            break;
                        }
                        case '\\': {
                            ++curCharNum;
                        }
                    }
                } else {
                    boolean leftParen = false;
                    boolean rightParen = false;
                    boolean mayNeedParen = false;
                    int nextChar = 32;
                    if (curCharNum < curLine.length() - 1) {
                        nextChar = curLine.charAt(curCharNum + 1);
                    }
                    switch (curChar) {
                        case '\"': {
                            inString = true;
                            break;
                        }
                        case '=': {
                            mayNeedParen = true;
                            break;
                        }
                        case '#': {
                            mayNeedParen = true;
                            break;
                        }
                        case '<': {
                            if (nextChar == 60) {
                                ++curCharNum;
                                leftParen = true;
                                break;
                            }
                            mayNeedParen = true;
                            break;
                        }
                        case '>': {
                            if (nextChar == 62) {
                                ++curCharNum;
                                rightParen = true;
                                break;
                            }
                            mayNeedParen = true;
                            break;
                        }
                        case '|': {
                            if (nextChar != 45 && (curCharNum <= 0 || curLine.charAt(curCharNum - 1) != '-')) break;
                            mayNeedParen = true;
                            break;
                        }
                        case '\\': {
                            if (nextChar == 32 || nextChar == 111 || nextChar == 88) break;
                            mayNeedParen = true;
                            break;
                        }
                        case '/': {
                            if (nextChar != 92) break;
                            mayNeedParen = true;
                            break;
                        }
                        case '(': 
                        case '[': 
                        case '{': {
                            leftParen = true;
                            break;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            rightParen = true;
                        }
                    }
                    if (mayNeedParen && parenDepth == 0) {
                        needParen = true;
                    }
                    if (leftParen) {
                        ++parenDepth;
                    }
                    if (rightParen) {
                        if (parenDepth == 0) {
                            needParen = true;
                        }
                        --parenDepth;
                    }
                }
                ++curCharNum;
            }
            if (inString) {
                needParen = true;
            }
            curCharNum = 0;
        }
        return needParen;
    }

    private void addOneTokenToTLA(String token) {
        int numberOfLeftTrimmedTokens;
        String trimmedToken = token.trim();
        int n = numberOfLeftTrimmedTokens = trimmedToken.length() == 0 ? -1 : token.indexOf(trimmedToken.charAt(0));
        if (numberOfLeftTrimmedTokens == -1) {
            numberOfLeftTrimmedTokens = 0;
            trimmedToken = token;
        }
        int objBegin = this.tlacodeNextLine.length() + numberOfLeftTrimmedTokens;
        this.mappingVectorNextLine.addElement(new MappingObject.BeginTLAToken(objBegin));
        this.mappingVectorNextLine.addElement(new MappingObject.EndTLAToken(objBegin + trimmedToken.length()));
        this.tlacodeNextLine = this.tlacodeNextLine + token;
    }

    private void addOneSourceTokenToTLA(String str, Region region) {
        if (region == null) {
            this.addOneTokenToTLA(str);
            return;
        }
        int beginCol = this.tlacodeNextLine.length();
        int endCol = beginCol + str.length();
        this.mappingVectorNextLine.addElement(new MappingObject.SourceToken(beginCol, endCol, region));
        this.tlacodeNextLine = this.tlacodeNextLine + str;
    }

    private void addOneLineOfTLA(String line) {
        if (this.tlacode.size() != this.mappingVector.size()) {
            PcalDebug.ReportBug("tlacode and mappingVector have different lengths");
        }
        this.endCurrentLineOfTLA();
        if (line.length() == 0) {
            this.mappingVector.addElement(new Vector(2));
            this.tlacode.addElement("");
            return;
        }
        this.addOneTokenToTLA(line);
        this.endCurrentLineOfTLA();
    }

    private void endCurrentLineOfTLA() {
        if (this.tlacodeNextLine.length() != 0) {
            this.tlacode.addElement(this.tlacodeNextLine);
            this.mappingVector.addElement(this.mappingVectorNextLine);
            this.tlacodeNextLine = "";
            this.mappingVectorNextLine = new Vector();
        } else if (this.mappingVectorNextLine.size() != 0) {
            Vector lastLine = (Vector)this.mappingVector.elementAt(this.mappingVector.size() - 1);
            for (int i = 0; i < this.mappingVectorNextLine.size(); ++i) {
                MappingObject obj = (MappingObject)this.mappingVectorNextLine.elementAt(i);
                if (obj.getType() == 1 || obj.getType() == 0 || obj.getType() == 5) {
                    lastLine.add(obj);
                } else {
                    PcalDebug.ReportBug("PcalTLAGen.endCurrentLineOfTLA found problem.");
                }
                this.mappingVectorNextLine = new Vector();
            }
        }
    }

    private void addExprToTLA(TLAExpr expr) {
        Vector sv = expr.toStringVector();
        Vector exprMapping = expr.toMappingVector();
        int indent = this.tlacodeNextLine.length();
        int nextLine = 0;
        if (indent != 0) {
            MappingObject.shiftMappingVector(exprMapping, indent);
            this.tlacodeNextLine = this.tlacodeNextLine + (String)sv.elementAt(0);
            this.mappingVectorNextLine.addAll((Vector)exprMapping.elementAt(0));
            nextLine = 1;
            if (sv.size() > 1) {
                this.endCurrentLineOfTLA();
            }
        }
        if (sv.size() > 1) {
            String spaces = PcalTLAGen.NSpaces(indent);
            while (nextLine < sv.size() - 1) {
                this.tlacode.addElement(spaces + (String)sv.elementAt(nextLine));
                this.mappingVector.addElement((Vector)exprMapping.elementAt(nextLine));
                ++nextLine;
            }
            this.tlacodeNextLine = spaces + (String)sv.elementAt(nextLine);
            this.mappingVectorNextLine = (Vector)exprMapping.elementAt(nextLine);
        } else if (indent == 0) {
            this.tlacodeNextLine = this.tlacodeNextLine + (String)sv.elementAt(0);
            this.mappingVectorNextLine.addAll((Vector)exprMapping.elementAt(0));
        }
    }

    private void addVarDeclToTLA(AST.VarDecl decl, StringBuffer is) {
        Region origin = decl.getOrigin();
        is.append("/\\ ");
        this.addOneTokenToTLA(is.toString());
        this.addLeftParen(decl.getOrigin());
        is = new StringBuffer(decl.var);
        if (decl.isEq) {
            is.append(" = ");
        } else {
            is.append(" \\in ");
        }
        this.addOneTokenToTLA(is.toString());
        this.addLeftParen(decl.val.getOrigin());
        boolean needsParens = PcalTLAGen.NeedsParentheses(decl.val.toStringVector());
        if (needsParens) {
            this.addOneTokenToTLA("(");
        }
        this.addExprToTLA(decl.val);
        if (needsParens) {
            this.addOneTokenToTLA(")");
        }
        this.addRightParen(decl.val.getOrigin());
        this.addRightParen(decl.getOrigin());
        this.endCurrentLineOfTLA();
    }

    private void addLeftParen(Region region) {
        if (region != null) {
            this.mappingVectorNextLine.addElement(new MappingObject.LeftParen(region.getBegin()));
        }
    }

    private void addRightParen(Region region) {
        if (region != null) {
            this.mappingVectorNextLine.addElement(new MappingObject.RightParen(region.getEnd()));
        }
    }

    private void addLeftParenV(AST ast, PCalLocation loc) {
        if (ast.getOrigin() == null) {
            return;
        }
        if (loc != null) {
            this.mappingVectorNextLine.addElement(new MappingObject.LeftParen(loc));
        } else {
            this.addLeftParen(ast.getOrigin());
        }
    }

    private void addRightParenV(AST ast, PCalLocation loc) {
        if (ast.getOrigin() == null) {
            return;
        }
        if (loc != null) {
            this.mappingVectorNextLine.addElement(new MappingObject.RightParen(loc));
        } else {
            this.addRightParen(ast.getOrigin());
        }
    }

    public static class ProcessFairness {
        public String xf;
        public Vector prefix;
        public FormulaPair bodyFormulas;
        public Vector prcdFormulas;

        public ProcessFairness(String xfVal, Vector prefixVal, String bodyWF, String bodySF, Vector prcdVal) {
            this.xf = xfVal;
            this.prefix = prefixVal;
            this.bodyFormulas = null;
            if (bodyWF != null) {
                this.bodyFormulas = new FormulaPair(bodyWF, bodySF);
            }
            this.prcdFormulas = prcdVal;
        }

        public int singleLineWidth() {
            int i;
            int maxPrefixWidth = 0;
            int width = 0;
            if (this.prefix != null && this.prefix.size() > 0) {
                for (i = 0; i < this.prefix.size() - 1; ++i) {
                    String line = (String)this.prefix.elementAt(i);
                    if (line.length() > maxPrefixWidth) {
                        maxPrefixWidth = line.length();
                    }
                    String lastLine = (String)this.prefix.elementAt(this.prefix.size() - 1);
                    width = lastLine.length();
                }
            }
            width += this.bodyFormulas.wf.length();
            if (this.bodyFormulas.sf != null) {
                width += this.bodyFormulas.sf.length();
            }
            if (this.prcdFormulas != null) {
                for (i = 0; i < this.prcdFormulas.size(); ++i) {
                    width += ((FormulaPair)this.prcdFormulas.elementAt(i)).singleLineWidth();
                }
            }
            if (maxPrefixWidth > width) {
                return maxPrefixWidth;
            }
            return width;
        }

        private StringBuffer prefixAsStringBuffer(int col) {
            StringBuffer val = new StringBuffer();
            if (this.prefix != null && this.prefix.size() > 0) {
                for (int i = 0; i < this.prefix.size(); ++i) {
                    String line = (String)this.prefix.elementAt(i);
                    if (i != 0) {
                        val.append(PcalTLAGen.NSpaces(col));
                    }
                    val.append(line);
                    if (i == this.prefix.size() - 1) continue;
                    val.append("\n");
                }
            }
            return val;
        }

        public StringBuffer singleLine(int col) {
            StringBuffer val = this.prefixAsStringBuffer(col);
            val.append(this.bodyFormulas.wf);
            if (this.bodyFormulas.sf != null) {
                val.append(" /\\ ");
                val.append(this.bodyFormulas.sf);
            }
            if (this.prcdFormulas != null) {
                for (int i = 0; i < this.prcdFormulas.size(); ++i) {
                    val.append(" /\\ ");
                    val.append(((FormulaPair)this.prcdFormulas.elementAt(i)).singleLine());
                }
            }
            return val;
        }

        private boolean fitsAsSingleLine(int col) {
            return col + this.singleLineWidth() <= wrapColumn || this.bodyFormulas.sf == null && (this.prcdFormulas == null || this.prcdFormulas.size() == 0);
        }

        public StringBuffer format(int col) {
            String line;
            int curCol;
            int singleLineWidth = this.singleLineWidth();
            if (this.fitsAsSingleLine(col)) {
                return this.singleLine(col);
            }
            StringBuffer val = this.prefixAsStringBuffer(col);
            int prefixWidth = 0;
            if (this.prefix != null && this.prefix.size() > 0) {
                prefixWidth = ((String)this.prefix.elementAt(this.prefix.size() - 1)).length();
            }
            if ((curCol = col + prefixWidth) + (line = this.bodyFormulas.singleLine()).length() + 3 <= wrapColumn) {
                val.append("/\\ " + line);
            } else {
                val.append(this.bodyFormulas.multiLine(curCol));
            }
            if (this.prcdFormulas == null) {
                return val;
            }
            for (int i = 0; i < this.prcdFormulas.size(); ++i) {
                FormulaPair form = (FormulaPair)this.prcdFormulas.elementAt(i);
                line = form.singleLine();
                if (i == 0) {
                    val.append("\n");
                }
                val.append(PcalTLAGen.NSpaces(curCol));
                if (curCol + line.length() + 3 <= wrapColumn) {
                    val.append("/\\ " + line + "\n");
                    continue;
                }
                val.append(form.multiLine(curCol));
            }
            return val;
        }
    }

    public static class FormulaPair {
        public String wf;
        public String sf;

        public FormulaPair(String wfVal, String sfVal) {
            this.wf = wfVal;
            this.sf = sfVal;
        }

        public String singleLine() {
            if (this.sf == null) {
                return this.wf;
            }
            return this.wf + " /\\ " + this.sf;
        }

        public int singleLineWidth() {
            if (this.sf == null) {
                return this.wf.length();
            }
            return this.wf.length() + " /\\ ".length() + this.sf.length();
        }

        public String multiLine(int col) {
            String val = "/\\ " + this.wf;
            if (this.sf == null) {
                return val;
            }
            return val + "\n" + PcalTLAGen.NSpaces(col) + "/\\ " + this.sf;
        }
    }
}

