/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.simulation.ui;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.stage.FileChooser;
import obp2.core.fx.IAppContext;
import obp2.core.registry.LanguageModuleRegistry;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.ui2.model_view.ModelEditor;
import obp2.ui2.simulation.SimulationView;
import plug.utils.file.FileWatcher;

public class SimulationMainView<C, A, O>
extends SplitPane {
    ObjectProperty<Path> modelPath = new SimpleObjectProperty();
    BooleanProperty modelChanged = new SimpleBooleanProperty(false);
    FileWatcher watcher;
    ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty = new SimpleObjectProperty();
    ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty = new SimpleObjectProperty();
    ObjectProperty<Set<C>> initialSetProperty = new SimpleObjectProperty();

    public SimulationMainView(IAppContext appContext) {
        this.watcher = appContext.getFileWatcher();
        this.modelPath.addListener(this::modelChangedCallback);
        ModelEditor modelUnderVerificationView = new ModelEditor("Model", this.modelPath, this.modelChanged, this.modelExtensionFilters());
        this.modelChanged.addListener((a, o, n) -> this.updateSimulationView());
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.5);
        this.getItems().addAll((Object[])new Node[]{modelUnderVerificationView, this.createSimulationView()});
    }

    SimulationView<C, A, O> createSimulationView() {
        return new SimulationView<C, A, O>(this.transitionRelationProperty, this.runtimeViewProperty, this.initialSetProperty);
    }

    public void updateSimulationView() {
        if (this.modelPath.get() == null) {
            this.transitionRelationProperty.set(null);
            this.runtimeViewProperty.set(null);
            this.initialSetProperty.set(null);
            return;
        }
        try {
            ILanguageModule languageModule = (ILanguageModule)LanguageModuleRegistry.getLanguageModuleSupplier((Path)((Path)this.modelPath.get())).get();
            ITransitionRelation transitionRelation = languageModule.getTransitionRelation();
            this.transitionRelationProperty.set((Object)transitionRelation);
            if (transitionRelation == null) {
                return;
            }
            this.runtimeViewProperty.set((Object)languageModule.getTreeProjector());
            this.initialSetProperty.set((Object)transitionRelation.initialConfigurations());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.getItems().remove(1);
        this.getItems().add(this.createSimulationView());
    }

    public void modelChangedCallback(ObservableValue<? extends Path> obj, Path oldP, Path newP) {
        this.watcher.removePathListener(oldP);
        this.watcher.addOnContentChange(newP, c -> Platform.runLater(() -> this.modelChanged.set(!this.modelChanged.get())));
        this.modelChanged.set(!this.modelChanged.get());
    }

    public Collection<FileChooser.ExtensionFilter> modelExtensionFilters() {
        ArrayList<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        for (ILanguagePlugin languageModule : LanguageModuleRegistry.getInstance().getModules()) {
            if (languageModule.getName().equals("Buchi")) continue;
            List extensions = Stream.of(languageModule.getExtensions()).map(e -> "*" + e).collect(Collectors.toList());
            extensionFilters.add(new FileChooser.ExtensionFilter(languageModule.getName(), extensions));
        }
        return extensionFilters;
    }
}

