/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.language.buchikripke.runtime.KRIPKE2TBA_TBA_ProductSemantics;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiRuntimeView;
import obp2.language.buchikripke.runtime.SE_KRIPKE_TBA_ProductSemantics;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.LanguageModule;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.interpreter.EvaluatorSpaghetti;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class KripkeBuchiLanguageModule
extends LanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    public ILanguageModule kripke;
    public ILanguageModule buchi;
    public final EvaluatorSpaghetti buchiEvaluator = new EvaluatorSpaghetti();
    public final AtomArrayValuationEvaluator apValuationEvaluator;

    public KripkeBuchiLanguageModule(ILanguageModule kripke, ILanguageModule buchi, Semantics semantics) throws Exception {
        this.kripke = kripke;
        this.buchi = buchi;
        switch (semantics) {
            case KRIPKE2TBA_TBA: {
                this.transitionRelation = new KRIPKE2TBA_TBA_ProductSemantics(this);
                break;
            }
            case SE_KRIPKE_TBA: {
                this.transitionRelation = new SE_KRIPKE_TBA_ProductSemantics(this);
            }
        }
        ArrayList<String> atoms = new ArrayList<String>();
        HashMap<String, Integer> atomMap = new HashMap<String, Integer>();
        int idx = 0;
        for (String atom : buchi.getAtomicPropositionsProvider().getAtomicPropositions()) {
            if (atom == null || atomMap.containsKey(atom)) continue;
            atomMap.put(atom, idx++);
            atoms.add(atom);
        }
        IAtomicPropositionsEvaluator kripkeEvaluator = kripke.getAtomicPropositionEvaluator();
        kripkeEvaluator.registerAtomicPropositions(atoms.toArray(new String[0]));
        this.apValuationEvaluator = new AtomArrayValuationEvaluator(atomMap);
        this.buchiEvaluator.setDefaultEvaluator((IAtomEvaluator)this.apValuationEvaluator);
        this.treeProjector = new KripkeBuchiRuntimeView(this);
    }

    public void close() throws Exception {
        this.kripke.close();
        this.buchi.close();
    }

    public static enum Semantics {
        KRIPKE2TBA_TBA,
        SE_KRIPKE_TBA;

    }
}

