/*
 * Decompiled with CFR 0.152.
 */
package obp2.statespace.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.statespace.ITransitionStorage;

public class ParentTransitionStorage<C extends IConfiguration, A, O>
implements ITransitionStorage<C, A, O> {
    Map<C, IFiredTransition<C, A, O>> parent = new HashMap<C, IFiredTransition<C, A, O>>();

    @Override
    public IFiredTransition put(IFiredTransition<C, A, O> transition) {
        IFiredTransition<C, A, O> v = null;
        for (IConfiguration target : transition.getTargets()) {
            v = this.parent.putIfAbsent(target, transition);
        }
        return v;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public C getParent(C configuration) {
        IFiredTransition<C, A, O> theParentTransition = this.parent.get(configuration);
        if (theParentTransition == null) {
            return null;
        }
        return (C)((IConfiguration)theParentTransition.getSource());
    }

    @Override
    public Collection<IFiredTransition<C, A, O>> getFiredFrom(C configuration) {
        ArrayList<IFiredTransition<C, A, O>> result = new ArrayList<IFiredTransition<C, A, O>>();
        for (Map.Entry<C, IFiredTransition<C, A, O>> entry : this.parent.entrySet()) {
            if (entry.getValue().getSource() != configuration) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    @Override
    public Collection<IFiredTransition<C, A, O>> getFiredTo(C configuration) {
        IFiredTransition<C, A, O> transition = this.parent.get(configuration);
        return transition != null ? Collections.singleton(transition) : Collections.emptyList();
    }

    @Override
    public int getEdgeCount() {
        return this.size();
    }
}

