/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.verifiers.deadlock;

import announce4j.Announcer;
import obp2.algorithms.reachability.BFSExplorer;
import obp2.algorithms.reachability.DFSExplorer;
import obp2.algorithms.verifiers.deadlock.FinalStateDetected;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.events.CloseConfigurationEvent;
import obp2.events.ExecutionEndedEvent;
import obp2.events.FiredEvent;
import obp2.events.OpenConfigurationEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ITransitionRelation;

public class DeadlockVerifier {
    public final Announcer announcer;
    protected boolean foundDeadlock = false;
    protected boolean currentConfigurationIsDeadlock = false;

    public DeadlockVerifier(Announcer announcer) {
        this.announcer = announcer;
        announcer.when(OpenConfigurationEvent.class, this::onOpenConfigurationEvent);
        announcer.when(CloseConfigurationEvent.class, this::onCloseConfigurationEvent);
        announcer.when(FiredEvent.class, this::onFiredEvent);
        announcer.when(ExecutionEndedEvent.class, this::onEnd);
    }

    protected void onOpenConfigurationEvent(Announcer ann, OpenConfigurationEvent<?> event) {
        this.currentConfigurationIsDeadlock = true;
    }

    protected void onFiredEvent(Announcer ann, FiredEvent<?, ?, ?> event) {
        this.currentConfigurationIsDeadlock = false;
    }

    protected void onCloseConfigurationEvent(Announcer ann, CloseConfigurationEvent<IConfiguration> event) {
        if (this.currentConfigurationIsDeadlock) {
            this.announcer.announce(new FinalStateDetected<IConfiguration>((IConfiguration)event.getConfiguration()));
            this.foundDeadlock = true;
        }
    }

    protected void onEnd(Announcer announcer, Object o) {
        if (!this.foundDeadlock) {
            announcer.announce((Object)new PropertyEvent(null, true, "deadlocks", null));
        }
    }

    public static <C extends IConfiguration, A, O> BFSExplorer<C, A> bfs(ITransitionRelation<C, A, O> relation, IStateSpaceManager<C, A, O> stateSpaceManager) {
        BFSExplorer<C, A> explorer = new BFSExplorer<C, A>(relation, stateSpaceManager);
        new DeadlockVerifier(explorer.getAnnouncer());
        return explorer;
    }

    public static <C extends IConfiguration, A, O> DFSExplorer<C, A> dfs(ITransitionRelation<C, A, O> relation, IStateSpaceManager<C, A, O> stateSpaceManager) {
        DFSExplorer<C, A> explorer = new DFSExplorer<C, A>((ITransitionRelation)relation, stateSpaceManager);
        new DeadlockVerifier(explorer.getAnnouncer());
        return explorer;
    }
}

