/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.partially_bounded;

import announce4j.Announcer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import obp2.algorithms.partially_bounded.IDepthChangeDetector;
import obp2.core.IFiredTransition;
import obp2.core.IProductAutomaton;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.CloseConfigurationEvent;
import obp2.events.ExecutionEndedEvent;
import obp2.events.ExecutionStartedEvent;
import obp2.events.FiredEvent;
import obp2.events.OpenConfigurationEvent;
import obp2.runtime.core.ITransitionRelation;
import obp2.statespace.configurations.FullConfigurationStorage;

public class PartiallyBoundedExplorer<C, A>
implements IExecutionController {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final FullConfigurationStorage stateSpaceManager;
    protected final ITransitionRelation runtime;
    public final Announcer announcer = new Announcer(true);
    protected final int targetDepth;
    protected int currentDepth;
    protected Queue toSee;
    protected FullConfigurationStorage nextStage;

    public PartiallyBoundedExplorer(ITransitionRelation runtime, int targetDepth) {
        this.runtime = runtime;
        this.stateSpaceManager = new FullConfigurationStorage();
        this.stateSpaceManager.setStorageBackend(new HashMap());
        this.targetDepth = targetDepth;
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public ITransitionRelation getRuntime() {
        return this.runtime;
    }

    public IProductAutomaton getProductAutomaton() {
        return null;
    }

    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }

    void initializeExploration() {
        this.nextStage = new FullConfigurationStorage();
        this.nextStage.setStorageBackend(new HashMap());
        Set initialConfigurations = this.getRuntime().initialConfigurations();
        this.announcer.announce((Object)new ExecutionStartedEvent((IExecutionController)this, initialConfigurations));
        this.currentDepth = 0;
        this.toSee = new LinkedList();
        this.toSee.addAll(initialConfigurations);
    }

    public void execute() {
        this.initializeExploration();
        while (!this.atEnd()) {
            this.explorationStep();
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    void explorationStep() {
        Object source = this.nextConfiguration();
        this.announcer.announce((Object)new OpenConfigurationEvent((IExecutionController)this, source));
        this.stateSpaceManager.put(source);
        Collection<?> fireable = this.getFireableTransitions(source);
        this.fire(fireable, source);
        this.announcer.announce((Object)new CloseConfigurationEvent((IExecutionController)this, source));
    }

    void fire(Collection<?> fireable, Object source) {
        for (Object transition : fireable) {
            if (this.monitor.atEnd()) {
                return;
            }
            IFiredTransition fired = this.getRuntime().fireOneTransition(source, transition);
            if (fired == null || fired.getTargets().isEmpty()) continue;
            this.announcer.announce((Object)new FiredEvent((IExecutionController)this, fired));
            if (!this.depthChanges(fired)) {
                if (this.stateSpaceManager.contains(fired.getTarget(0))) continue;
                this.scheduleNow(fired.getTarget(0));
                continue;
            }
            this.scheduleNext(fired.getTarget(0));
        }
    }

    boolean depthChanges(IFiredTransition transition) {
        return ((IDepthChangeDetector)this.getRuntime()).depthChanges(transition);
    }

    Collection<?> getFireableTransitions(Object source) {
        return this.getRuntime().fireableTransitionsFrom(source);
    }

    public boolean atEnd() {
        if (this.toSee.isEmpty()) {
            this.stateSpaceManager.setStorageBackend(new HashMap());
            if (this.nextStage.size() == 0) {
                return true;
            }
            this.toSee.addAll(this.nextStage.getConfigurations());
            System.out.println("depth " + this.currentDepth);
            ++this.currentDepth;
        }
        return this.currentDepth >= this.targetDepth;
    }

    public Object nextConfiguration() {
        return this.toSee.remove();
    }

    void scheduleNow(Object conf) {
        this.toSee.add(conf);
    }

    void scheduleNext(Object conf) {
        this.nextStage.put(conf);
    }
}

