/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.Serializable;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.pprint.PrettyPrint;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.Applicable;
import tlc2.value.FcnLambdaValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntervalValue;
import tlc2.value.MVPerm;
import tlc2.value.RecordValue;
import tlc2.value.SetCapValue;
import tlc2.value.SetCupValue;
import tlc2.value.SetDiffValue;
import tlc2.value.SetEnumValue;
import tlc2.value.SetOfFcnsValue;
import tlc2.value.SetOfRcdsValue;
import tlc2.value.SetOfTuplesValue;
import tlc2.value.SetPredValue;
import tlc2.value.SubsetValue;
import tlc2.value.TupleValue;
import tlc2.value.UnionValue;
import tlc2.value.ValueConstants;
import tlc2.value.ValueExcept;
import util.Assert;

public abstract class Value
implements ValueConstants,
Serializable {
    private transient SemanticNode source = null;
    public static boolean expand = true;

    public abstract byte getKind();

    public String getKindString() {
        try {
            return ValueImage[this.getKind()];
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public abstract int compareTo(Object var1);

    public abstract boolean member(Value var1);

    public abstract Value takeExcept(ValueExcept var1);

    public abstract Value takeExcept(ValueExcept[] var1);

    public void setSource(SemanticNode semanticNode) {
        this.source = semanticNode;
    }

    public SemanticNode getSource() {
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public abstract boolean isNormalized();

    public abstract Value normalize();

    public final boolean isEmpty() {
        try {
            switch (this.getKind()) {
                case 5: {
                    SetEnumValue set = (SetEnumValue)this;
                    return set.elems.size() == 0;
                }
                case 23: {
                    IntervalValue intv = (IntervalValue)this;
                    return intv.size() == 0;
                }
                case 18: {
                    SetCapValue cap = (SetCapValue)this;
                    return cap.elements().nextElement() == null;
                }
                case 19: {
                    SetCupValue cup = (SetCupValue)this;
                    return cup.elements().nextElement() == null;
                }
                case 17: {
                    SetDiffValue diff = (SetDiffValue)this;
                    return diff.elements().nextElement() == null;
                }
                case 13: {
                    SetOfFcnsValue fcns = (SetOfFcnsValue)this;
                    return fcns.elements().nextElement() == null;
                }
                case 14: {
                    SetOfRcdsValue srv = (SetOfRcdsValue)this;
                    return srv.elements().nextElement() == null;
                }
                case 15: {
                    SetOfTuplesValue stv = (SetOfTuplesValue)this;
                    return stv.elements().nextElement() == null;
                }
                case 16: {
                    return false;
                }
                case 20: {
                    UnionValue uv = (UnionValue)this;
                    return uv.elements().nextElement() == null;
                }
                case 6: {
                    SetPredValue spv = (SetPredValue)this;
                    return spv.elements().nextElement() == null;
                }
            }
            Assert.fail("Shouldn't call isEmpty() on value " + Value.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final void deepNormalize() {
        try {
            switch (this.getKind()) {
                case 4: {
                    RecordValue rcd = (RecordValue)this;
                    for (int i = 0; i < rcd.values.length; ++i) {
                        rcd.values[i].deepNormalize();
                    }
                    rcd.normalize();
                    break;
                }
                case 9: {
                    FcnRcdValue fcn = (FcnRcdValue)this;
                    for (int i = 0; i < fcn.values.length; ++i) {
                        fcn.values[i].deepNormalize();
                    }
                    fcn.normalize();
                    break;
                }
                case 5: {
                    SetEnumValue set = (SetEnumValue)this;
                    for (int i = 0; i < set.elems.size(); ++i) {
                        set.elems.elementAt(i).deepNormalize();
                    }
                    set.normalize();
                    break;
                }
                case 7: {
                    TupleValue tv = (TupleValue)this;
                    for (int i = 0; i < tv.elems.length; ++i) {
                        tv.elems[i].deepNormalize();
                    }
                    break;
                }
                case 18: {
                    SetCapValue cap = (SetCapValue)this;
                    cap.set1.deepNormalize();
                    cap.set2.deepNormalize();
                    if (cap.capSet == null) {
                        cap.capSet = DummyEnum;
                        break;
                    }
                    if (cap.capSet == DummyEnum) break;
                    cap.capSet.deepNormalize();
                    break;
                }
                case 19: {
                    SetCupValue cup = (SetCupValue)this;
                    cup.set1.deepNormalize();
                    cup.set2.deepNormalize();
                    if (cup.cupSet == null) {
                        cup.cupSet = DummyEnum;
                        break;
                    }
                    if (cup.cupSet == DummyEnum) break;
                    cup.cupSet.deepNormalize();
                    break;
                }
                case 17: {
                    SetDiffValue diff = (SetDiffValue)this;
                    diff.set1.deepNormalize();
                    diff.set2.deepNormalize();
                    if (diff.diffSet == null) {
                        diff.diffSet = DummyEnum;
                        break;
                    }
                    if (diff.diffSet == DummyEnum) break;
                    diff.diffSet.deepNormalize();
                    break;
                }
                case 13: {
                    SetOfFcnsValue fcns = (SetOfFcnsValue)this;
                    fcns.domain.deepNormalize();
                    fcns.range.deepNormalize();
                    if (fcns.fcnSet == null) {
                        fcns.fcnSet = DummyEnum;
                        break;
                    }
                    if (fcns.fcnSet == DummyEnum) break;
                    fcns.fcnSet.deepNormalize();
                    break;
                }
                case 14: {
                    SetOfRcdsValue srv = (SetOfRcdsValue)this;
                    for (int i = 0; i < srv.values.length; ++i) {
                        srv.values[i].deepNormalize();
                    }
                    if (srv.rcdSet == null) {
                        srv.rcdSet = DummyEnum;
                        break;
                    }
                    if (srv.rcdSet == DummyEnum) break;
                    srv.rcdSet.deepNormalize();
                    break;
                }
                case 15: {
                    SetOfTuplesValue stv = (SetOfTuplesValue)this;
                    for (int i = 0; i < stv.sets.length; ++i) {
                        stv.sets[i].deepNormalize();
                    }
                    if (stv.tupleSet == null) {
                        stv.tupleSet = DummyEnum;
                        break;
                    }
                    if (stv.tupleSet == DummyEnum) break;
                    stv.tupleSet.deepNormalize();
                    break;
                }
                case 16: {
                    SubsetValue pset = (SubsetValue)this;
                    pset.set.deepNormalize();
                    if (pset.pset == null) {
                        pset.pset = DummyEnum;
                        break;
                    }
                    if (pset.pset == DummyEnum) break;
                    pset.pset.deepNormalize();
                    break;
                }
                case 20: {
                    UnionValue uv = (UnionValue)this;
                    if (uv.realSet == null) {
                        uv.realSet = DummyEnum;
                        break;
                    }
                    if (uv.realSet == DummyEnum) break;
                    uv.realSet.deepNormalize();
                    break;
                }
                case 6: {
                    SetPredValue spv = (SetPredValue)this;
                    spv.inVal.deepNormalize();
                    break;
                }
                case 8: {
                    FcnLambdaValue flv = (FcnLambdaValue)this;
                    if (flv.fcnRcd == null) {
                        if (flv.excepts != null) {
                            for (int i = 0; i < flv.excepts.length; ++i) {
                                flv.excepts[i].value.deepNormalize();
                                for (int j = 0; j < flv.excepts[i].path.length; ++j) {
                                    flv.excepts[i].path[j].deepNormalize();
                                }
                            }
                        }
                        Value[] paramDoms = flv.params.domains;
                        for (int i = 0; i < paramDoms.length; ++i) {
                            paramDoms[i].deepNormalize();
                        }
                        break;
                    }
                    flv.fcnRcd.deepNormalize();
                }
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public long fingerPrint(long fp) {
        try {
            Assert.fail("TLC has found a state in which the value of a variable contains " + Value.ppr(this.toString()));
            return 0L;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public Value permute(MVPerm perm) {
        try {
            Assert.fail("TLC has found a state in which the value of a variable contains " + Value.ppr(this.toString()));
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public abstract boolean isFinite();

    public abstract int size();

    public abstract boolean isDefined();

    public abstract Value deepCopy();

    public abstract boolean assignable(Value var1);

    public final int hashCode() {
        try {
            long fp = this.fingerPrint(FP64.New());
            int high = (int)(fp >> 32);
            int low = (int)fp;
            return high ^ low;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final Value select(Value[] path) {
        try {
            Value result = this;
            for (int i = 0; i < path.length; ++i) {
                Value elem;
                if (!(result instanceof Applicable)) {
                    Assert.fail("Attempted to apply EXCEPT construct to the value " + Value.ppr(result.toString()) + ".");
                }
                if ((result = ((Applicable)((Object)result)).select(elem = path[i])) != null) continue;
                return null;
            }
            return result;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static Value getValue(SemanticNode expr) {
        return (Value)expr.getToolObject(TLCGlobals.ToolId);
    }

    public abstract StringBuffer toString(StringBuffer var1, int var2);

    public final String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            return this.toString(sb, 0).toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final String toString(String delim) {
        try {
            StringBuffer sb = new StringBuffer();
            sb = this.toString(sb, 0);
            sb.append(delim);
            return sb.toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static String ppr(String s) {
        return PrettyPrint.mypp(s, 80);
    }

    public static String ppr(Value v) {
        if (v == null) {
            return "null";
        }
        return PrettyPrint.mypp(v.toString(), 80);
    }
}

