/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PcalBuiltInSymbols;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.exception.TokenizerException;
import tla2tex.Misc;
import tla2tex.Symbol;

public class Tokenize {
    private static final int MODULE = 1;
    private static final int TLA = 2;
    public static String Delimiter;
    public static int DelimiterLine;
    public static int DelimiterCol;
    private static Vector vspec;
    private static Vector linev;
    private static char nextChar;
    private static int getLineCorrection;
    private static String token;
    private static String token1;
    private static String token2;
    private static String token3;
    private static int col1;
    private static int col2;
    private static int col3;
    private static int parenDepth;
    private static boolean inQuantifier;
    private static int cdepth;
    private static int mdepth;
    private static int col;
    private static int ncol;
    public static PcalCharReader reader;
    private static final int PROLOG = 1;
    private static final int PROLOG_DASH = 2;
    private static final int PROLOG_DASHES = 3;
    private static final int PROLOG_SPACES = 4;
    private static final int PROLOG_ID = 5;
    private static final int START = 6;
    private static final int ID = 7;
    private static final int NUM_OR_ID = 8;
    private static final int BS = 9;
    private static final int NUM = 10;
    private static final int NUM_OR_BI = 11;
    private static final int BSBUILT_IN = 12;
    private static final int BUILT_IN = 13;
    private static final int DASH1 = 14;
    private static final int DASH2 = 15;
    private static final int DASH3 = 16;
    private static final int DASHES = 17;
    private static final int EQ1 = 18;
    private static final int EQ2 = 19;
    private static final int EQ3 = 20;
    private static final int EQS = 21;
    private static final int LEFT_PAREN = 22;
    private static final int STRING = 23;
    private static final int ESC_STRING = 24;
    private static final int LINE_COMMENT = 25;
    private static final int LINE_COM_PAREN = 26;
    private static final int LINE_COM_STAR = 27;
    private static final int COMMENT = 28;
    private static final int COMMENT_STAR = 29;
    private static final int COMMENT_PAREN = 30;
    private static final int OR_COMMENT = 31;
    private static final int OR_COMMENT_PAREN = 32;
    private static final int OR_COMMENT_STAR = 33;
    private static final int EPILOG = 34;
    private static final int DONE = 35;
    private static int state;
    private static boolean exprEnd;
    private static boolean parseExpression;
    private static String prevToken;

    private static void skipNextChar() {
        ncol = reader.getColumnNumber();
        nextChar = reader.getNextChar();
        getLineCorrection = nextChar == '\n' ? -1 : 0;
    }

    private static void addNextChar() {
        token = token + nextChar;
        Tokenize.skipNextChar();
    }

    private static void gotoStart() {
        state = 6;
        col = ncol;
    }

    private static void TokenOut(int type) throws TokenizerException {
        if (parseExpression) {
            if (type == 1 || type == 2 || type == 3 || type == 4) {
                if (type != 3 && (Tokenize.IsDelimiter(token) && (type != 4 || !prevToken.equals(".") && !prevToken.equals("[") && !prevToken.equals(",")) || (token.equals(",") && !inQuantifier || token.equals(")") || token.equals("}")) && parenDepth == 0)) {
                    if (parenDepth != 0) {
                        Tokenize.TokenizingError("Expression with an unmatched (, [, {, or << followed by");
                    }
                    if (inQuantifier) {
                        Tokenize.TokenizingError("Expression with \\A or \\E but no following `:` followed by");
                    }
                    exprEnd = true;
                    Delimiter = token;
                    DelimiterCol = col;
                    DelimiterLine = reader.getLineNumber();
                    if (nextChar == '\n') {
                        --DelimiterLine;
                    }
                    if (linev.size() > 0) {
                        Tokenize.startNewLine();
                    }
                } else {
                    if (type == 1) {
                        Symbol sym = PcalBuiltInSymbols.GetBuiltInSymbol(token);
                        if (sym.symbolType == 4) {
                            ++parenDepth;
                        }
                        if (sym.symbolType == 5 && --parenDepth < 0) {
                            Tokenize.TokenizingError("Extra (unmatching)");
                        }
                    }
                    prevToken = type == 3 ? " " : token;
                    if ((token.equals("\\A") || token.equals("\\E")) && parenDepth == 0) {
                        inQuantifier = true;
                    }
                    if (inQuantifier && token.equals(":") && parenDepth == 0) {
                        inQuantifier = false;
                    }
                    if (!token.equals("") || type == 3) {
                        linev.addElement(new TLAToken(token, col, type, reader.getLineNumber() + getLineCorrection));
                    }
                    token = "";
                }
            } else {
                Tokenize.TokenizingError("Illegal token in an expression");
            }
        } else {
            exprEnd = true;
            Delimiter = token;
            DelimiterCol = col;
            DelimiterLine = reader.getLineNumber();
            if (nextChar == '\n') {
                --DelimiterLine;
            }
            token = "";
        }
    }

    private static boolean IsDelimiter(String tok) {
        return tok.equals(";") || tok.equals("do") || tok.equals("then") || tok.equals(":=") || tok.equals("begin") || tok.equals("variable") || tok.equals("variables") || tok.equals("||") || tok.equals("end") || tok.equals("else") || tok.equals("elsif") || tok.equals("if") || tok.equals("either") || tok.equals("or") || tok.equals("while") || tok.equals("with") || tok.equals("call") || tok.equals("return") || tok.equals("goto") || tok.equals("print") || tok.equals("assert") || tok.equals("skip") || tok.equals("procedure") || tok.equals("define") || tok.equals("process");
    }

    private static void CommentTokenOut() {
        token = "";
    }

    private static void startNewLine() {
        vspec.addElement(linev);
        linev = new Vector(30, 30);
        col = 0;
    }

    private static void TokenizingError(String msg) throws TokenizerException {
        throw new TokenizerException(msg + " `" + token + "' found at\n    line " + (reader.getLineNumber() + 1) + ", column " + (col + 1));
    }

    public static TLAExpr TokenizeExpr(PcalCharReader charReader) throws TokenizerException {
        TLAExpr exp = Tokenize.InnerTokenize(charReader, true);
        return exp;
    }

    public static String GetAlgorithmToken(PcalCharReader charReader) throws TokenizerException {
        TLAExpr exp = Tokenize.InnerTokenize(charReader, false);
        return Delimiter;
    }

    public static TLAExpr InnerTokenize(PcalCharReader charReader, boolean isExpr) throws TokenizerException {
        int mode = 2;
        col = ncol = charReader.getColumnNumber();
        parseExpression = isExpr;
        prevToken = " ";
        vspec = new Vector(4);
        reader = charReader;
        linev = new Vector();
        token = "";
        nextChar = reader.getNextChar();
        getLineCorrection = nextChar == '\n' ? -1 : 0;
        parenDepth = 0;
        inQuantifier = false;
        switch (mode) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 6;
                break;
            }
            default: {
                PcalDebug.ReportBug("TokenizeSpec.Tokenize called with illegal mode");
            }
        }
        exprEnd = false;
        block40: while (state != 35 && !exprEnd) {
            switch (state) {
                case 6: {
                    if (Misc.IsSpace(nextChar)) {
                        Tokenize.skipNextChar();
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        state = 7;
                        continue block40;
                    }
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 8;
                        continue block40;
                    }
                    if (nextChar == '\\') {
                        Tokenize.addNextChar();
                        state = 9;
                        continue block40;
                    }
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        state = 14;
                        continue block40;
                    }
                    if (nextChar == '=') {
                        Tokenize.addNextChar();
                        state = 18;
                        continue block40;
                    }
                    if (nextChar == '(') {
                        Tokenize.skipNextChar();
                        state = 22;
                        continue block40;
                    }
                    if (nextChar == '\"') {
                        Tokenize.skipNextChar();
                        state = 23;
                        continue block40;
                    }
                    if (nextChar == '\n') {
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInPrefix("" + nextChar)) {
                        Tokenize.addNextChar();
                        state = 13;
                        continue block40;
                    }
                    if (nextChar == '\t') {
                        if (mode == 1) {
                            throw new TokenizerException("Input ended before end of module");
                        }
                        state = 35;
                        continue block40;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal lexeme");
                    continue block40;
                }
                case 7: {
                    if (token.length() == 3 && (token.equals("WF_") || token.equals("SF_"))) {
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        if (token.equals("MODULE")) {
                            ++mdepth;
                        }
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    Tokenize.TokenOut(4);
                    Tokenize.gotoStart();
                    continue block40;
                }
                case 8: {
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 8;
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        state = 7;
                        continue block40;
                    }
                    Tokenize.TokenOut(2);
                    Tokenize.gotoStart();
                    continue block40;
                }
                case 9: {
                    if (nextChar == 'b' || nextChar == 'B' || nextChar == 'o' || nextChar == 'O' || nextChar == 'h' || nextChar == 'H') {
                        Tokenize.addNextChar();
                        state = 11;
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        state = 12;
                        continue block40;
                    }
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        token = "";
                        state = 25;
                        continue block40;
                    }
                    state = 13;
                    continue block40;
                }
                case 11: {
                    if (Misc.IsDigit(nextChar)) {
                        state = 10;
                        continue block40;
                    }
                    state = 12;
                    continue block40;
                }
                case 10: {
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 10;
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        if (token.charAt(0) == '\\') {
                            Tokenize.TokenizingError("Illegal lexeme");
                            continue block40;
                        }
                        state = 7;
                        continue block40;
                    }
                    Tokenize.TokenOut(2);
                    Tokenize.gotoStart();
                    continue block40;
                }
                case 12: {
                    if (Misc.IsLetter(nextChar) && nextChar != '_') {
                        Tokenize.addNextChar();
                        state = 12;
                        continue block40;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    Tokenize.TokenizingError("Illegal lexeme ");
                    continue block40;
                }
                case 13: {
                    if (PcalBuiltInSymbols.IsBuiltInPrefix(token + nextChar)) {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    if (!PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        reader.backspace();
                        while (!PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                            reader.backspace();
                            if (token.length() == 0) {
                                Tokenize.TokenizingError("Illegal lexeme");
                            }
                            token = token.substring(0, token.length() - 1);
                        }
                        Tokenize.skipNextChar();
                    }
                    Tokenize.TokenOut(1);
                    Tokenize.gotoStart();
                    continue block40;
                }
                case 14: {
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        state = 15;
                        continue block40;
                    }
                    state = 13;
                    continue block40;
                }
                case 15: {
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        state = 16;
                        continue block40;
                    }
                    state = 13;
                    continue block40;
                }
                case 16: {
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        state = 17;
                        continue block40;
                    }
                    Tokenize.TokenizingError("Illegal lexeme");
                    continue block40;
                }
                case 17: {
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        state = 17;
                        continue block40;
                    }
                    Tokenize.TokenOut(6);
                    Tokenize.gotoStart();
                    continue block40;
                }
                case 18: {
                    if (nextChar == '=') {
                        Tokenize.addNextChar();
                        state = 19;
                        continue block40;
                    }
                    state = 13;
                    continue block40;
                }
                case 19: {
                    if (nextChar == '=') {
                        Tokenize.addNextChar();
                        state = 20;
                        continue block40;
                    }
                    state = 13;
                    continue block40;
                }
                case 20: {
                    if (nextChar == '=') {
                        Tokenize.addNextChar();
                        state = 21;
                        continue block40;
                    }
                    Tokenize.TokenizingError("Illegal lexeme");
                    continue block40;
                }
                case 21: {
                    if (nextChar == '=') {
                        Tokenize.addNextChar();
                        state = 21;
                        continue block40;
                    }
                    Tokenize.TokenOut(7);
                    if (--mdepth > 0 || mode == 2) {
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (mdepth == 0) {
                        state = 34;
                        continue block40;
                    }
                    throw new TokenizerException("Extra end-of-module lexeme on line " + (reader.getLineNumber() + 1));
                }
                case 22: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        cdepth = 1;
                        state = 28;
                        continue block40;
                    }
                    token = "(";
                    state = 13;
                    continue block40;
                }
                case 23: {
                    if (nextChar == '\\') {
                        Tokenize.addNextChar();
                        state = 24;
                        continue block40;
                    }
                    if (nextChar == '\"') {
                        Tokenize.skipNextChar();
                        Tokenize.TokenOut(3);
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (PcalBuiltInSymbols.IsStringChar(nextChar)) {
                        Tokenize.addNextChar();
                        state = 23;
                        continue block40;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal character in string");
                    continue block40;
                }
                case 24: {
                    if (nextChar == '\"' || nextChar == '\\' || nextChar == 't' || nextChar == 'n' || nextChar == 'f' || nextChar == 'r') {
                        Tokenize.addNextChar();
                        state = 23;
                        continue block40;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal character following \\ in string");
                    continue block40;
                }
                case 25: {
                    if (nextChar == '(') {
                        Tokenize.skipNextChar();
                        state = 26;
                        continue block40;
                    }
                    if (nextChar == '*' && cdepth > 0) {
                        Tokenize.skipNextChar();
                        state = 27;
                        continue block40;
                    }
                    if (nextChar == '\n' || nextChar == '\t') {
                        Tokenize.CommentTokenOut();
                        cdepth = 0;
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    if (cdepth == 0) {
                        Tokenize.addNextChar();
                    } else {
                        Tokenize.skipNextChar();
                    }
                    state = 25;
                    continue block40;
                }
                case 26: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 25;
                        continue block40;
                    }
                    if (cdepth == 0) {
                        token = token + "(";
                    }
                    state = 25;
                    continue block40;
                }
                case 27: {
                    if (nextChar == ')') {
                        Tokenize.skipNextChar();
                        PcalDebug.Assert(--cdepth >= 0, "case LINE_COM_STAR");
                        state = 25;
                        continue block40;
                    }
                    if (cdepth == 0) {
                        token = token + "*";
                    }
                    state = 25;
                    continue block40;
                }
                case 28: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        state = 29;
                        continue block40;
                    }
                    if (nextChar == '(') {
                        Tokenize.skipNextChar();
                        state = 30;
                        continue block40;
                    }
                    if (nextChar == '\n') {
                        Tokenize.CommentTokenOut();
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        state = 31;
                        continue block40;
                    }
                    if (nextChar == '\t') {
                        throw new TokenizerException("Input ended in the middle of a comment");
                    }
                    if (cdepth == 1) {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    Tokenize.skipNextChar();
                    continue block40;
                }
                case 29: {
                    if (nextChar == ')') {
                        Tokenize.skipNextChar();
                        if (--cdepth == 0) {
                            Tokenize.CommentTokenOut();
                            Tokenize.gotoStart();
                            continue block40;
                        }
                        state = 28;
                        continue block40;
                    }
                    if (cdepth == 1) {
                        token = token + "*";
                    }
                    state = 28;
                    continue block40;
                }
                case 30: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 28;
                        continue block40;
                    }
                    if (cdepth == 1) {
                        token = token + "(";
                    }
                    state = 28;
                    continue block40;
                }
                case 31: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        state = 33;
                        continue block40;
                    }
                    if (nextChar == '(') {
                        Tokenize.skipNextChar();
                        state = 32;
                        continue block40;
                    }
                    if (nextChar == '\n') {
                        Tokenize.CommentTokenOut();
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        state = 31;
                        continue block40;
                    }
                    if (nextChar == '\t') {
                        throw new TokenizerException("Input ended in the middle of a multi-line comment");
                    }
                    if (cdepth == 1) {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    Tokenize.skipNextChar();
                    continue block40;
                }
                case 33: {
                    if (nextChar == ')') {
                        Tokenize.skipNextChar();
                        PcalDebug.Assert(--cdepth >= 0);
                        if (cdepth == 0) {
                            Tokenize.CommentTokenOut();
                            Tokenize.gotoStart();
                            continue block40;
                        }
                        state = 31;
                        continue block40;
                    }
                    if (cdepth == 1) {
                        token = token + "*";
                    }
                    state = 31;
                    continue block40;
                }
                case 32: {
                    if (nextChar == '*') {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 31;
                        continue block40;
                    }
                    if (cdepth == 1) {
                        token = token + "(";
                    }
                    state = 31;
                    continue block40;
                }
                case 1: {
                    if (nextChar == '-') {
                        token1 = token;
                        col1 = col;
                        col = ncol;
                        token = "-";
                        Tokenize.skipNextChar();
                        state = 2;
                        continue block40;
                    }
                    if (nextChar == '\n') {
                        Tokenize.TokenOut(8);
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        continue block40;
                    }
                    if (nextChar == '\t') {
                        throw new TokenizerException("Input ended before beginning of module");
                    }
                    Tokenize.addNextChar();
                    continue block40;
                }
                case 2: {
                    PcalDebug.Assert(token.length() <= 3);
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        if (token.length() != 4) continue block40;
                        state = 3;
                        continue block40;
                    }
                    token = token1 + token;
                    col = col1;
                    state = 1;
                    continue block40;
                }
                case 3: {
                    if (nextChar == '-') {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    token2 = token;
                    col2 = col;
                    token = "";
                    col = ncol;
                    state = 4;
                    continue block40;
                }
                case 4: {
                    if (nextChar == ' ') {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        token3 = token;
                        col3 = ncol;
                        token = "";
                        state = 5;
                        continue block40;
                    }
                    token = token1 + token2;
                    col = col1;
                    state = 1;
                    continue block40;
                }
                case 5: {
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        continue block40;
                    }
                    if (token.equals("MODULE")) {
                        token = token1;
                        col = col1;
                        Tokenize.TokenOut(8);
                        token = token2;
                        col = col2;
                        Tokenize.TokenOut(6);
                        token = "MODULE";
                        col = col3;
                        Tokenize.TokenOut(1);
                        token = "";
                        mdepth = 1;
                        Tokenize.gotoStart();
                        continue block40;
                    }
                    token = token1 + token2 + token3;
                    col = col1;
                    state = 1;
                    continue block40;
                }
                case 34: {
                    if (nextChar == '\n') {
                        Tokenize.TokenOut(9);
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        continue block40;
                    }
                    if (nextChar == '\t') {
                        Tokenize.TokenOut(9);
                        state = 35;
                        continue block40;
                    }
                    Tokenize.addNextChar();
                    continue block40;
                }
            }
            PcalDebug.ReportBug("Illegal state in TokenizeSpec.Tokenize");
        }
        if (nextChar != '\n') {
            reader.backspace();
        }
        TLAExpr rval = new TLAExpr(vspec);
        rval.normalize();
        return rval;
    }

    static {
        vspec = null;
        linev = new Vector(30, 30);
        getLineCorrection = 0;
        token = "";
        token1 = "";
        token2 = "";
        token3 = "";
        col1 = 0;
        col2 = 0;
        col3 = 0;
        parenDepth = 0;
        inQuantifier = false;
        cdepth = 0;
        mdepth = 0;
        ncol = 0;
        state = 0;
        exprEnd = false;
        parseExpression = true;
        prevToken = " ";
    }
}

