/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.fx;

import java.net.URL;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import plug.utils.file.FileWatcher;

public class GuiFxUtils {
    public static void addButtonEffects(Node btn) {
        DropShadow normalShadow = new DropShadow(3.0, Color.DARKGRAY);
        normalShadow.setBlurType(BlurType.GAUSSIAN);
        btn.setEffect((Effect)normalShadow);
        DropShadow hoverShadow = new DropShadow(3.0, Color.BLACK);
        hoverShadow.setBlurType(BlurType.GAUSSIAN);
        DropShadow clickShadow = new DropShadow(5.0, Color.GREEN);
        clickShadow.setBlurType(BlurType.GAUSSIAN);
        btn.addEventHandler(MouseEvent.MOUSE_ENTERED, e -> btn.setEffect((Effect)hoverShadow));
        btn.addEventHandler(MouseEvent.MOUSE_EXITED, e -> btn.setEffect((Effect)normalShadow));
        btn.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> btn.setEffect((Effect)clickShadow));
        btn.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> btn.setEffect((Effect)hoverShadow));
    }

    public static void setStylesheet(URL cssFilePath, Scene inScene, FileWatcher theWatcher) {
        String external = cssFilePath.toExternalForm();
        inScene.getStylesheets().add((Object)external);
    }

    public static void addTooltip(StringBinding textBinding, Node shape) {
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)textBinding);
        tooltip.setFont(Font.font((String)"Times"));
        Tooltip.install((Node)shape, (Tooltip)tooltip);
    }
}

