/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import java.util.ArrayList;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.language.buchi.runtime.BuchiRuntimeView;
import obp2.language.buchikripke.runtime.KRIPKE2TBA_TBA_ProductSemantics;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiLanguageModule;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.TreeItem;
import obp2.runtime.core.defaults.DefaultTreeProjector;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;

public class KripkeBuchiRuntimeView
extends DefaultTreeProjector<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    private transient ITreeProjector kripkeView;
    private transient ITreeProjector buchiView;

    public KripkeBuchiRuntimeView(KripkeBuchiLanguageModule languageModule) {
        this.setModule((ILanguageModule)languageModule);
    }

    public ITreeProjector getKripkeView() {
        if (this.kripkeView != null) {
            return this.kripkeView;
        }
        this.kripkeView = ((KripkeBuchiLanguageModule)this.getModule()).kripke.getTreeProjector();
        return this.kripkeView;
    }

    public ITreeProjector getBuchiView() {
        if (this.buchiView != null) {
            return this.buchiView;
        }
        this.buchiView = new BuchiRuntimeView();
        return this.buchiView;
    }

    public TreeItem projectConfiguration(KripkeBuchiConfiguration value) {
        ArrayList<TreeItem> children = new ArrayList<TreeItem>();
        TreeItem buchiProcess = new TreeItem("b\u00fcchi", new TreeItem[]{this.getBuchiView().projectConfiguration((Object)value.buchiState)});
        buchiProcess.setExpanded(true);
        children.add(buchiProcess);
        if (value.kripke != null) {
            TreeItem kripkeTree = this.getKripkeView().projectConfiguration((Object)value.kripke);
            kripkeTree.setExpanded(true);
            children.add(kripkeTree);
        } else {
            children.add(new TreeItem("<not present>"));
        }
        return new TreeItem("", children);
    }

    public TreeItem projectFireable(Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition> transition) {
        Object action = ((IFiredTransition)transition.a).getAction();
        if (action instanceof KRIPKE2TBA_TBA_ProductSemantics.StutteringTransition) {
            return new TreeItem("Buchi stuttering");
        }
        if (action == null) {
            return new TreeItem("Buchi initial transition");
        }
        TreeItem kripkeTransitionDescription = this.getKripkeView().projectFireable(action);
        TreeItem buchiTransitionDescription = this.getBuchiView().projectFireable(transition.b);
        return new TreeItem(kripkeTransitionDescription.name + "\n/\\\n" + buchiTransitionDescription.name, new TreeItem[]{kripkeTransitionDescription, buchiTransitionDescription});
    }
}

