/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class GraphViewModel<V, E> {
    protected final ObservableList<V> initialVertices = FXCollections.observableArrayList();
    protected final ObservableList<Edge<V, E>> edges = FXCollections.observableArrayList();

    public ObservableList<V> getInitialVertices() {
        return this.initialVertices;
    }

    public ObservableList<Edge<V, E>> getEdges() {
        return this.edges;
    }

    public Edge<V, E> addEdge(V source, V target, E label) {
        Edge<V, E> edge = new Edge<V, E>(source, target, label);
        this.edges.add(edge);
        return edge;
    }

    public boolean removeVertex(V vertex) {
        if (this.initialVertices.remove(vertex)) {
            return true;
        }
        int indexToRemove = -1;
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.target != vertex) continue;
            indexToRemove = i;
            break;
        }
        if (indexToRemove >= 0) {
            this.edges.remove(indexToRemove);
        }
        return indexToRemove >= 0;
    }

    public List<Edge<V, E>> edgesFrom(V source) {
        return this.edges.stream().filter(e -> e.source == source).collect(Collectors.toList());
    }

    public String vertexDescription(V vertex) {
        return vertex.toString();
    }

    public String edgeDescription(E edge) {
        return edge.toString();
    }

    public Region vertexNode(V vertex) {
        return null;
    }

    public boolean vertexIsSink(V vertex) {
        return false;
    }

    public Color vertexColor(V vertex) {
        return Color.WHITE;
    }

    public Set<V> equivalentVertices(V vertex) {
        return Collections.emptySet();
    }

    public static class Edge<V, E> {
        public final V source;
        public final V target;
        public final E label;

        public Edge(V source, V target, E label) {
            this.source = source;
            this.target = target;
            this.label = label;
        }
    }
}

