/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.transformations;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.True;
import properties.PropositionalLogic.PropositionalLogicModel.util.PropositionalLogicModelSwitch;

public class PropositionalLogic2AbstractText
extends PropositionalLogicModelSwitch<String> {
    public Map<String, Atom> name2atom;
    Map<Atom, String> atom2name = new IdentityHashMap<Atom, String>();
    public int idx = 0;
    Stack<Map<String, String>> context = new Stack();

    @Override
    public String caseFalse(False object) {
        return "false";
    }

    @Override
    public String caseTrue(True object) {
        return "true";
    }

    @Override
    public String caseLogicalNegation(LogicalNegation object) {
        String operand = (String)this.doSwitch(object.getOperand());
        return "(! " + operand + ")";
    }

    @Override
    public String caseLogicalImplication(LogicalImplication object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " -> " + rhs + ")";
    }

    @Override
    public String caseLogicalEquivalence(LogicalEquivalence object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " <-> " + rhs + ")";
    }

    @Override
    public String caseLogicalConjunction(LogicalConjunction object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " && " + rhs + ")";
    }

    @Override
    public String caseLogicalDisjunction(LogicalDisjunction object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " || " + rhs + ")";
    }

    @Override
    public String caseLogicalXOR(LogicalXOR object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " xor " + rhs + ")";
    }

    @Override
    public String caseAtom(Atom object) {
        String name = this.atom2name.get(object);
        if (name != null) {
            return name;
        }
        name = this.newAtomName();
        this.atom2name.put(object, name);
        this.name2atom.put(name, object);
        return name;
    }

    private String newAtomName() {
        return "a" + this.idx++;
    }

    @Override
    public String caseExpressionReference(ExpressionReference object) {
        ExpressionDeclaration decl = object.getExp();
        return (String)this.doSwitch(decl.getExpression());
    }

    String lookup(String name) {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            String value = (String)((Map)this.context.get(i)).get(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public String caseLetExpression(LetExpression object) {
        HashMap<String, String> frame = new HashMap<String, String>();
        for (Declaration decl : object.getDeclarations()) {
            String name = decl.getName();
            String formula = (String)this.doSwitch(((ExpressionDeclaration)decl).getExpression());
            frame.put(name, formula);
        }
        this.context.push(frame);
        return (String)this.doSwitch(object.getExpression());
    }

    @Override
    public String caseExpressionDeclaration(ExpressionDeclaration object) {
        String value = this.lookup(object.getName());
        if (value != null) {
            return value;
        }
        value = (String)this.doSwitch(object.getExpression());
        return value;
    }
}

