/*
 * Decompiled with CFR 0.152.
 */
package obp2.simulation.trace_storage;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import plug.utils.Pair;

public class TraceEntry<C, A, O> {
    private final TraceEntry<C, A, O> parent;
    private final C configuration;
    private final Pair<A, O> transition;
    private final Set<TraceEntry<C, A, O>> children = new HashSet<TraceEntry<C, A, O>>();

    public TraceEntry(TraceEntry<C, A, O> parent, C configuration, Pair<A, O> transition) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.configuration = configuration;
        this.transition = transition;
    }

    public TraceEntry(TraceEntry<C, A, O> parent, C configuration) {
        this(parent, configuration, null);
    }

    public TraceEntry(C configuration) {
        this(null, configuration);
    }

    public void addChild(TraceEntry<C, A, O> child) {
        this.children.add(child);
    }

    public Set<TraceEntry<C, A, O>> getChildren() {
        return this.children;
    }

    public TraceEntry<C, A, O> getParent() {
        return this.parent;
    }

    public C getParentConfiguration() {
        return this.parent == null ? null : (C)this.parent.getConfiguration();
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public A getAction() {
        return (A)this.transition.a;
    }

    public O getOutput() {
        return (O)this.transition.b;
    }

    public Pair<A, O> getTransition() {
        return this.transition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceEntry that = (TraceEntry)o;
        return this.parent == that.parent && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.getParentConfiguration(), this.configuration);
    }

    public String toString() {
        if (this.getParentConfiguration() != null) {
            return Integer.toHexString(this.getParentConfiguration().hashCode()) + " -> " + Integer.toHexString(this.configuration.hashCode());
        }
        return Integer.toHexString(this.configuration.hashCode());
    }
}

