/*
 * Decompiled with CFR 0.152.
 */
package obp2.runtime.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TreeItem
implements Iterable<TreeItem> {
    public String type;
    public String name;
    public String icon;
    public List<TreeItem> children;
    protected boolean different = false;
    protected boolean expanded = false;
    public static final TreeItem empty = new TreeItem("\u2205");

    public TreeItem(String type, String name, String icon, List<TreeItem> children) {
        this.type = type == null ? "" : type;
        this.name = name == null ? "" : name;
        this.icon = icon == null ? "" : icon;
        this.children = children == null ? Collections.emptyList() : children;
    }

    public TreeItem(String name) {
        this(null, name, null, null);
    }

    public TreeItem(String name, List<TreeItem> children) {
        this(null, name, null, children);
    }

    public TreeItem(String name, TreeItem ... children) {
        this(name, Arrays.asList(children));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isDifferent() {
        return this.different;
    }

    public void setDifferent(boolean different) {
        this.different = different;
    }

    @Override
    public Iterator<TreeItem> iterator() {
        return this.children.iterator();
    }

    public List<TreeItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isDifferentFrom(TreeItem other) {
        return !Objects.equals(this.name, other.name) || !Objects.equals(this.type, other.type);
    }

    public void updateExpanded(TreeItem other) {
        if (other == null) {
            return;
        }
        this.setExpanded(other.expanded);
        List<TreeItem> myChildren = this.getChildren();
        List<TreeItem> otherChildren = other.getChildren();
        for (int i = 0; i < myChildren.size(); ++i) {
            TreeItem myChild = myChildren.get(i);
            TreeItem otherChild = i < otherChildren.size() ? otherChildren.get(i) : null;
            myChild.updateExpanded(otherChild);
        }
    }

    public boolean updateDifferentStatus(TreeItem other) {
        if (other == null) {
            for (TreeItem children : this.getChildren()) {
                children.updateDifferentStatus(other);
            }
            this.different = true;
            return true;
        }
        List<TreeItem> otherChildren = other.getChildren();
        this.different = this.isDifferentFrom(other);
        this.different |= this.children.size() != otherChildren.size();
        for (int i = 0; i < this.children.size(); ++i) {
            TreeItem confChild = this.children.get(i);
            TreeItem otherChild = i < otherChildren.size() ? otherChildren.get(i) : null;
            this.different |= confChild.updateDifferentStatus(otherChild);
        }
        return this.different;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("" + this.name + " [");
        boolean first = true;
        for (TreeItem child : this.children) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(child.toString());
        }
        str.append("]");
        return str.toString();
    }
}

