/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.reachability;

import announce4j.Announcer;
import java.util.Iterator;
import obp2.algorithms.Color;
import obp2.core.IConfiguration;
import obp2.core.IProductAutomaton;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.CloseConfigurationEvent;
import obp2.events.ExecutionEndedEvent;
import obp2.events.ExecutionStartedEvent;
import obp2.events.FiredEvent;
import obp2.events.OpenConfigurationEvent;
import obp2.runtime.core.ITransitionRelation;
import obp2.statespace.LazyProductAutomaton;

public abstract class AbstractExplorer<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final IStateSpaceManager<C, A, Object> stateSpaceManager;
    protected final IProductAutomaton productAutomaton;
    protected final Announcer announcer = new Announcer(true);

    public AbstractExplorer(ITransitionRelation<C, ?, ?> runtime, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this.stateSpaceManager = stateSpaceManager;
        this.productAutomaton = new LazyProductAutomaton(runtime, stateSpaceManager, () -> Color.WHITE);
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return this.stateSpaceManager;
    }

    public ITransitionRelation getRuntime() {
        return (ITransitionRelation)this.productAutomaton;
    }

    public IProductAutomaton getProductAutomaton() {
        return this.productAutomaton;
    }

    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }

    abstract boolean atEnd();

    abstract C nextConfiguration();

    abstract void schedule(C var1);

    void initializeExploration() {
        for (IConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
            this.schedule(initial);
        }
        this.announcer.announce((Object)new ExecutionStartedEvent((IExecutionController)this, this.stateSpaceManager.initialConfigurations()));
    }

    public void execute() {
        this.initializeExploration();
        while (!this.monitor.atEnd() && !this.atEnd()) {
            this.explorationStep();
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    void explorationStep() {
        C source = this.nextConfiguration();
        this.announcer.announce((Object)new OpenConfigurationEvent((IExecutionController)this, source));
        this.fire(source);
        this.announcer.announce((Object)new CloseConfigurationEvent((IExecutionController)this, source));
    }

    protected void fire(C source) {
        Iterator iterator = this.getProductAutomaton().getPostIterable(source).iterator();
        while (iterator.hasNext()) {
            this.announcer.announce((Object)new FiredEvent((IExecutionController)this, ((LazyProductAutomaton.PostIterator)iterator).currentFiredTransition));
            if (this.monitor.atEnd()) {
                this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
                return;
            }
            IConfiguration target = (IConfiguration)iterator.next();
            if (this.getColor(target) != Color.WHITE) continue;
            this.schedule(target);
        }
    }

    Color getColor(C state) {
        return (Color)((Object)state.getMetadata());
    }

    void setColor(C state, Color color) {
        state.setMetadata((Object)color);
    }
}

