/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.util.Enumeration;
import java.util.Hashtable;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.MVPerm;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;
import util.UniqueString;

public class ModelValue
extends Value {
    private static int count;
    private static Hashtable mvTable;
    public static ModelValue[] mvs;
    public UniqueString val;
    public int index;
    public char type;

    public static void init() {
        count = 0;
        mvTable = new Hashtable();
        mvs = null;
    }

    private ModelValue(String val) {
        this.val = UniqueString.uniqueStringOf(val);
        this.index = count++;
        this.type = val.length() > 2 && val.charAt(1) == '_' ? val.charAt(0) : (char)'\u0000';
    }

    public static ModelValue make(String str) {
        ModelValue mv = (ModelValue)mvTable.get(str);
        if (mv != null) {
            return mv;
        }
        mv = new ModelValue(str);
        mvTable.put(str, mv);
        return mv;
    }

    public static void setValues() {
        mvs = new ModelValue[mvTable.size()];
        Enumeration Enum2 = mvTable.elements();
        while (Enum2.hasMoreElements()) {
            ModelValue mv;
            ModelValue.mvs[mv.index] = mv = (ModelValue)Enum2.nextElement();
        }
    }

    @Override
    public final byte getKind() {
        return 21;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof ModelValue) {
                return this.val.compareTo(((ModelValue)obj).val);
            }
            return -1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (this.type == '\u0000') {
                return obj instanceof ModelValue && this.val.equals(((ModelValue)obj).val);
            }
            if (obj instanceof ModelValue) {
                ModelValue mobj = (ModelValue)obj;
                if (mobj.type == this.type || mobj.type == '\u0000') {
                    return mobj.val == this.val;
                }
                Assert.fail("Attempted to check equality of the differently-typed model values " + ModelValue.ppr(this.toString()) + " and " + ModelValue.ppr(mobj.toString()));
            }
            Assert.fail("Attempted to check equality of typed model value " + ModelValue.ppr(this.toString()) + " and non-model value\n" + ModelValue.ppr(obj.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean modelValueEquals(Object obj) {
        try {
            if (this.type != '\u0000') {
                Assert.fail("Attempted to check equality of the typed model value " + ModelValue.ppr(this.toString()) + " and the non-model value\n" + ModelValue.ppr(obj.toString()));
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean modelValueMember(Object obj) {
        try {
            if (this.type != '\u0000') {
                Assert.fail("Attempted to check if the typed model value " + ModelValue.ppr(this.toString()) + " is an element of\n" + ModelValue.ppr(obj.toString()));
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + ModelValue.ppr(elem.toString()) + "\nis an element of the model value " + ModelValue.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the model value " + ModelValue.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the model value " + ModelValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the model value " + ModelValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the model value " + ModelValue.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof ModelValue && this.val.equals(((ModelValue)val).val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            return this.val.fingerPrint(FP64.Extend(fp, (byte)21));
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            ModelValue res = perm.get(this);
            if (res == null) {
                return this;
            }
            return res;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            return sb.append(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    static {
        ModelValue.init();
    }
}

