/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.util.BitVector;

public abstract class AbstractGraphNode {
    protected BitVector checks;

    public AbstractGraphNode(BitVector bitVector) {
        this.checks = bitVector;
    }

    public boolean getCheckState(int i) {
        return this.checks.get(i);
    }

    public BitVector getCheckAction(int slen, int alen, int nodeIdx) {
        BitVector bv = new BitVector(alen);
        for (int j = 0; j < alen; ++j) {
            bv.set(j, this.getCheckAction(slen, alen, nodeIdx, j));
        }
        return bv;
    }

    public boolean getCheckAction(int slen, int alen, int nodeIdx, int i) {
        int pos = slen + alen * nodeIdx + i;
        return this.checks.get(pos);
    }

    public boolean getCheckAction(int slen, int alen, int nodeIdx, int[] is) {
        int len = is.length;
        for (int i = 0; i < len; ++i) {
            int pos = slen + alen * nodeIdx + is[i];
            if (this.checks.get(pos)) continue;
            return false;
        }
        return true;
    }

    public void setCheckState(boolean[] vals) {
        int len = vals.length;
        for (int i = 0; i < len; ++i) {
            if (!vals[i]) continue;
            this.checks.set(i);
        }
    }
}

