/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.TLA;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import obp2.language.TLA.TLARuntimeView;
import obp2.language.TLA.runtime.TLAConfiguration;
import obp2.language.TLA.runtime.TLATransitionRelation;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.LanguageModule;
import plug.utils.Pair;
import tla2sany.modanalyzer.SpecObj;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.tool.TLAAtomicPropositionsEvaluator;
import tlc2.tool.Tool;
import tlc2.util.FP64;
import util.FileUtil;
import util.FilenameToStream;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class TLAPlugin
implements ILanguagePlugin<URI, TLAConfiguration, Pair<Action, StateVec>, Void> {
    public String[] getExtensions() {
        return new String[]{".tla"};
    }

    public String getName() {
        return "TLA+";
    }

    public Function<URI, ILanguageModule<TLAConfiguration, Pair<Action, StateVec>, Void>> languageModuleFunction() {
        return this::getRuntime;
    }

    public ILanguageModule<TLAConfiguration, Pair<Action, StateVec>, Void> getRuntime(URI tlaProgram, Map<String, Object> options) {
        Object metaDir;
        if (options == null || (metaDir = options.get("metaDir")) == null) {
            return this.getRuntime(new File(tlaProgram).getAbsolutePath(), "tmp/model" + System.currentTimeMillis() + "/");
        }
        return this.getRuntime(new File(tlaProgram).getAbsolutePath(), (String)metaDir);
    }

    public ILanguageModule<TLAConfiguration, Pair<Action, StateVec>, Void> getRuntime(URI tlaProgram) {
        return this.getRuntime(new File(tlaProgram).getAbsolutePath());
    }

    public ILanguageModule<TLAConfiguration, Pair<Action, StateVec>, Void> getRuntime(String tlaProgramFile) {
        return this.getRuntime(tlaProgramFile, "tmp/model" + System.currentTimeMillis() + "/");
    }

    public ILanguageModule<TLAConfiguration, Pair<Action, StateVec>, Void> getRuntime(String tlaProgramFile, String metaDir) {
        FP64.Init((int)0);
        TLCGlobals.chkptDuration = 0L;
        TLCGlobals.metaDir = metaDir;
        ToolIO.cleanToolObjects((int)TLCGlobals.ToolId);
        ToolIO.reset();
        ToolIO.unregisterSemanticNodes();
        ToolIO.setUserDir((String)".");
        int lastSep = tlaProgramFile.lastIndexOf(FileUtil.separatorChar);
        String specDir = lastSep == -1 ? "" : tlaProgramFile.substring(0, lastSep + 1);
        tlaProgramFile = tlaProgramFile.substring(lastSep + 1);
        tlaProgramFile = tlaProgramFile.indexOf(".tla") == -1 ? tlaProgramFile : tlaProgramFile.substring(0, tlaProgramFile.indexOf(".tla"));
        SimpleFilenameToStream resolver = new SimpleFilenameToStream(new String[]{new File(specDir).getAbsolutePath()});
        String configFile = tlaProgramFile.indexOf(".tla") == -1 ? tlaProgramFile : tlaProgramFile.substring(0, tlaProgramFile.indexOf(".tla"));
        Tool tool = new Tool(new File(specDir).getAbsolutePath(), tlaProgramFile, configFile, (FilenameToStream)resolver);
        SpecObj spec = tool.init(true, null);
        FileUtil.makeMetaDir((String)specDir, null);
        TLATransitionRelation runtime = new TLATransitionRelation();
        runtime.tool = tool;
        runtime.actions = tool.getActions();
        return new LanguageModule((ITransitionRelation)runtime, (IAtomicPropositionsEvaluator)new TLAAtomicPropositionsEvaluator(runtime), (ITreeProjector)new TLARuntimeView());
    }
}

