/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.util.ObjLongTable;
import tlc2.value.MVPerm;
import tlc2.value.Value;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import util.UniqueString;
import util.WrongInvocationException;

public final class TLCStateMutSource
extends TLCState
implements Cloneable,
Serializable {
    private Value[] values;
    private SemanticNode[] asts;
    private static Tool mytool = null;
    private static SemanticNode viewMap = null;
    private static MVPerm[] perms = null;

    private TLCStateMutSource(Value[] vals, SemanticNode[] asts) {
        this.values = vals;
        this.asts = asts;
    }

    public static void init(Tool tool) {
        mytool = tool;
        Value[] vals = new Value[vars.length];
        SemanticNode[] snodes = new SemanticNode[vars.length];
        Empty = new TLCStateMutSource(vals, snodes);
        viewMap = tool.getViewSpec();
        perms = tool.getSymmetryPerms();
    }

    @Override
    public final TLCState createEmpty() {
        int sz = vars.length;
        return new TLCStateMutSource(new Value[sz], new SemanticNode[sz]);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TLCStateMutSource) {
            TLCStateMutSource state = (TLCStateMutSource)obj;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] == null ? state.values[i] != null : state.values[i] == null || !this.values[i].equals(state.values[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final TLCState bind(UniqueString name, Value value, SemanticNode ast) {
        int loc = name.getVarLoc();
        this.values[loc] = value;
        if (this.asts != null) {
            this.asts[loc] = ast;
        }
        return this;
    }

    @Override
    public final TLCState bind(SymbolNode id, Value value, SemanticNode expr) {
        throw new WrongInvocationException("TLCStateMutSource.bind: This is a TLC bug.");
    }

    @Override
    public final TLCState unbind(UniqueString name) {
        int loc = name.getVarLoc();
        this.values[loc] = null;
        this.asts[loc] = null;
        return this;
    }

    @Override
    public final Value lookup(UniqueString var) {
        int loc = var.getVarLoc();
        if (loc < 0) {
            return null;
        }
        return this.values[loc];
    }

    @Override
    public final boolean containsKey(UniqueString var) {
        return this.lookup(var) != null;
    }

    @Override
    public final TLCState copy() {
        int len = this.values.length;
        Value[] vals = new Value[len];
        SemanticNode[] astClone = new SemanticNode[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.values[i];
            astClone[i] = this.asts[i];
        }
        return new TLCStateMutSource(vals, astClone);
    }

    @Override
    public final TLCState deepCopy() {
        int len = this.values.length;
        Value[] vals = new Value[len];
        SemanticNode[] astClone = new SemanticNode[len];
        for (int i = 0; i < len; ++i) {
            Value val = this.values[i];
            if (val == null) continue;
            vals[i] = val.deepCopy();
            astClone[i] = this.asts[i];
        }
        return new TLCStateMutSource(vals, astClone);
    }

    @Override
    public final StateVec addToVec(StateVec states) {
        return states.addElement(this.copy());
    }

    @Override
    public final void deepNormalize() {
        for (int i = 0; i < this.values.length; ++i) {
            Value val = this.values[i];
            if (val == null) continue;
            val.deepNormalize();
        }
    }

    private final void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.values = (Value[])ois.readObject();
        this.asts = null;
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.values);
    }

    @Override
    public final long fingerPrint() {
        int i;
        int sz = this.values.length;
        Value[] minVals = this.values;
        if (perms != null) {
            Value[] vals = new Value[sz];
            for (int i2 = 0; i2 < perms.length; ++i2) {
                int cmp = 0;
                for (int j = 0; j < sz; ++j) {
                    vals[j] = this.values[j].permute(perms[i2]);
                    if (cmp != 0) continue;
                    cmp = vals[j].compareTo(minVals[j]);
                }
                if (cmp >= 0) continue;
                if (minVals == this.values) {
                    minVals = vals;
                    vals = new Value[sz];
                    continue;
                }
                Value[] temp = minVals;
                minVals = vals;
                vals = temp;
            }
        }
        long fp = FP64.New();
        if (viewMap == null) {
            for (i = 0; i < sz; ++i) {
                fp = minVals[i].fingerPrint(fp);
            }
            if (this.values != minVals) {
                for (i = 0; i < sz; ++i) {
                    this.values[i].deepNormalize();
                }
            }
        } else {
            for (i = 0; i < sz; ++i) {
                this.values[i].deepNormalize();
            }
            TLCStateMutSource state = this;
            if (minVals != this.values) {
                state = new TLCStateMutSource(minVals, this.asts);
            }
            Value val = mytool.eval(viewMap, Context.Empty, state);
            fp = val.fingerPrint(fp);
        }
        return fp;
    }

    public final void addCounts(ObjLongTable counts) {
        for (int i = 0; i < this.asts.length; ++i) {
            counts.add(this.asts[i], 1L);
        }
    }

    @Override
    public final boolean allAssigned() {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Set<OpDeclNode> getUnassigned() {
        TreeSet<OpDeclNode> unassignedVars = new TreeSet<OpDeclNode>(new Comparator<OpDeclNode>(){

            @Override
            public int compare(OpDeclNode o1, OpDeclNode o2) {
                return o1.getName().toString().compareTo(o2.getName().toString());
            }
        });
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            unassignedVars.add(vars[i]);
        }
        return unassignedVars;
    }

    @Override
    public final void read(ValueInputStream vis) throws IOException {
        super.read(vis);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = vis.read();
        }
    }

    @Override
    public final void write(ValueOutputStream vos) throws IOException {
        super.write(vos);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            vos.write(this.values[i]);
        }
    }

    @Override
    public final String toString() {
        if (TLCGlobals.useView && viewMap != null) {
            Value val = mytool.eval(viewMap, Context.Empty, this);
            return viewMap.toString(val);
        }
        StringBuffer result = new StringBuffer();
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            Value val = this.lookup(key);
            result.append(key.toString());
            result.append(" = ");
            result.append(Value.ppr(val));
            result.append("\n");
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                Value val = this.lookup(key);
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = ");
                result.append(Value.ppr(val));
                result.append("\n");
            }
        }
        return result.toString();
    }

    @Override
    public final String toString(TLCState lastState) {
        StringBuffer result = new StringBuffer();
        TLCStateMutSource lstate = (TLCStateMutSource)lastState;
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            Value val = this.lookup(key);
            Value lstateVal = lstate.lookup(key);
            if (val == null || !val.equals(lstateVal)) {
                result.append(key.toString());
                result.append(" = " + Value.ppr(val) + "\n");
            }
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                Value val = this.lookup(key);
                Value lstateVal = lstate.lookup(key);
                if (val != null && val.equals(lstateVal)) continue;
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = " + Value.ppr(val) + "\n");
            }
        }
        return result.toString();
    }
}

