/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.TLA.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.language.TLA.runtime.TLAConfiguration;
import obp2.runtime.core.IConcurrentTransitionRelation;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.utils.Pair;
import tla2sany.semantic.ExprNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;

public class TLATransitionRelation
extends DefaultLanguageService<TLAConfiguration, Pair<Action, StateVec>, Void>
implements ITransitionRelation<TLAConfiguration, Pair<Action, StateVec>, Void>,
IConcurrentTransitionRelation<TLATransitionRelation, TLAConfiguration, Pair<Action, StateVec>, Void> {
    public Tool tool;
    public Action[] actions;

    public boolean checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                MP.printError((int)2104, (String)assumps[i].toString());
                return false;
            }
            catch (Exception e) {
                MP.printError((int)2105, (String[])new String[]{assumps[i].toString(), e.getMessage()});
                return false;
            }
        }
        return true;
    }

    public Set<TLAConfiguration> initialConfigurations() {
        if (!this.checkAssumptions()) {
            return Collections.emptySet();
        }
        StateVec theInitStates = this.tool.getInitStates();
        HashSet<TLAConfiguration> result = new HashSet<TLAConfiguration>();
        for (int i = 0; i < theInitStates.size(); ++i) {
            TLCState currentState = theInitStates.elementAt(i);
            if (!this.tool.isGoodState(currentState)) {
                MP.printError((int)2102, (String)currentState.toString());
                return Collections.emptySet();
            }
            boolean inModel = this.tool.isInModel(currentState);
            if (!inModel) continue;
            TLAConfiguration config = new TLAConfiguration();
            config.state = currentState;
            result.add(config);
        }
        return result;
    }

    public List<Pair<Action, StateVec>> fireableTransitionsFrom(TLAConfiguration configuration) {
        ArrayList<Pair<Action, StateVec>> fireables = new ArrayList<Pair<Action, StateVec>>();
        for (Action currentAction : this.actions) {
            StateVec nextStates = this.tool.getNextStates(currentAction, configuration.state);
            if (nextStates.empty()) continue;
            fireables.add((Pair<Action, StateVec>)new Pair((Object)currentAction, (Object)nextStates));
        }
        return fireables;
    }

    public IFiredTransition<TLAConfiguration, Pair<Action, StateVec>, Void> fireOneTransition(TLAConfiguration source, Pair<Action, StateVec> fireable) {
        HashSet<TLAConfiguration> reachedTargets = new HashSet<TLAConfiguration>(((StateVec)fireable.b).size());
        for (int stateID = 0; stateID < ((StateVec)fireable.b).size(); ++stateID) {
            boolean inModel;
            TLCState nextState = ((StateVec)fireable.b).elementAt(stateID);
            if (!this.tool.isGoodState(nextState)) {
                MP.printError((int)2102, (String)nextState.toString());
                return null;
            }
            boolean bl = inModel = this.tool.isInModel(nextState) && this.tool.isInActions(source.state, nextState);
            if (!inModel) continue;
            TLAConfiguration config = new TLAConfiguration();
            config.state = nextState;
            reachedTargets.add(config);
        }
        return new FiredTransition((Object)source, reachedTargets, fireable, null);
    }

    public TLATransitionRelation createCopy() {
        TLATransitionRelation runtime = new TLATransitionRelation();
        runtime.tool = this.tool;
        runtime.actions = this.tool.getActions();
        return runtime;
    }
}

