/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.PrintStream;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraph;
import tlc2.util.BitVector;

public class OrderOfSolution {
    private final TBGraph tableau;
    private final LNEven[] promises;
    private LiveExprNode[] checkState;
    private LiveExprNode[] checkAction;
    private PossibleErrorModel[] pems;
    private final Tool tool;

    public OrderOfSolution(LNEven[] livenessEventually, Tool aTool) {
        this(null, livenessEventually, aTool);
    }

    public OrderOfSolution(TBGraph aTableau, LNEven[] livenessEventually, Tool aTool) {
        this.tableau = aTableau;
        this.promises = livenessEventually;
        this.tool = aTool;
    }

    public final void printPromises(PrintStream ps) {
        for (int i = 0; i < this.getPromises().length; ++i) {
            ps.println(this.getPromises()[i].toString());
        }
    }

    public final String toString() {
        if (this.getPems().length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    public final void toString(StringBuffer sb) {
        String padding = "";
        int plen = this.getPems().length;
        if (this.hasTableau()) {
            if (plen == 1 && this.getPems()[0].isEmpty()) {
                this.getTableau().tf.toString(sb, "   ");
                return;
            }
            sb.append("/\\ ");
            this.getTableau().tf.toString(sb, "   ");
            sb.append("\n/\\ ");
            padding = "   ";
        }
        if (plen == 1) {
            this.getPems()[0].toString(sb, padding, this.checkState, this.getCheckAction());
        } else {
            sb.append("\\/ ");
            String padding1 = padding + "   ";
            this.getPems()[0].toString(sb, padding1, this.checkState, this.getCheckAction());
            for (int i = 1; i < plen; ++i) {
                sb.append(padding + "\\/ ");
                this.getPems()[i].toString(sb, padding1, this.checkState, this.getCheckAction());
            }
        }
    }

    public TBGraph getTableau() {
        return this.tableau;
    }

    public boolean hasTableau() {
        return this.tableau != null;
    }

    public LNEven[] getPromises() {
        return this.promises;
    }

    public LiveExprNode[] getCheckState() {
        return this.checkState;
    }

    public boolean[] checkState(TLCState state) {
        boolean[] result = new boolean[this.checkState.length];
        for (int i = 0; i < this.checkState.length; ++i) {
            result[i] = this.checkState[i].eval(this.tool, state, null);
        }
        return result;
    }

    void setCheckState(LiveExprNode[] checkState) {
        this.checkState = checkState;
    }

    public boolean[] checkAction(TLCState state0, TLCState state1) {
        boolean[] result = new boolean[this.checkAction.length];
        for (int i = 0; i < this.checkAction.length; ++i) {
            result[i] = this.checkAction[i].eval(this.tool, state0, state1);
        }
        return result;
    }

    public BitVector checkAction(TLCState state0, TLCState state1, BitVector result, int offset) {
        for (int i = 0; i < this.checkAction.length; ++i) {
            if (!this.checkAction[i].eval(this.tool, state0, state1)) continue;
            result.set(offset + i);
        }
        return result;
    }

    public LiveExprNode[] getCheckAction() {
        return this.checkAction;
    }

    void setCheckAction(LiveExprNode[] checkAction) {
        this.checkAction = checkAction;
    }

    public PossibleErrorModel[] getPems() {
        return this.pems;
    }

    void setPems(PossibleErrorModel[] pems) {
        this.pems = pems;
    }
}

