/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tla2sany.semantic.SemanticNode;
import tlc2.value.Value;

public class FingerprintException
extends RuntimeException {
    public final Value value;
    public final FingerprintException next;

    private FingerprintException(Throwable initCauseThrowable, Value value, FingerprintException next) {
        this.initCause(initCauseThrowable);
        this.value = value;
        this.next = next;
    }

    public static FingerprintException getNewHead(Value v, Throwable t) {
        FingerprintException fpe = null;
        fpe = t instanceof FingerprintException ? ((FingerprintException)t).prependNewHead(v) : FingerprintException.createNewHead(v, t);
        return fpe;
    }

    private static FingerprintException createNewHead(Value value, Throwable initCauseThrowable) {
        if (value == null || initCauseThrowable == null) {
            return null;
        }
        return new FingerprintException(initCauseThrowable, value, null);
    }

    private FingerprintException prependNewHead(Value value) {
        if (value == null) {
            return null;
        }
        return new FingerprintException(null, value, this);
    }

    public Throwable getRootCause() {
        FingerprintException nextFPE = this;
        while (nextFPE.next != null) {
            nextFPE = nextFPE.next;
        }
        return nextFPE.getCause();
    }

    public String getTrace() {
        return this.getTraceImpl(0, null);
    }

    private String getTraceImpl(int traceIndexLabel, Integer lastSemanticNodeUid) {
        SemanticNode semanticNode = this.value.getSource();
        if (semanticNode == null) {
            if (this.next == null) {
                return "";
            }
            return this.next.getTraceImpl(traceIndexLabel, lastSemanticNodeUid);
        }
        Integer semanticNodeUid = semanticNode.getUid();
        if (semanticNodeUid.equals(lastSemanticNodeUid)) {
            if (this.next == null) {
                return "";
            }
            return this.next.getTraceImpl(traceIndexLabel, lastSemanticNodeUid);
        }
        String description = traceIndexLabel + ") " + semanticNode.toString() + "\n";
        if (this.next == null) {
            return description;
        }
        return this.next.getTraceImpl(traceIndexLabel + 1, semanticNodeUid) + description;
    }
}

