/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class UseOrHideNode
extends LevelNode {
    public LevelNode[] facts = null;
    public SymbolNode[] defs = null;
    public boolean isOnly;
    private UniqueString stepName = null;

    public void setStepName(UniqueString stepName) {
        this.stepName = stepName;
    }

    public UniqueString getStepName() {
        return this.stepName;
    }

    public UseOrHideNode(int kind, TreeNode stn, LevelNode[] theFacts, SymbolNode[] theDefs, boolean only) {
        super(kind, stn);
        this.facts = theFacts;
        this.defs = theDefs;
        this.isOnly = only;
    }

    public void factCheck() {
        if (this.facts == null || this.getKind() == 31) {
            return;
        }
        for (int i = 0; i < this.facts.length; ++i) {
            if (this.facts[i].getKind() != 9 || ((OpApplNode)this.facts[i]).operator.getKind() == 23) continue;
            errors.addError(this.facts[i].stn.getLocation(), "The only expression allowed as a fact in a HIDE is \nthe name of a theorem, assumption, or step.");
        }
    }

    @Override
    public boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        return this.levelCheckSubnodes(iter, this.facts);
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        for (int i = 0; i < this.facts.length; ++i) {
            this.facts[i].walkGraph(semNodesTable);
        }
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.facts == null || this.facts.length == 0) {
            return null;
        }
        SemanticNode[] res = new SemanticNode[this.facts.length];
        for (int i = 0; i < this.facts.length; ++i) {
            res[i] = this.facts[i];
        }
        return res;
    }

    @Override
    public String toString(int depth) {
        int i;
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*UseOrHideNode:\n" + super.toString(depth) + Strings.indent(2, "\nisOnly: " + this.isOnly) + Strings.indent(2, "\nfacts:");
        for (i = 0; i < this.facts.length; ++i) {
            ret = ret + Strings.indent(4, this.facts[i].toString(1));
        }
        ret = ret + Strings.indent(2, "\ndefs:");
        for (i = 0; i < this.defs.length; ++i) {
            ret = ret + Strings.indent(4, this.defs[i].toString(1));
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        int i;
        Element e = doc.createElement("UseOrHideNode");
        Element factse = doc.createElement("facts");
        Element definitions = doc.createElement("defs");
        for (i = 0; i < this.facts.length; ++i) {
            factse.appendChild(this.facts[i].export(doc, context));
        }
        for (i = 0; i < this.defs.length; ++i) {
            definitions.appendChild(this.defs[i].export(doc, context));
        }
        e.appendChild(factse);
        e.appendChild(definitions);
        if (this.isOnly) {
            e.appendChild(doc.createElement("only"));
        }
        if (this.getKind() == 32) {
            e.appendChild(doc.createElement("hide"));
        }
        return e;
    }
}

