/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;

public class IntValue
extends Value {
    private static final IntValue[] cache = new IntValue[10];
    public int val;

    private IntValue(int i) {
        this.val = i;
    }

    @Override
    public final byte getKind() {
        return 1;
    }

    public static final int nbits(int tmp) {
        int nb = 0;
        while (tmp != 0 && tmp != -1) {
            ++nb;
            tmp >>= 1;
        }
        return nb + 1;
    }

    public final int nbits() {
        try {
            return IntValue.nbits(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static IntValue gen(int i) {
        if (i >= 0 && i < cache.length) {
            return cache[i];
        }
        return new IntValue(i);
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof IntValue) {
                return this.val - ((IntValue)obj).val;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare integer " + IntValue.ppr(this.toString()) + " with non-integer:\n" + IntValue.ppr(obj.toString()));
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof IntValue) {
                return this.val == ((IntValue)obj).val;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to check equality of integer " + IntValue.ppr(this.toString()) + " with non-integer:\n" + IntValue.ppr(obj.toString()));
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + IntValue.ppr(elem.toString()) + "\nis an element of the integer " + IntValue.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the integer " + IntValue.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to appy EXCEPT construct to the integer " + IntValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the integer " + IntValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the integer " + IntValue.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof IntValue && this.val == ((IntValue)val).val;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            return FP64.Extend(FP64.Extend(fp, (byte)1), this.val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            return sb.append(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            IntValue.cache[i] = new IntValue(i);
        }
    }
}

