/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Literal;

public abstract class CollectionLit
implements Literal {
    private final List<Expression> valueList = new ArrayList<Expression>();

    public List<Expression> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public Expression getValue(int index) {
        if (index < 0 || index >= this.getValueCount()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public void addValue(Expression newValue) {
        this.addValue(this.getValueCount(), newValue);
    }

    public void addValue(int index, Expression newValue) {
        this.valueList.add(index, newValue);
    }

    public Expression setValue(int index, Expression newValue) {
        return this.valueList.set(index, newValue);
    }

    public void addAllValue(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addValue(this.getValueCount(), newValue);
        }
    }

    public void removeValue(Expression value) {
        int index = this.valueList.indexOf(value);
        if (index >= 0) {
            this.removeValue(index);
        }
    }

    public void removeValue(int index) {
        this.valueList.remove(index);
    }

    @Override
    public abstract void accept(ABCDVisitor var1);

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof CollectionLit)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((CollectionLit)that, cache);
    }

    protected boolean equalsFeatures(CollectionLit that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        l1size = this.valueList.size();
        if (l1size != (l2size = that.valueList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.valueList.get(i).equalsCached(that.valueList.get(i), cache)) continue;
            return false;
        }
        return true;
    }
}

