/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import obp.cdl.EventDeclaration;
import obp.cdl.EventReference;
import obp.cdl.parser.CDLLexer;
import obp.cdl.parser.CDLParser;
import obp.event.Event;
import obp.event.EventVisitor;
import obp.event.GammaEvent;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Output;
import obp.event.PredicateEvent;
import obp.event.Signal;
import obp.event.Synchronous;
import obp.event.Value;
import obp.literal.Literal;
import obp.predicate.LogicOperator;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.util.CDLUtil;
import obp.util.LiteralUtil;
import obp.util.PredicateUtil;

public class EventUtilPromela
implements EventVisitor {
    public static final String anonymousName = "*anonymous*";
    private final StringBuilder string = new StringBuilder();

    public static String printEvent(Event event) {
        EventUtilPromela eventUtil = new EventUtilPromela();
        event.accept(eventUtil);
        return eventUtil.string.toString();
    }

    public static EventReference createAnonymousEventReference(Event is) {
        EventDeclaration declaration = new EventDeclaration();
        declaration.setName(anonymousName);
        declaration.setIs(is);
        EventReference reference = new EventReference();
        reference.setName(anonymousName);
        reference.setReference(declaration);
        return reference;
    }

    public static Event read(String source) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(source.getBytes("UTF-8")));
        CDLLexer lexer = new CDLLexer(in);
        CDLParser parser = new CDLParser();
        Event event = null;
        try {
            event = (Event)parser.parse(lexer, (short)83);
        }
        catch (RuntimeException e) {
            throw new Exception(e.getMessage());
        }
        ((InputStream)in).close();
        return event;
    }

    private EventUtilPromela() {
    }

    @Override
    public void visitInput(Input toVisit) {
        this.string.append("toContext? ");
        toVisit.getMessage().accept(this);
        this.string.append(";");
    }

    @Override
    public void visitOutput(Output toVisit) {
        this.string.append("fromContext! ");
        toVisit.getMessage().accept(this);
        this.string.append(";");
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
        this.string.append("sync ");
        toVisit.getMessage().accept(this);
        this.string.append(" from ");
        this.string.append(CDLUtil.toString(toVisit.getFrom()));
        this.string.append(" to ");
        this.string.append(CDLUtil.toString(toVisit.getTo()));
    }

    @Override
    public void visitPredicateEvent(PredicateEvent toVisit) {
        LogicPredicate logicPredicate;
        String value = "true";
        Predicate predicate = toVisit.getPredicate();
        if (predicate instanceof LogicPredicate && (logicPredicate = (LogicPredicate)predicate).getOperator() == LogicOperator.NOT) {
            predicate = logicPredicate.getLeft();
            value = "false";
        }
        this.string.append(PredicateUtil.printPredicate(predicate));
        this.string.append(" becomes ");
        this.string.append(value);
    }

    @Override
    public void visitGammaEvent(GammaEvent toVisit) {
        this.string.append("gamma");
    }

    @Override
    public void visitInformal(Informal toVisit) {
        this.string.append("#");
        this.string.append(toVisit.getTag());
        this.string.append("#");
        if (toVisit.getFrom() != null) {
            this.string.append(" from ");
            this.string.append(CDLUtil.toString(toVisit.getFrom()));
        }
    }

    @Override
    public void visitSignal(Signal toVisit) {
        this.string.append(CDLUtil.toString(toVisit.getPid()));
        this.string.append(":");
        this.string.append(toVisit.getName());
        this.string.append("(");
        int length = this.string.length();
        for (Literal argument : toVisit.getArgumentList()) {
            if (this.string.length() > length) {
                this.string.append(",");
            }
            this.string.append(LiteralUtil.print(argument));
        }
        this.string.append(")");
    }

    @Override
    public void visitValue(Value toVisit) {
        this.string.append(LiteralUtil.print(toVisit.getLiteral()));
    }
}

