/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try0;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.ffi.try0.Java2JniTypeExtractor;
import obp.fiacre.ffi.try0.TCValues2Fiacre;
import obp.fiacre.ffi.try0.TFiacre2CValues;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.Field;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;

public class FFIBindingGenerator {
    public boolean hasArray = false;
    static List<StringBuilder> functions = new ArrayList<StringBuilder>();
    private static String unloadFunctionString = null;
    StringBuilder functionCode;
    ExternalFunctionDecl currentFunction;
    protected final ProgramGenerator caller;
    static List<String> includeList = new ArrayList<String>();
    public static int currentIdx;

    public static void writeBindingsToFile(File f) {
        try {
            File theFile = new File(f, "../bindings/ffi_bindings.c");
            theFile.getParentFile().mkdir();
            theFile.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(theFile));
            FFIBindingGenerator.emitIncludes(bw);
            FFIBindingGenerator.emitGlobals(bw, f);
            for (StringBuilder fctCode : functions) {
                bw.append(fctCode);
            }
            bw.append(unloadFunctionString);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FFIBindingGenerator(ProgramGenerator caller) {
        this.caller = caller;
        unloadFunctionString = this.jniUnloadFunction();
    }

    public void generateBindings(ExternalFunctionDecl externalFctDecl) throws Exception {
        this.currentFunction = externalFctDecl;
        this.functionCode = new StringBuilder();
        functions.add(this.functionCode);
        this.emitJNIFunctionHeader();
    }

    void emitJNIFunctionHeader() throws Exception {
        StringBuilder typesCode = new StringBuilder();
        String header = this.jniFunctionHeader();
        String body = this.jniFunctionBody(typesCode);
        this.functionCode.append(typesCode + "\n");
        this.functionCode.append(header + "{\n");
        this.functionCode.append(body + "\n");
        this.functionCode.append("}\n");
    }

    static void standardIncludes() {
        includeList.add("stdlib.h");
        includeList.add("jni.h");
        includeList.add("common/loader.h");
        includeList.add("common/helpers.h");
    }

    static void emitIncludes(BufferedWriter str) throws IOException {
        FFIBindingGenerator.standardIncludes();
        for (String fn : includeList) {
            str.append("#include <" + fn + ">\n");
        }
        str.append("\n\n");
    }

    static void emitGlobals(BufferedWriter str, File packagePath) throws IOException {
        str.append("void *gLibHandle = NULL;\n");
        str.append("char gLibPath[] = \"" + packagePath + "/../../client/libclientprimitives.dylib\";\n");
        str.append("jclass gExceptionClass = NULL;\n");
    }

    private String jniFunctionHeader() {
        return "JNIEXPORT " + this.getJniReturnType() + " JNICALL " + this.jniFunctionName() + "(JNIEnv * env, jclass cls, jobject obj)";
    }

    private String jniUnloadFunction() {
        return "JNIEXPORT void JNICALL " + this.jniFunctionNamed("UnloadLibrary") + "(JNIEnv * env, jobject obj) {unloadLibrary(gLibHandle);}\n";
    }

    private String getJniReturnType() {
        Java2JniTypeExtractor visitor = new Java2JniTypeExtractor();
        this.currentFunction.getReturnType().accept(visitor);
        this.hasArray |= visitor.isArray;
        return visitor.jniType;
    }

    String jniFunctionName() {
        return this.jniFunctionNamed(this.currentFunction.getName());
    }

    String jniFunctionNamed(String name) {
        return "Java_" + this.caller.packageName + "_" + this.caller.getProgramName() + "_prim" + name;
    }

    String typeSignature(Type type) {
        return "I";
    }

    Type synthesizeArgumentType() {
        Record rec = new Record();
        int idx = 0;
        for (ExternalArgument eArg : this.currentFunction.getArgList()) {
            Field field = new Field();
            field.setName("arg" + idx++);
            field.setType(eArg.getType());
            rec.addField(field);
        }
        return rec;
    }

    String jniFunctionBody(StringBuilder typesCode) throws Exception {
        TFiacre2CValues marshaller = null;
        StringBuilder body = new StringBuilder();
        if (this.currentFunction.getArgCount() > 0) {
            Type singleArgType = this.synthesizeArgumentType();
            marshaller = new TFiacre2CValues(this.caller.packageName, "obj", singleArgType, currentIdx);
            singleArgType.accept(marshaller);
            if (marshaller.errorStatus) {
                throw new Exception("FFI marshaling error");
            }
            currentIdx = marshaller.idx;
            body.append((CharSequence)marshaller.codeStream);
        }
        body.append("\t" + this.getJniReturnType() + " (*fctHandle)();\n");
        body.append("\tLOAD_FCT(" + this.currentFunction.getExternalName() + ")\n");
        body.append("\t" + this.getJniReturnType() + " result;\n");
        body.append("\tresult = (*fctHandle)(");
        int idx = 0;
        for (ExternalArgument eArg : this.currentFunction.getArgList()) {
            if (eArg.isWrite()) {
                body.append("&");
            }
            body.append(marshaller.valueNameMap.get(eArg.getType()));
            if (++idx >= this.currentFunction.getArgCount()) continue;
            body.append(", ");
        }
        body.append(");\n");
        TCValues2Fiacre unmarshaller = new TCValues2Fiacre();
        unmarshaller.field2indexName = marshaller.field2indexName;
        unmarshaller.fieldIndex2objectName = marshaller.fieldIndex2objectName;
        unmarshaller.cvalueNameMap = marshaller.valueNameMap;
        for (ExternalArgument eArg : this.currentFunction.getArgList()) {
            if (!eArg.isWrite()) continue;
            eArg.getType().accept(unmarshaller);
        }
        body.append(unmarshaller.code.toString());
        unmarshaller.code = new StringBuilder();
        unmarshaller.isReturn = true;
        this.currentFunction.getReturnType().accept(unmarshaller);
        body.append(unmarshaller.code.toString());
        return body.toString();
    }
}

