/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.serializer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class JBoost
implements Boost {
    protected static final String Separators = "[]{} :";
    protected Writer writer;
    protected Reader reader;
    protected final ArrayList<BoostObject> readObjetIndex = new ArrayList();
    protected final LinkedHashMap<BoostObject, Integer> writeObjetIndex = new LinkedHashMap();
    protected final HashMap<Class<? extends BoostObject>, Integer> classIndex = new HashMap();
    protected final String type;
    protected final int version;
    protected int fileVersion;
    protected ErrorHandler errorHandler = ErrorHandler.simple;
    protected Map<String, String> boostNameToClassName = null;
    private final ClassLoader classLoader;
    protected boolean eof = false;
    protected char lookAheadChar = '\u0000';

    public JBoost(String type, int version, ClassLoader classLoader) {
        this.type = type;
        this.version = version;
        this.classLoader = classLoader;
    }

    public JBoost(String type, int version) {
        this(type, version, JBoost.class.getClassLoader());
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void register(BoostObject object) {
        this.readObjetIndex.add(object);
    }

    public void addBoostNameToClassName(String boostName, String className) {
        if (this.boostNameToClassName == null) {
            this.boostNameToClassName = new HashMap<String, String>();
        }
        this.boostNameToClassName.put(boostName, className);
    }

    public void initializeZippedWriting(ZipOutputStream stream, String entryName) {
        ZipEntry entry = new ZipEntry(entryName);
        try {
            stream.putNextEntry(entry);
        }
        catch (IOException e) {
            this.getErrorHandler().handleError(2, DiagnosticUtil.createMessage(e));
            return;
        }
        this.initializeWriting(stream);
    }

    public void initializeZippedReading(ZipInputStream stream, String entryName) {
        ZipEntry entry = null;
        try {
            entry = stream.getNextEntry();
            while (entry != null && !entryName.equals(entry.getName())) {
                entry = stream.getNextEntry();
            }
        }
        catch (IOException e) {
            this.getErrorHandler().handleError(2, DiagnosticUtil.createMessage(e));
            return;
        }
        if (entry == null) {
            this.getErrorHandler().handleError(2, "No entry named '" + entryName + "' in zipped stream.");
            return;
        }
        this.initializeReading(stream);
    }

    public void initializeWriting(OutputStream stream) {
        this.writeObjetIndex.clear();
        this.classIndex.clear();
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(stream, this.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        this.writeHeader();
    }

    public void initializeReading(InputStream stream) {
        this.readObjetIndex.clear();
        this.classIndex.clear();
        try {
            this.reader = new BufferedReader(new InputStreamReader(stream, this.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        this.basicReadChar();
        this.readHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.errorHandler.handleError(2, "I/O exception: " + e.getMessage());
            }
            finally {
                this.writer = null;
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.errorHandler.handleError(2, "I/O exception: " + e.getMessage());
            }
            this.reader = null;
        }
    }

    protected String getEncoding() {
        return "UTF-8";
    }

    protected Locale getLocale() {
        return Locale.ENGLISH;
    }

    protected String getFormatMagic() {
        return "XidFile";
    }

    protected int getFormatVersion() {
        return 1;
    }

    protected void writeHeader() {
        this.basicWriteString(this.getFormatMagic() + " " + this.getFormatVersion() + " ");
        this.writeString(this.type);
        this.writeInt(this.version);
        this.fileVersion = this.version;
    }

    protected void readHeader() {
        String magic = this.nextToken();
        if (!this.getFormatMagic().equals(magic)) {
            this.errorHandler.handleError(2, "Wrong format type: " + magic + ", it should be " + this.getFormatMagic());
            return;
        }
        this.readToken(" ");
        this.fileVersion = this.readInt();
        if (this.getFormatVersion() < this.fileVersion) {
            this.errorHandler.handleError(2, "Can't read version " + this.fileVersion + " file with version " + this.getFormatVersion() + " reader.");
            return;
        }
        String currentType = this.readString();
        if (!this.type.equals(currentType)) {
            this.errorHandler.handleError(2, "Wrong file type: " + currentType + ", it should be " + this.type);
            return;
        }
        this.fileVersion = this.readInt();
    }

    @Override
    public void writeBoolean(boolean b) {
        this.basicWriteString(b ? "t " : "f ");
    }

    @Override
    public boolean readBoolean() {
        boolean result = this.nextToken().equals("t");
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeDouble(double d) {
        this.basicWriteString(String.valueOf(d));
        this.basicWriteString(" ");
    }

    @Override
    public double readDouble() {
        double result = Double.valueOf(this.nextToken());
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeFloat(float f) {
        this.basicWriteString(String.valueOf(f));
        this.basicWriteString(" ");
    }

    @Override
    public float readFloat() {
        float result = Float.valueOf(this.nextToken()).floatValue();
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeByte(byte b) {
        this.basicWriteString(String.valueOf(b));
        this.basicWriteString(" ");
    }

    @Override
    public byte readByte() {
        byte result = Byte.valueOf(this.nextToken());
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeShort(short s) {
        this.basicWriteString(String.valueOf(s));
        this.basicWriteString(" ");
    }

    @Override
    public short readShort() {
        short result = Short.valueOf(this.nextToken());
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeInt(int i) {
        this.basicWriteString(String.valueOf(i));
        this.basicWriteString(" ");
    }

    @Override
    public int readInt() {
        int result = Integer.valueOf(this.nextToken());
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeLong(long l) {
        this.basicWriteString(String.valueOf(l));
        this.basicWriteString(" ");
    }

    @Override
    public long readLong() {
        long result = Long.valueOf(this.nextToken());
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeObject(BoostObject obj) {
        if (obj == null) {
            this.basicWriteString("n ");
            return;
        }
        this.basicWriteString("{");
        if (this.writeObjetIndex.containsKey(obj)) {
            this.basicWriteString(this.writeObjetIndex.get(obj).toString());
        } else {
            int index = this.writeObjetIndex.size();
            this.writeObjetIndex.put(obj, index);
            this.basicWriteString(String.valueOf(index));
            this.basicWriteString(" ");
            this.writeClass(obj.getClass());
            obj.writeToBoost(this);
        }
        this.basicWriteString("} ");
    }

    @Override
    public <T extends BoostObject> T readObject(Class<T> objectClass) {
        String token = this.nextToken();
        if (token.equals("n")) {
            this.readToken(" ");
            return null;
        }
        if (token.charAt(0) == '!') {
            int size = Integer.valueOf(token.substring(1));
            this.readToken(":");
            String result = this.readNCharacters(size);
            this.readToken(" ");
            return this.resolveReference(result, objectClass);
        }
        token = this.nextToken();
        int objectId = Integer.valueOf(token);
        token = this.nextToken();
        BoostObject result = null;
        if (token.equals(" ")) {
            Class<T> objectRealClass = this.readClass(objectClass);
            try {
                Constructor<T> constructor = objectRealClass.getDeclaredConstructor(Boost.class);
                constructor.setAccessible(true);
                result = (BoostObject)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.errorHandler.handleError(2, DiagnosticUtil.createMessage(e));
                return (T)result;
            }
            this.readToken("}");
        } else {
            if (objectId < this.readObjetIndex.size()) {
                result = (BoostObject)objectClass.cast(this.readObjetIndex.get(objectId));
            }
            if (result == null) {
                this.errorHandler.handleError(2, "Object id " + objectId + " doesn't exist");
                return null;
            }
        }
        this.readToken(" ");
        return (T)result;
    }

    protected void writeClass(Class<? extends BoostObject> oneClass) {
        if (this.classIndex.containsKey(oneClass)) {
            this.basicWriteString("[");
            this.basicWriteString(this.classIndex.get(oneClass).toString());
            this.basicWriteString("] ");
            return;
        }
        int index = this.classIndex.size();
        this.classIndex.put(oneClass, index);
        String className = this.getClassBoostNameMap().get(oneClass);
        if (className == null) {
            className = this.createClassName(oneClass);
        }
        this.basicWriteString("[");
        this.basicWriteString(String.valueOf(index));
        this.basicWriteString(" ");
        this.basicWriteString(className);
        this.basicWriteString("] ");
    }

    private String createClassName(Class<?> clazz) {
        Class<?> declaringClass = clazz.getDeclaringClass();
        if (declaringClass != null) {
            StringBuilder className = new StringBuilder();
            className.append(this.createClassName(declaringClass));
            className.append("$");
            className.append(clazz.getSimpleName());
            return className.toString();
        }
        return clazz.getCanonicalName();
    }

    protected <T extends BoostObject> Class<? extends T> readClass(Class<T> parentClass) {
        Class<? extends BoostObject> result = null;
        this.readToken("[");
        int classId = Integer.valueOf(this.nextToken());
        if (this.classIndex.containsValue(classId)) {
            for (Map.Entry<Class<? extends BoostObject>, Integer> entry : this.classIndex.entrySet()) {
                if (entry.getValue() != classId) continue;
                result = entry.getKey();
                break;
            }
        } else {
            this.readToken(" ");
            String boostClassName = this.nextToken();
            result = this.findClass(boostClassName);
            this.classIndex.put(result, this.classIndex.size());
        }
        if (!parentClass.isAssignableFrom(result)) {
            this.errorHandler.handleError(2, "Excepting for class " + parentClass.getSimpleName() + " but read incompatible class " + result.getSimpleName() + ".");
            return null;
        }
        this.readToken("]");
        this.readToken(" ");
        return result;
    }

    @Override
    public void writeString(String stringValue) {
        if (stringValue == null) {
            this.basicWriteString("n ");
            return;
        }
        this.basicWriteString("s");
        this.basicWriteString(String.valueOf(stringValue.length()));
        this.basicWriteString(":");
        this.basicWriteString(stringValue);
        this.basicWriteString(" ");
    }

    @Override
    public String readString() {
        String token = this.nextToken();
        if (token.equals("n")) {
            this.readToken(" ");
            return null;
        }
        int size = Integer.valueOf(token.substring(1));
        this.readToken(":");
        String result = this.readNCharacters(size);
        this.readToken(" ");
        return result;
    }

    protected String readNCharacters(int size) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            buffer.append(this.lookAheadChar);
            this.basicReadChar();
        }
        return buffer.toString();
    }

    @Override
    public <T extends Enum<T>> void writeEnum(T enumValue) {
        if (enumValue == null) {
            this.basicWriteString("n ");
            return;
        }
        String enumLiteral = enumValue.name();
        this.basicWriteString("#");
        this.basicWriteString(String.valueOf(enumLiteral.length()));
        this.basicWriteString(":");
        this.basicWriteString(enumLiteral);
        this.basicWriteString(" ");
    }

    @Override
    public <T extends Enum<T>> T readEnum(Class<T> enumClass) {
        String readString = this.readString();
        if (readString == null) {
            return null;
        }
        return Enum.valueOf(enumClass, readString);
    }

    protected void basicWriteString(String value) {
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            this.errorHandler.handleError(2, "I/O error: " + e.getMessage());
        }
    }

    protected void readToken(String exceptedToken) {
        String token = this.nextToken();
        if (!token.equals(exceptedToken)) {
            this.errorHandler.handleError(2, "Expecting '" + exceptedToken + "' but read '" + token + "'");
        }
    }

    protected String nextToken() {
        if (this.eof) {
            return null;
        }
        StringBuilder tokenBuffer = new StringBuilder();
        while (true) {
            switch (this.lookAheadChar) {
                case ' ': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (tokenBuffer.length() == 0) {
                        tokenBuffer.append(this.lookAheadChar);
                        this.basicReadChar();
                    }
                    return tokenBuffer.toString();
                }
            }
            tokenBuffer.append(this.lookAheadChar);
            this.basicReadChar();
        }
    }

    protected void basicReadChar() {
        try {
            int read = this.reader.read();
            this.eof = read == -1;
            this.lookAheadChar = (char)read;
        }
        catch (IOException e) {
            this.errorHandler.handleError(2, "I/O error: " + e.getMessage());
        }
    }

    protected Class<? extends BoostObject> findClass(String boostName) {
        String className = boostName;
        if (this.getClassBoostNameMap().containsKey(boostName)) {
            className = this.getClassBoostNameMap().get(boostName);
        }
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.errorHandler.handleError(2, "Class not found error: " + e.getMessage());
            return null;
        }
    }

    protected Map<String, String> getClassBoostNameMap() {
        if (this.boostNameToClassName != null) {
            return this.boostNameToClassName;
        }
        return Collections.emptyMap();
    }

    protected <T extends BoostObject> T resolveReference(String reference, Class<T> objectClass) {
        this.errorHandler.handleError(2, "This Boost implementation doesn't handle references (ref: " + reference + ").");
        return null;
    }
}

