/*
 * Decompiled with CFR 0.152.
 */
package obp.dot.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import obp.dot.Edge;
import obp.dot.Graph;
import obp.dot.Node;
import obp.dot.NodeShape;

public class DotParserContext {
    public static final String LABEL = "label";
    public static final String HEADLABEL = "headlabel";
    public static final String TAILLABEL = "taillabel";
    public static final String BOUNDINGBOX = "bb";
    public static final String POSITION = "pos";
    public static final String LABELPOSITION = "lp";
    public static final String HEADLABELPOSITION = "head_lp";
    public static final String TAILLABELPOSITION = "tail_lp";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String COLOR = "color";
    public static final String SHAPE = "shape";
    public static final String PERIPHERIES = "peripheries";
    public static final String SIDES = "sides";
    public static final String DPI = "dpi";
    private Map<String, Node> nodes;
    private Graph graph;
    private List<float[]> toBeTransformed;
    private float[] transformation;
    private Stack<Map<String, String>> graphProperties;
    private Stack<Map<String, String>> nodeProperties;
    private Stack<Map<String, String>> edgeProperties;

    public void init() {
        if (this.graph == null) {
            this.graph = new Graph();
        }
        this.nodes = new HashMap<String, Node>();
        this.toBeTransformed = new ArrayList<float[]>();
        this.transformation = null;
        this.graphProperties = new Stack();
        this.nodeProperties = new Stack();
        this.edgeProperties = new Stack();
    }

    public void pushContext() {
        this.graphProperties.push(new HashMap());
        this.nodeProperties.push(new HashMap());
        this.edgeProperties.push(new HashMap());
    }

    public void popContext() {
        this.graphProperties.pop();
        this.nodeProperties.pop();
        this.edgeProperties.pop();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void createNodes(List<String> names, Map<String, String> properties) {
        for (String name : names) {
            this.getOrCreateNode(name, properties);
        }
    }

    public Node getOrCreateNode(String name, Map<String, String> properties) {
        Node node = this.nodes.get(name);
        if (node == null) {
            node = new Node();
            this.nodes.put(name, node);
            this.graph.addNode(node);
        }
        node.setId(name);
        if (properties != null) {
            if ((properties = this.constructProperties(properties, this.nodeProperties)).containsKey(LABEL)) {
                node.setLabel(this.processLabel(properties.get(LABEL)));
            }
            float[] position = new float[4];
            if (properties.containsKey(POSITION)) {
                float[] decoded = this.decodePosition(properties.get(POSITION));
                position[0] = decoded[0];
                position[1] = decoded[1];
                position[2] = decoded[0];
                position[3] = decoded[1];
            }
            float width = 50.0f;
            if (properties.containsKey(WIDTH)) {
                try {
                    width = Float.parseFloat(properties.get(WIDTH)) * this.getGraph().getDpi();
                }
                catch (Exception e) {
                    System.err.println("Unsupported width '" + properties.get(WIDTH) + "'.");
                }
            }
            position[0] = position[0] - width / 2.0f;
            position[2] = position[2] + width / 2.0f;
            float height = 50.0f;
            if (properties.containsKey(HEIGHT)) {
                try {
                    height = Float.parseFloat(properties.get(HEIGHT)) * this.getGraph().getDpi();
                }
                catch (Exception e) {
                    System.err.println("Unsupported height '" + properties.get(HEIGHT) + "'.");
                }
            }
            position[1] = position[1] - height / 2.0f;
            position[3] = position[3] + height / 2.0f;
            if (node.getPosition() == null) {
                node.setPosition(position);
            }
            if (properties.containsKey(LABELPOSITION)) {
                node.setLabelPosition(this.decodePosition(properties.get(LABELPOSITION)));
            }
            if (properties.containsKey(SHAPE)) {
                try {
                    node.setShape(NodeShape.valueOf(properties.get(SHAPE)));
                }
                catch (Exception e) {
                    System.err.println("Unsupported shape '" + properties.get(SHAPE) + "'.");
                }
            }
            if (properties.containsKey(PERIPHERIES)) {
                try {
                    node.setPeripheries(Integer.parseInt(properties.get(PERIPHERIES)));
                }
                catch (Exception e) {
                    System.err.println("Unsupported peripheries '" + properties.get(PERIPHERIES) + "'.");
                }
            }
            if (properties.containsKey(SIDES)) {
                try {
                    node.setSides(Integer.parseInt(properties.get(SIDES)));
                }
                catch (Exception e) {
                    System.err.println("Unsupported sides '" + properties.get(SIDES) + "'.");
                }
            }
            node.setColor(properties.get(COLOR));
        }
        if (node.getPosition() == null) {
            node.setPosition(new float[4]);
        }
        return node;
    }

    public void createEdges(List<String> sources, List<String> targets, Map<String, String> properties) {
        for (String source : sources) {
            for (String target : targets) {
                this.createEdge(source, target, properties);
            }
        }
    }

    public Edge createEdge(String source, String target, Map<String, String> properties) {
        Edge edge = new Edge();
        this.graph.addEdge(edge);
        edge.setSource(this.getOrCreateNode(source, null));
        edge.setTarget(this.getOrCreateNode(target, null));
        float[] position = new float[4];
        if (properties != null) {
            if ((properties = this.constructProperties(properties, this.edgeProperties)).containsKey(LABEL)) {
                edge.setLabel(this.processLabel(properties.get(LABEL)));
            }
            if (properties.containsKey(HEADLABEL)) {
                edge.setHeadLabel(this.processLabel(properties.get(HEADLABEL)));
            }
            if (properties.containsKey(TAILLABEL)) {
                edge.setTailLabel(this.processLabel(properties.get(TAILLABEL)));
            }
            if (properties.containsKey(POSITION)) {
                String positionString = properties.get(POSITION);
                position = this.decodePosition(positionString);
                edge.setStart(this.decodeStart(positionString));
                edge.setEnd(this.decodeEnd(positionString));
            }
            if (properties.containsKey(LABELPOSITION)) {
                edge.setLabelPosition(this.decodePosition(properties.get(LABELPOSITION)));
            }
            if (properties.containsKey(HEADLABELPOSITION)) {
                edge.setHeadLabelPosition(this.decodePosition(properties.get(HEADLABELPOSITION)));
            }
            if (properties.containsKey(TAILLABELPOSITION)) {
                edge.setTailLabelPosition(this.decodePosition(properties.get(TAILLABELPOSITION)));
            }
        }
        edge.setPosition(position);
        return edge;
    }

    private String processLabel(String label) {
        return label.replaceAll("\\\\n", "\n");
    }

    private float[] decodePosition(String position) {
        String[] stringPoints = position.split(" ");
        ArrayList<String> filtered = new ArrayList<String>();
        for (int i = 0; i < stringPoints.length; ++i) {
            String stringPoint = stringPoints[i];
            if (stringPoint.startsWith("e,") || stringPoint.startsWith("s,")) continue;
            filtered.add(stringPoint);
        }
        return this.parseAndTransform(filtered.toArray(new String[filtered.size()]));
    }

    private float[] decodeStart(String position) {
        return this.decodeSpecific("s,", position);
    }

    private float[] decodeEnd(String position) {
        return this.decodeSpecific("e,", position);
    }

    private float[] decodeSpecific(String prefix, String position) {
        String[] stringPoints = position.split(" ");
        for (int i = 0; i < stringPoints.length; ++i) {
            String stringPoint = stringPoints[i];
            if (!stringPoint.startsWith(prefix)) continue;
            stringPoint = stringPoint.substring(2);
            return this.parseAndTransform(stringPoint);
        }
        return null;
    }

    private float[] parseAndTransform(String ... stringPoints) {
        if (stringPoints == null) {
            return null;
        }
        float[] points = new float[stringPoints.length * 2];
        for (int i = 0; i < stringPoints.length; ++i) {
            String stringPoint = stringPoints[i];
            String[] fragments = stringPoint.split(",");
            points[i * 2] = Float.parseFloat(fragments[0]);
            points[i * 2 + 1] = Float.parseFloat(fragments[1]);
        }
        if (this.transformation == null) {
            this.toBeTransformed.add(points);
        } else {
            DotParserContext.transform(this.transformation, points);
        }
        return points;
    }

    private void computeBoundingBox(String string) {
        String[] fragments = string.split(",");
        float[] boundingBox = new float[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            boundingBox[i] = Float.parseFloat(fragments[i]);
        }
        this.transformation = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, boundingBox[3]};
        for (float[] points : this.toBeTransformed) {
            DotParserContext.transform(this.transformation, points);
        }
        this.toBeTransformed = null;
    }

    public void addProperties(int type, Map<String, String> properties) {
        switch (type) {
            case 2: {
                if (this.transformation == null && this.graphProperties.size() == 1 && properties.containsKey(BOUNDINGBOX)) {
                    this.computeBoundingBox(properties.get(BOUNDINGBOX));
                }
                this.graphProperties.peek().putAll(properties);
                break;
            }
            case 3: {
                this.nodeProperties.peek().putAll(properties);
                break;
            }
            case 4: {
                this.edgeProperties.peek().putAll(properties);
            }
        }
    }

    public void addProperty(int type, String name, String value) {
        this.addProperties(type, Collections.singletonMap(name, value));
    }

    public Map<String, String> constructProperties(Map<String, String> specific, Stack<Map<String, String>> context) {
        for (int i = context.size() - 1; i >= 0; --i) {
            for (String key : ((Map)context.get(i)).keySet()) {
                if (specific.containsKey(key)) continue;
                specific.put(key, (String)((Map)context.get(i)).get(key));
            }
        }
        return specific;
    }

    public static float transformX(float[] tr, float x, float y) {
        return x * tr[0] + y * tr[2] + tr[4];
    }

    public static float transformY(float[] tr, float x, float y) {
        return x * tr[1] + y * tr[3] + tr[5];
    }

    public static void transform(float[] tr, float[] points) {
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            float x = points[i];
            float y = points[j];
            points[i] = DotParserContext.transformX(tr, x, y);
            points[j] = DotParserContext.transformY(tr, x, y);
            i += 2;
        }
    }
}

