/*
 * Decompiled with CFR 0.152.
 */
package obp.states.parser;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.states.Element;
import obp.states.Match;
import obp.states.Message;
import obp.states.Observer;
import obp.states.PID;
import obp.states.Process;
import obp.states.State;
import obp.states.States;
import obp.states.Time;
import obp.states.Value;
import obp.states.ValueArray;
import obp.states.ValueSimple;
import obp.states.ValueStructure;
import obp.states.Variable;

public class StatesParserHelper {
    private final HashMap<Process, Process> processCache = new HashMap();
    private final HashMap<Observer, Observer> observerCache = new HashMap();
    private final HashMap<Message, Message> messageCache = new HashMap();
    private final HashMap<Match, Match> matchCache = new HashMap();
    private final HashMap<PID, PID> pidCache = new HashMap();
    private final HashMap<Time, Time> timeCache = new HashMap();
    private final HashMap<Variable, Variable> variableCache = new HashMap();
    private final HashMap<ValueArray, ValueArray> valueArrayCache = new HashMap();
    private final HashMap<ValueStructure, ValueStructure> valueStructureCache = new HashMap();
    private final HashMap<ValueSimple, ValueSimple> valueSimpleCache = new HashMap();

    private <T> T cache(T value, Map<T, T> cache) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        cache.put(value, value);
        return value;
    }

    private <T> T[] toArray(List<T> list, Class<T> clazz) {
        if (list == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(array);
        return array;
    }

    public States createStates(List<State> stateList) {
        State[] stateArray = this.toArray(stateList, State.class);
        return new States(stateArray);
    }

    public State createState(int id, ArrayList<Element> processList, Time time) {
        Element[] processArray = this.toArray(processList, Element.class);
        return new State(id, processArray, time);
    }

    public Process createProcess(String currentState, ArrayList<Variable> variableList, ArrayList<Variable> parameterList, PID pid, ArrayList<Message> messageList) {
        Variable[] variableArray = this.toArray(variableList, Variable.class);
        Variable[] parameterArray = this.toArray(parameterList, Variable.class);
        Message[] messageArray = this.toArray(messageList, Message.class);
        Process process = new Process(pid, currentState, variableArray, parameterArray, messageArray);
        return this.cache(process, this.processCache);
    }

    public Observer createObserver(String currentState, ArrayList<Variable> variableList, PID pid, ArrayList<Match> matchList) {
        Variable[] variableArray = this.toArray(variableList, Variable.class);
        Match[] matchArray = this.toArray(matchList, Match.class);
        Observer observer = new Observer(pid, currentState, variableArray, matchArray);
        return this.cache(observer, this.observerCache);
    }

    public Message createMessage(String name, ArrayList<Variable> parameterList) {
        Variable[] parameterArray = this.toArray(parameterList, Variable.class);
        Message message = new Message(name, parameterArray);
        return this.cache(message, this.messageCache);
    }

    public Match createMatch(String value) {
        Match match = new Match(value);
        return this.cache(match, this.matchCache);
    }

    public PID createPID(String name, int id) {
        PID pid = new PID(name, id);
        return this.cache(pid, this.pidCache);
    }

    public Time createTime(List<String> constrainList) {
        String[] constrainArray = this.toArray(constrainList, String.class);
        Time time = new Time(constrainArray);
        return this.cache(time, this.timeCache);
    }

    public Variable createVariable(String name, Value value) {
        Variable variable = new Variable(name, value);
        return this.cache(variable, this.variableCache);
    }

    public ValueArray createValueArray(ArrayList<Value> valueList) {
        Value[] valueArray = this.toArray(valueList, Value.class);
        ValueArray array = new ValueArray(valueArray);
        return this.cache(array, this.valueArrayCache);
    }

    public ValueStructure createValueStructure(ArrayList<Variable> valueList) {
        Variable[] valueArray = this.toArray(valueList, Variable.class);
        ValueStructure valueStructure = new ValueStructure(valueArray);
        return this.cache(valueStructure, this.valueStructureCache);
    }

    public ValueSimple createValueSimple(String string) {
        ValueSimple value = new ValueSimple(string);
        return this.cache(value, this.valueSimpleCache);
    }
}

