/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.Map;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Constr;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.DependencyManager;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentHandler;

public class TypeGenerator {
    private final ProgramGenerator caller;
    private final JavaContentHandler content;

    public TypeGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    public DependencyManager getDependencyManager() {
        return this.caller.getDependencyManager();
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.caller.getExpressionGenerator();
    }

    public void createTypeClass(TypeDecl typeDecl) {
        String typeName = NameUtil.capName(typeDecl.getName());
        if (typeDecl.getIs() instanceof Record) {
            this.createRecordClass(typeName, (Record)typeDecl.getIs());
        } else if (typeDecl.getIs() instanceof Union) {
            this.createUnionClass(typeName, (Union)typeDecl.getIs());
        }
    }

    private void createRecordClass(String typeName, Record record) {
        this.getDependencyManager().clear();
        this.content.beginFile(typeName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("org.xid.basics.serializer.BoostObject");
        this.content.beginClass(4, typeName, null, "BoostObject");
        for (Field field : record.getFieldList()) {
            String name = NameUtil.uncapName(field.getName());
            String typeDeclaration = TypeUtil.toJavaDeclaration(field.getType(), this.caller.getTypeNames());
            this.content.beginAttribute(4, typeDeclaration, name);
            this.content.endAttribute(name);
        }
        this.generateRecordConstructors(typeName, record);
        this.generateRecordWriteMethod(typeName, record);
        this.generateRecordEqualsAndHashCode(typeName, record);
        this.generateRecordToString(typeName, record);
        this.content.endClass(typeName);
        this.caller.generateImports();
        this.content.endFile(typeName + ".java");
    }

    private void generateRecordConstructors(String typeName, Record record) {
        this.content.beginMethod(4, null, typeName, null, new Java.Parameter[0]);
        for (Field field : record.getFieldList()) {
            String name = NameUtil.uncapName(field.getName());
            this.content.codeln(0, "this." + name + " = " + this.generateJavaInitialValue(field.getType(), this.caller.getTypeNames()) + ";");
        }
        this.content.endMethod(typeName);
        if (record.getFieldCount() > 0) {
            Java.Parameter[] parameters = new Java.Parameter[record.getFieldCount()];
            for (int i = 0; i < record.getFieldCount(); ++i) {
                Field field = record.getField(i);
                String declaration = TypeUtil.toJavaDeclaration(field.getType(), this.getTypeNames());
                String name = NameUtil.uncapName(field.getName());
                parameters[i] = new Java.Parameter(0, declaration, name);
            }
            this.content.beginMethod(4, null, typeName, null, parameters);
            for (Java.Parameter parameter : parameters) {
                this.content.codeln(0, "this." + parameter.name + " = " + parameter.name + ";");
            }
            this.content.endMethod(typeName);
        }
        this.content.beginMethod(4, null, typeName, null, new Java.Parameter[]{new Java.Parameter(0, typeName, "other")});
        for (Field field : record.getFieldList()) {
            String name = NameUtil.uncapName(field.getName());
            this.copyCode(0, field.getType(), "this." + name, "other." + name);
        }
        this.content.endMethod(typeName);
        this.content.beginMethod(4, null, typeName, null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost")});
        this.content.codeln(0, "boost.register(this);");
        for (Field field : record.getFieldList()) {
            String name = "this." + NameUtil.uncapName(field.getName());
            this.boostReadCode(0, field.getType(), name);
        }
        this.content.endMethod(typeName);
    }

    private void generateRecordWriteMethod(String typeName, Record record) {
        this.getDependencyManager().getShortName("org.xid.basics.serializer.Boost");
        this.content.beginMethod(4, "void", "writeToBoost", null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost")});
        for (Field field : record.getFieldList()) {
            String name = NameUtil.uncapName(field.getName());
            this.boostWriteCode(0, field.getType(), name);
        }
        this.content.endMethod("writeToBoost");
    }

    private void generateRecordEqualsAndHashCode(String typeName, Record record) {
        String name;
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "boolean", "equals", null, new Java.Parameter[]{new Java.Parameter(0, "Object", "object")});
        this.content.codeln(0, "if (object instanceof " + typeName + ") {");
        this.content.codeln(1, typeName + " other = (" + typeName + ") object;");
        for (Field field : record.getFieldList()) {
            name = NameUtil.uncapName(field.getName());
            Type type = field.getType();
            this.generateEqualsCode(name, type);
        }
        this.content.codeln(1, "return true;");
        this.content.codeln(0, "}");
        this.content.codeln(0, "return false;");
        this.content.endMethod("equals");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "int", "hashCode", null, new Java.Parameter[0]);
        this.content.codeln(0, "int total = 17;");
        for (Field field : record.getFieldList()) {
            name = NameUtil.uncapName(field.getName());
            this.generateHashcodeCode(name, field.getType());
        }
        this.content.codeln(0, "return total;");
        this.content.endMethod("hashCode");
    }

    private void generateRecordToString(String typeName, Record record) {
        this.content.beginMethod(4, "String", "toString", null, new Java.Parameter[0]);
        this.content.codeln(0, "StringBuilder text = new StringBuilder();");
        this.content.codeln(0, "text.append(\"{\");");
        boolean first = true;
        for (Field field : record.getFieldList()) {
            String name = NameUtil.uncapName(field.getName());
            this.content.codeln(0, "text.append(\"" + (first ? "" : ",") + field.getName() + "=\");");
            this.content.codeln(0, "text.append(" + TypeUtil.generateToStringCode(name, field.getType(), this.getDependencyManager()) + ");");
            first = false;
        }
        this.content.codeln(0, "text.append(\"}\");");
        this.content.codeln(0, "return text.toString();");
        this.content.endMethod("toString");
    }

    private void createUnionClass(String typeName, Union union) {
        this.getDependencyManager().clear();
        this.content.beginFile(typeName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("org.xid.basics.serializer.BoostObject");
        this.content.beginClass(36, typeName, null, "BoostObject");
        for (int i = 0; i < union.getConstrCount(); ++i) {
            Constr constr = union.getConstr(i);
            String constrName = NameUtil.capName(constr.getName());
            this.content.beginClass(12, constrName, typeName, null);
            if (constr.getType() != null) {
                String typeDeclaration = TypeUtil.toJavaDeclaration(constr.getType(), this.getTypeNames());
                this.content.beginAttribute(4, typeDeclaration, "value");
                this.content.endAttribute("value");
            }
            this.generateConstrConstructors(constr);
            this.generateConstrReadWriteMethod(i, constr);
            this.generateConstrEqualsAndHashCode(constr);
            this.generateConstrToString(constr);
            this.content.endClass(constrName);
        }
        this.generateUnionCopyMethod(typeName, union);
        this.content.endClass(typeName);
        this.caller.generateImports();
        this.content.endFile(typeName + ".java");
    }

    private void generateConstrConstructors(Constr constr) {
        String constrName = NameUtil.capName(constr.getName());
        this.content.beginMethod(4, null, constrName, null, new Java.Parameter[0]);
        if (constr.getType() != null) {
            this.content.codeln(0, "this.value = " + this.generateJavaInitialValue(constr.getType(), this.caller.getTypeNames()) + ";");
        }
        this.content.endMethod(constrName);
        if (constr.getType() != null) {
            String declaration = TypeUtil.toJavaDeclaration(constr.getType(), this.getTypeNames());
            this.content.beginMethod(4, null, constrName, null, new Java.Parameter[]{new Java.Parameter(0, declaration, "value")});
            this.content.codeln(0, "this.value = value;");
            this.content.endMethod(constrName);
        }
        this.content.beginMethod(4, null, constrName, null, new Java.Parameter[]{new Java.Parameter(0, constrName, "other")});
        if (constr.getType() != null) {
            this.copyCode(0, constr.getType(), "this.value", "other.value");
        }
        this.content.endMethod(constrName);
        this.content.beginMethod(4, null, constrName, null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost")});
        this.content.codeln(0, "boost.register(this);");
        if (constr.getType() != null) {
            this.boostReadCode(0, constr.getType(), "this.value");
        }
        this.content.endMethod(constrName);
    }

    private void generateConstrReadWriteMethod(int index, Constr constr) {
        this.getDependencyManager().getShortName("org.xid.basics.serializer.Boost");
        this.content.beginMethod(4, "void", "writeToBoost", null, new Java.Parameter[]{new Java.Parameter(0, "Boost", "boost")});
        if (constr.getType() != null) {
            this.boostWriteCode(0, constr.getType(), "value");
        }
        this.content.endMethod("write");
    }

    private void generateConstrEqualsAndHashCode(Constr constr) {
        String constrName = NameUtil.capName(constr.getName());
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "boolean", "equals", null, new Java.Parameter[]{new Java.Parameter(0, "Object", "object")});
        if (constr.getType() != null) {
            this.content.codeln(0, "if (object instanceof " + constrName + ") {");
            this.content.codeln(1, constrName + " other = (" + constrName + ") object;");
            String name = NameUtil.uncapName("value");
            this.generateEqualsCode(name, constr.getType());
            this.content.codeln(1, "return true;");
            this.content.codeln(0, "}");
            this.content.codeln(0, "return false;");
        } else {
            this.content.codeln(0, "return object != null && object.getClass() == " + constrName + ".class;");
        }
        this.content.endMethod("equals");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "int", "hashCode", null, new Java.Parameter[0]);
        int x = (int)(Math.random() * 1000003.0);
        this.content.codeln(0, "int total = " + x + ";");
        if (constr.getType() != null) {
            String name = NameUtil.uncapName("value");
            this.generateHashcodeCode(name, constr.getType());
        }
        this.content.codeln(0, "return total;");
        this.content.endMethod("hashCode");
    }

    private void generateConstrToString(Constr constr) {
        this.content.beginMethod(4, "String", "toString", null, new Java.Parameter[0]);
        this.content.codeln(0, "StringBuilder text = new StringBuilder();");
        this.content.codeln(0, "text.append(\"{" + constr.getName() + "\");");
        if (constr.getType() != null) {
            this.content.codeln(0, "text.append(\"@\");");
            this.content.codeln(0, "text.append(" + TypeUtil.generateToStringCode("value", constr.getType(), this.getDependencyManager()) + ");");
        }
        this.content.codeln(0, "text.append(\"}\");");
        this.content.codeln(0, "return text.toString();");
        this.content.endMethod("toString");
    }

    private void generateUnionCopyMethod(String typeName, Union union) {
        this.content.beginMethod(12, typeName, "copy", null, new Java.Parameter[]{new Java.Parameter(0, typeName, "other")});
        this.content.codeln(0, "if (other == null) {");
        this.content.codeln(1, "return null;");
        this.content.codeln(0, "}");
        for (int i = 0; i < union.getConstrCount(); ++i) {
            String constrName = NameUtil.capName(union.getConstr(i).getName());
            this.content.codeln(0, "else if ( other.getClass() == " + constrName + ".class ) {");
            this.content.codeln(1, "return new " + constrName + "((" + constrName + ") other);");
            this.content.codeln(0, "}");
        }
        this.content.codeln(0, "throw new IllegalArgumentException(\"Unknown constructor for '" + typeName + "'.\");");
        this.content.endMethod("copy");
    }

    public String generateJavaInitialValue(Type type, Map<Type, String> typeNames) {
        return this.javaInitialValueInternal(true, type, typeNames);
    }

    private String javaInitialValueInternal(boolean root, Type type, Map<Type, String> typeNames) {
        if (type instanceof BoolType) {
            return "false";
        }
        if (type instanceof IntType || type instanceof NatType) {
            return "0";
        }
        if (type instanceof Interval) {
            return this.caller.getExpressionGenerator().generateForBehavior(CInt.intType, ((Interval)type).getMini());
        }
        if (type instanceof TypeId) {
            return this.javaInitialValueInternal(true, ((TypeId)type).getDecl().getIs(), typeNames);
        }
        if (type instanceof Array) {
            Array array = (Array)type;
            int size = TypeUtil.computeArraySizeExpression(array.getSize());
            String childInitial = this.javaInitialValueInternal(false, array.getType(), typeNames);
            StringBuilder literal = new StringBuilder();
            if (root) {
                literal.append("new ");
                literal.append(TypeUtil.toJavaDeclaration(type, typeNames));
            }
            literal.append("{");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    literal.append(",");
                }
                literal.append(childInitial);
            }
            literal.append("}");
            return literal.toString();
        }
        if (type instanceof Queue) {
            StringBuilder literal = new StringBuilder();
            literal.append("new ");
            literal.append(TypeUtil.toJavaDeclaration(type, typeNames));
            literal.append("{}");
            return literal.toString();
        }
        if (type instanceof Union) {
            Union union = (Union)type;
            Constr first = union.getConstr(0);
            String constrName = NameUtil.capName(first.getName());
            return "new " + typeNames.get(type) + "." + constrName + "()";
        }
        return "new " + typeNames.get(type) + "()";
    }

    public void copyCode(int level, Type type, String leftVariable, String rightVariable) {
        if (TypeUtil.isPrimitiveJavaType(type = TypeUtil.referencedType(type))) {
            this.content.codeln(level, leftVariable + " = " + rightVariable + ";");
        } else if (type instanceof Array) {
            Array array = (Array)type;
            int dimension = TypeUtil.arrayOrQueueDimension(array.getType());
            Type inner = TypeUtil.arrayOrQueueOf(array.getType());
            StringBuilder newCode = new StringBuilder();
            newCode.append(leftVariable);
            newCode.append(" = new ");
            newCode.append(TypeUtil.toJavaDeclaration(inner, this.getTypeNames()));
            newCode.append("[");
            newCode.append(this.getExpressionGenerator().generateForBehavior(CInt.intType, array.getSize()));
            newCode.append("]");
            for (int i = 0; i < dimension - 1; ++i) {
                newCode.append("[]");
            }
            newCode.append(";");
            this.content.codeln(level, newCode.toString());
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + rightVariable + ".length; " + iName + "++) {");
            this.copyCode(level + 1, array.getType(), leftVariable + "[" + iName + "]", rightVariable + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else if (type instanceof Queue) {
            Queue queue = (Queue)type;
            int dimension = TypeUtil.arrayOrQueueDimension(queue.getType());
            Type inner = TypeUtil.arrayOrQueueOf(queue.getType());
            StringBuilder newCode = new StringBuilder();
            newCode.append(leftVariable);
            newCode.append(" = new ");
            newCode.append(TypeUtil.toJavaDeclaration(inner, this.getTypeNames()));
            newCode.append("[");
            newCode.append(rightVariable + ".length");
            newCode.append("]");
            for (int i = 0; i < dimension - 1; ++i) {
                newCode.append("[]");
            }
            newCode.append(";");
            this.content.codeln(level, newCode.toString());
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + rightVariable + ".length; " + iName + "++) {");
            this.copyCode(level + 1, ((Queue)type).getType(), leftVariable + "[" + iName + "]", rightVariable + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else if (type instanceof Union) {
            this.content.codeln(level, leftVariable + " = " + this.getTypeNames().get(type) + ".copy(" + rightVariable + ");");
        } else {
            this.content.codeln(level, leftVariable + " = new " + this.getTypeNames().get(type) + "(" + rightVariable + ");");
        }
    }

    public void boostReadCode(int level, Type type, String variableName) {
        if (type instanceof BoolType) {
            this.content.codeln(level, variableName + " = boost.readBoolean();");
        } else if (type instanceof IntType || type instanceof NatType) {
            this.content.codeln(level, variableName + " = boost.readInt();");
        } else if (type instanceof Interval) {
            this.content.codeln(level, variableName + " = boost.readInt();");
        } else if (type instanceof TypeId) {
            Type referenced = ((TypeId)type).getDecl().getIs();
            this.boostReadCode(level, referenced, variableName);
        } else if (type instanceof Array) {
            Array array = (Array)type;
            int dimension = TypeUtil.arrayOrQueueDimension(array.getType());
            Type inner = TypeUtil.arrayOrQueueOf(array.getType());
            StringBuilder newCode = new StringBuilder();
            newCode.append(variableName);
            newCode.append(" = new ");
            newCode.append(TypeUtil.toJavaDeclaration(inner, this.getTypeNames()));
            newCode.append("[");
            newCode.append(this.getExpressionGenerator().generateForBehavior(CInt.intType, array.getSize()));
            newCode.append("]");
            for (int i = 0; i < dimension - 1; ++i) {
                newCode.append("[]");
            }
            newCode.append(";");
            this.content.codeln(level, newCode.toString());
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + variableName + ".length; " + iName + "++) {");
            this.boostReadCode(level + 1, ((Array)type).getType(), variableName + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else if (type instanceof Queue) {
            Queue queue = (Queue)type;
            int dimension = TypeUtil.arrayOrQueueDimension(queue.getType());
            Type inner = TypeUtil.arrayOrQueueOf(queue.getType());
            StringBuilder newCode = new StringBuilder();
            newCode.append(variableName);
            newCode.append(" = new ");
            newCode.append(TypeUtil.toJavaDeclaration(inner, this.getTypeNames()));
            newCode.append("[");
            newCode.append(this.getExpressionGenerator().generateForBehavior(CInt.intType, queue.getSize()));
            newCode.append("]");
            for (int i = 0; i < dimension - 1; ++i) {
                newCode.append("[]");
            }
            newCode.append(";");
            this.content.codeln(level, newCode.toString());
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, variableName + " = new " + TypeUtil.toJavaDeclaration(queue.getType(), this.getTypeNames()) + "[boost.readInt()];");
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + variableName + ".length; " + iName + "++) {");
            this.boostReadCode(level + 1, queue.getType(), variableName + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else {
            this.content.codeln(level, variableName + " = boost.readObject(" + this.getTypeNames().get(type) + ".class);");
        }
    }

    public void boostWriteCode(int level, Type type, String variableName) {
        if (type instanceof BoolType) {
            this.content.codeln(level, "boost.writeBoolean(" + variableName + ");");
        } else if (type instanceof IntType || type instanceof NatType) {
            this.content.codeln(level, "boost.writeInt(" + variableName + ");");
        } else if (type instanceof Interval) {
            this.content.codeln(level, "boost.writeInt(" + variableName + ");");
        } else if (type instanceof TypeId) {
            Type referenced = ((TypeId)type).getDecl().getIs();
            this.boostWriteCode(level, referenced, variableName);
        } else if (type instanceof Array) {
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + variableName + ".length; " + iName + "++) {");
            this.boostWriteCode(level + 1, ((Array)type).getType(), variableName + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else if (type instanceof Queue) {
            char iName = ProgramGenerator.levelIterVariableName(level);
            this.content.codeln(level, "boost.writeInt(" + variableName + ".length);");
            this.content.codeln(level, "for (int " + iName + "=0; " + iName + "<" + variableName + ".length; " + iName + "++) {");
            this.boostWriteCode(level + 1, ((Queue)type).getType(), variableName + "[" + iName + "]");
            this.content.codeln(level, "}");
        } else {
            this.content.codeln(level, "boost.writeObject(" + variableName + ");");
        }
    }

    public void generateEqualsCode(String name, Type type) {
        if ((type = TypeUtil.referencedType(type)) instanceof Array) {
            Array array = (Array)type;
            this.getDependencyManager().getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(array.getType())) {
                this.content.codeln(1, "if (!Arrays.deepEquals(" + name + ", other." + name + ")) return false;");
            } else {
                this.content.codeln(1, "if (!Arrays.equals(" + name + ", other." + name + ")) return false;");
            }
        } else if (type instanceof Queue) {
            Queue queue = (Queue)type;
            this.getDependencyManager().getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(queue.getType())) {
                this.content.codeln(1, "if (!Arrays.deepEquals(" + name + ", other." + name + ")) return false;");
            } else {
                this.content.codeln(1, "if (!Arrays.equals(" + name + ", other." + name + ")) return false;");
            }
        } else if (type instanceof Union) {
            this.content.codeln(1, "if ( " + name + " == null && other." + name + " != null) return false;");
            this.content.codeln(1, "if ( " + name + " != null && !" + name + ".equals(other." + name + ")) return false;");
        } else if (TypeUtil.isGeneratedClassType(type)) {
            this.content.codeln(1, "if (!" + name + ".equals(other." + name + ")) return false;");
        } else {
            this.content.codeln(1, "if (" + name + " != other." + name + ") return false;");
        }
    }

    public void generateHashcodeCode(String name, Type type) {
        if ((type = TypeUtil.referencedType(type)) instanceof Array) {
            Array array = (Array)type;
            this.getDependencyManager().getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(array.getType())) {
                this.content.codeln(0, "total = total * 37 + Arrays.deepHashCode(" + name + ");");
            } else {
                this.content.codeln(0, "total = total * 37 + Arrays.hashCode(" + name + ");");
            }
        } else if (type instanceof Queue) {
            Queue queue = (Queue)type;
            this.getDependencyManager().getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(queue.getType())) {
                this.content.codeln(0, "total = total * 37 + Arrays.deepHashCode(" + name + ");");
            } else {
                this.content.codeln(0, "total = total * 37 + Arrays.hashCode(" + name + ");");
            }
        } else if (type instanceof Union) {
            this.content.codeln(0, "total = total * 37 + (" + name + " == null ? 0 : " + name + ".hashCode());");
        } else if (TypeUtil.isGeneratedClassType(type)) {
            this.content.codeln(0, "total = total * 37 + " + name + ".hashCode();");
        } else if (type instanceof BoolType) {
            this.content.codeln(0, "total = total * 37 + (" + name + "? 1 : 0);");
        } else {
            this.content.codeln(0, "total = total * 37 + " + name + ";");
        }
    }
}

